/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.views.java.simple;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.struts2.views.java.Attributes;
import org.apache.struts2.views.java.TagGenerator;
import org.apache.struts2.views.java.simple.AbstractTagHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FieldErrorHandler
extends AbstractTagHandler
implements TagGenerator {
    @Override
    public void generate() throws IOException {
        Map params = this.context.getParameters();
        Map errors = (Map)this.findValue("fieldErrors");
        List fieldErrorFieldNames = (List)params.get("errorFieldNames");
        if (fieldErrorFieldNames != null && !fieldErrorFieldNames.isEmpty() && errors != null && !errors.isEmpty()) {
            this.startUL(params);
            for (String fieldErrorFieldName : fieldErrorFieldNames) {
                List fieldErrors = (List)errors.get(fieldErrorFieldName);
                if (fieldErrors == null) continue;
                for (String fieldError : fieldErrors) {
                    this.writeError(params, fieldError);
                }
            }
            this.endUL();
        } else if (errors != null && !errors.isEmpty()) {
            this.startUL(params);
            for (Map.Entry errorEntry : errors.entrySet()) {
                for (String fieldError : (List)errorEntry.getValue()) {
                    this.writeError(params, fieldError);
                }
            }
            this.endUL();
        }
    }

    private void endUL() throws IOException {
        this.end("ul");
    }

    private void writeError(Map<String, Object> params, String fieldError) throws IOException {
        this.start("li", null);
        this.start("span", null);
        this.characters(fieldError, params.containsKey("escape") ? (Boolean)params.get("escape") : true);
        this.end("span");
        this.end("li");
    }

    private void startUL(Map<String, Object> params) throws IOException {
        Attributes attrs = new Attributes();
        attrs.addIfExists("style", params.get("cssStyle")).add("class", params.containsKey("cssClass") ? (String)params.get("cssClass") : "errorMessage");
        this.start("ul", attrs);
    }
}

