/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.views.java;

import com.opensymphony.xwork2.util.logging.Logger;
import com.opensymphony.xwork2.util.logging.LoggerFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.struts2.StrutsException;
import org.apache.struts2.components.template.TemplateRenderingContext;
import org.apache.struts2.views.java.TagGenerator;
import org.apache.struts2.views.java.TagHandler;
import org.apache.struts2.views.java.TagHandlerFactory;
import org.apache.struts2.views.java.Theme;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultTheme
implements Theme {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultTheme.class);
    private String name;
    protected Map<String, List<TagHandlerFactory>> handlerFactories;

    protected void setName(String name) {
        this.name = name;
    }

    protected void setHandlerFactories(Map<String, List<TagHandlerFactory>> handlers) {
        this.handlerFactories = handlers;
    }

    protected void setTagHandlerFactories(String tagName, List<TagHandlerFactory> handlers) {
        if (tagName != null && handlers != null && this.handlerFactories != null) {
            this.handlerFactories.put(tagName, handlers);
        }
    }

    protected void insertTagHandlerFactory(String tagName, int sequence, TagHandlerFactory factory) {
        if (tagName != null && factory != null && this.handlerFactories != null) {
            List<TagHandlerFactory> tagHandlerFactories = this.handlerFactories.get(tagName);
            if (tagHandlerFactories == null) {
                tagHandlerFactories = new ArrayList<TagHandlerFactory>();
            }
            if (sequence > tagHandlerFactories.size()) {
                sequence = tagHandlerFactories.size();
            }
            tagHandlerFactories.add(sequence, factory);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void renderTag(String tagName, TemplateRenderingContext context) {
        if (tagName.endsWith(".java")) {
            tagName = tagName.substring(0, tagName.length() - ".java".length());
        }
        ArrayList<TagHandler> handlers = new ArrayList<TagHandler>();
        List<TagHandlerFactory> factories = this.handlerFactories.get(tagName);
        if (factories == null) {
            throw new StrutsException("Unable to find handlers for tag " + tagName);
        }
        TagHandler prev = null;
        for (int x = factories.size() - 1; x >= 0; --x) {
            prev = factories.get(x).create(prev);
            prev.setup(context);
            handlers.add(0, prev);
        }
        TagGenerator gen = (TagGenerator)handlers.get(0);
        try {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Rendering tag [#0]", new String[]{tagName});
            }
            gen.generate();
        }
        catch (IOException ex) {
            throw new StrutsException("Unable to write tag: " + tagName, (Throwable)ex);
        }
    }
}

