/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.receiver;

import java.nio.ByteBuffer;
import org.apache.spark.annotation.DeveloperApi;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StreamBlockId;
import org.apache.spark.streaming.receiver.ReceiverSupervisor;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.mutable.ArrayBuffer;
import scala.reflect.ScalaSignature;

@DeveloperApi
@ScalaSignature(bytes="\u0006\u0001\u0005Ug!B\u0001\u0003\u0003\u0003i!\u0001\u0003*fG\u0016Lg/\u001a:\u000b\u0005\r!\u0011\u0001\u0003:fG\u0016Lg/\u001a:\u000b\u0005\u00151\u0011!C:ue\u0016\fW.\u001b8h\u0015\t9\u0001\"A\u0003ta\u0006\u00148N\u0003\u0002\n\u0015\u00051\u0011\r]1dQ\u0016T\u0011aC\u0001\u0004_J<7\u0001A\u000b\u0003\u001d)\u001a2\u0001A\b\u0016!\t\u00012#D\u0001\u0012\u0015\u0005\u0011\u0012!B:dC2\f\u0017B\u0001\u000b\u0012\u0005\u0019\te.\u001f*fMB\u0011\u0001CF\u0005\u0003/E\u0011AbU3sS\u0006d\u0017N_1cY\u0016D\u0001\"\u0007\u0001\u0003\u0006\u0004%\tAG\u0001\rgR|'/Y4f\u0019\u00164X\r\\\u000b\u00027A\u0011AdH\u0007\u0002;)\u0011aDB\u0001\bgR|'/Y4f\u0013\t\u0001SD\u0001\u0007Ti>\u0014\u0018mZ3MKZ,G\u000e\u0003\u0005#\u0001\t\u0005\t\u0015!\u0003\u001c\u00035\u0019Ho\u001c:bO\u0016dUM^3mA!)A\u0005\u0001C\u0001K\u00051A(\u001b8jiz\"\"AJ\u001a\u0011\u0007\u001d\u0002\u0001&D\u0001\u0003!\tI#\u0006\u0004\u0001\u0005\u000b-\u0002!\u0019\u0001\u0017\u0003\u0003Q\u000b\"!\f\u0019\u0011\u0005Aq\u0013BA\u0018\u0012\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"\u0001E\u0019\n\u0005I\n\"aA!os\")\u0011d\ta\u00017!)Q\u0007\u0001D\u0001m\u00059qN\\*uCJ$H#A\u001c\u0011\u0005AA\u0014BA\u001d\u0012\u0005\u0011)f.\u001b;\t\u000bm\u0002a\u0011\u0001\u001c\u0002\r=t7\u000b^8q\u0011\u0015i\u0004\u0001\"\u0001?\u0003E\u0001(/\u001a4feJ,G\rT8dCRLwN\\\u000b\u0002\u007fA\u0019\u0001\u0003\u0011\"\n\u0005\u0005\u000b\"AB(qi&|g\u000e\u0005\u0002D\r:\u0011\u0001\u0003R\u0005\u0003\u000bF\ta\u0001\u0015:fI\u00164\u0017BA$I\u0005\u0019\u0019FO]5oO*\u0011Q)\u0005\u0005\u0006\u0015\u0002!\taS\u0001\u0006gR|'/\u001a\u000b\u0003o1CQ!T%A\u0002!\n\u0001\u0002Z1uC&#X-\u001c\u0005\u0006\u0015\u0002!\ta\u0014\u000b\u0003oACQ!\u0015(A\u0002I\u000b!\u0002Z1uC\n+hMZ3s!\r\u0019\u0006\fK\u0007\u0002)*\u0011QKV\u0001\b[V$\u0018M\u00197f\u0015\t9\u0016#\u0001\u0006d_2dWm\u0019;j_:L!!\u0017+\u0003\u0017\u0005\u0013(/Y=Ck\u001a4WM\u001d\u0005\u0006\u0015\u0002!\ta\u0017\u000b\u0004oqk\u0006\"B)[\u0001\u0004\u0011\u0006\"\u00020[\u0001\u0004\u0001\u0014\u0001C7fi\u0006$\u0017\r^1\t\u000b)\u0003A\u0011\u00011\u0015\u0005]\n\u0007\"\u00022`\u0001\u0004\u0019\u0017\u0001\u00043bi\u0006LE/\u001a:bi>\u0014\bc\u00013mQ9\u0011QM\u001b\b\u0003M&l\u0011a\u001a\u0006\u0003Q2\ta\u0001\u0010:p_Rt\u0014\"\u0001\n\n\u0005-\f\u0012a\u00029bG.\fw-Z\u0005\u0003[:\u0014\u0001\"\u0013;fe\u0006$xN\u001d\u0006\u0003WFAQA\u0013\u0001\u0005\u0002A$2aN9z\u0011\u0015\u0011w\u000e1\u0001s!\r\u0019\b\u0010K\u0007\u0002i*\u0011QO^\u0001\u0005kRLGNC\u0001x\u0003\u0011Q\u0017M^1\n\u00055$\b\"\u00020p\u0001\u0004\u0001\u0004\"\u0002&\u0001\t\u0003YHCA\u001c}\u0011\u0015\u0011'\u00101\u0001s\u0011\u0015Q\u0005\u0001\"\u0001\u007f)\u00119t0!\u0001\t\u000b\tl\b\u0019A2\t\u000byk\b\u0019\u0001\u0019\t\r)\u0003A\u0011AA\u0003)\r9\u0014q\u0001\u0005\t\u0003\u0013\t\u0019\u00011\u0001\u0002\f\u0005)!-\u001f;fgB!\u0011QBA\n\u001b\t\tyAC\u0002\u0002\u0012Y\f1A\\5p\u0013\u0011\t)\"a\u0004\u0003\u0015\tKH/\u001a\"vM\u001a,'\u000f\u0003\u0004K\u0001\u0011\u0005\u0011\u0011\u0004\u000b\u0006o\u0005m\u0011Q\u0004\u0005\t\u0003\u0013\t9\u00021\u0001\u0002\f!1a,a\u0006A\u0002ABq!!\t\u0001\t\u0003\t\u0019#A\u0006sKB|'\u000f^#se>\u0014H#B\u001c\u0002&\u0005%\u0002bBA\u0014\u0003?\u0001\rAQ\u0001\b[\u0016\u001c8/Y4f\u0011!\tY#a\bA\u0002\u00055\u0012!\u0003;ie><\u0018M\u00197f!\r!\u0017qF\u0005\u0004\u0003cq'!\u0003+ie><\u0018M\u00197f\u0011\u001d\t)\u0004\u0001C\u0001\u0003o\tqA]3ti\u0006\u0014H\u000fF\u00028\u0003sAq!a\n\u00024\u0001\u0007!\tC\u0004\u00026\u0001!\t!!\u0010\u0015\u000b]\ny$!\u0011\t\u000f\u0005\u001d\u00121\ba\u0001\u0005\"A\u00111IA\u001e\u0001\u0004\ti#A\u0003feJ|'\u000fC\u0004\u00026\u0001!\t!a\u0012\u0015\u000f]\nI%a\u0013\u0002N!9\u0011qEA#\u0001\u0004\u0011\u0005\u0002CA\"\u0003\u000b\u0002\r!!\f\t\u0011\u0005=\u0013Q\ta\u0001\u0003#\n1\"\\5mY&\u001cXmY8oIB\u0019\u0001#a\u0015\n\u0007\u0005U\u0013CA\u0002J]RDq!!\u0017\u0001\t\u0003\tY&\u0001\u0003ti>\u0004HcA\u001c\u0002^!9\u0011qEA,\u0001\u0004\u0011\u0005bBA-\u0001\u0011\u0005\u0011\u0011\r\u000b\u0006o\u0005\r\u0014Q\r\u0005\b\u0003O\ty\u00061\u0001C\u0011!\t\u0019%a\u0018A\u0002\u00055\u0002bBA5\u0001\u0011\u0005\u00111N\u0001\nSN\u001cF/\u0019:uK\u0012$\"!!\u001c\u0011\u0007A\ty'C\u0002\u0002rE\u0011qAQ8pY\u0016\fg\u000eC\u0004\u0002v\u0001!\t!a\u001b\u0002\u0013%\u001c8\u000b^8qa\u0016$\u0007bBA=\u0001\u0011\u0005\u00111P\u0001\tgR\u0014X-Y7JIV\u0011\u0011\u0011\u000b\u0005\n\u0003\u007f\u0002\u0001\u0019!C\u0005\u0003w\n!!\u001b3\t\u0013\u0005\r\u0005\u00011A\u0005\n\u0005\u0015\u0015AB5e?\u0012*\u0017\u000fF\u00028\u0003\u000fC!\"!#\u0002\u0002\u0006\u0005\t\u0019AA)\u0003\rAH%\r\u0005\t\u0003\u001b\u0003\u0001\u0015)\u0003\u0002R\u0005\u0019\u0011\u000e\u001a\u0011\t\u0013\u0005E\u0005\u00011A\u0005\n\u0005M\u0015aC0tkB,'O^5t_J,\"!!&\u0011\u0007\u001d\n9*C\u0002\u0002\u001a\n\u0011!CU3dK&4XM]*va\u0016\u0014h/[:pe\"I\u0011Q\u0014\u0001A\u0002\u0013%\u0011qT\u0001\u0010?N,\b/\u001a:wSN|'o\u0018\u0013fcR\u0019q'!)\t\u0015\u0005%\u00151TA\u0001\u0002\u0004\t)\n\u0003\u0005\u0002&\u0002\u0001\u000b\u0015BAK\u00031y6/\u001e9feZL7o\u001c:!Q\u0011\t\u0019+!+\u0011\u0007A\tY+C\u0002\u0002.F\u0011\u0011\u0002\u001e:b]NLWM\u001c;\t\u0011\u0005E\u0006\u0001\"\u0001\u0005\u0003g\u000bQb]3u%\u0016\u001cW-\u001b<fe&#GcA\u001c\u00026\"A\u0011qWAX\u0001\u0004\t\t&A\u0002jI~C\u0001\"a/\u0001\t\u0003!\u0011QX\u0001\u0011CR$\u0018m\u00195TkB,'O^5t_J$2aNA`\u0011!\t\t-!/A\u0002\u0005U\u0015\u0001B3yK\u000eD\u0001\"!2\u0001\t\u0003!\u00111S\u0001\u000bgV\u0004XM\u001d<jg>\u0014\bf\u0001\u0001\u0002JB!\u00111ZAi\u001b\t\tiMC\u0002\u0002P\u001a\t!\"\u00198o_R\fG/[8o\u0013\u0011\t\u0019.!4\u0003\u0019\u0011+g/\u001a7pa\u0016\u0014\u0018\t]5")
public abstract class Receiver<T>
implements Serializable {
    private final StorageLevel storageLevel;
    private int id;
    private transient ReceiverSupervisor _supervisor;

    public StorageLevel storageLevel() {
        return this.storageLevel;
    }

    public abstract void onStart();

    public abstract void onStop();

    public Option<String> preferredLocation() {
        return None$.MODULE$;
    }

    public void store(T dataItem) {
        this.supervisor().pushSingle(dataItem);
    }

    public void store(ArrayBuffer<T> dataBuffer) {
        this.supervisor().pushArrayBuffer(dataBuffer, (Option<Object>)None$.MODULE$, (Option<StreamBlockId>)None$.MODULE$);
    }

    public void store(ArrayBuffer<T> dataBuffer, Object metadata) {
        this.supervisor().pushArrayBuffer(dataBuffer, (Option<Object>)new Some(metadata), (Option<StreamBlockId>)None$.MODULE$);
    }

    public void store(Iterator<T> dataIterator) {
        this.supervisor().pushIterator(dataIterator, (Option<Object>)None$.MODULE$, (Option<StreamBlockId>)None$.MODULE$);
    }

    public void store(java.util.Iterator<T> dataIterator, Object metadata) {
        this.supervisor().pushIterator((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(dataIterator).asScala(), (Option<Object>)new Some(metadata), (Option<StreamBlockId>)None$.MODULE$);
    }

    public void store(java.util.Iterator<T> dataIterator) {
        this.supervisor().pushIterator((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(dataIterator).asScala(), (Option<Object>)None$.MODULE$, (Option<StreamBlockId>)None$.MODULE$);
    }

    public void store(Iterator<T> dataIterator, Object metadata) {
        this.supervisor().pushIterator(dataIterator, (Option<Object>)new Some(metadata), (Option<StreamBlockId>)None$.MODULE$);
    }

    public void store(ByteBuffer bytes) {
        this.supervisor().pushBytes(bytes, (Option<Object>)None$.MODULE$, (Option<StreamBlockId>)None$.MODULE$);
    }

    public void store(ByteBuffer bytes, Object metadata) {
        this.supervisor().pushBytes(bytes, (Option<Object>)new Some(metadata), (Option<StreamBlockId>)None$.MODULE$);
    }

    public void reportError(String message, Throwable throwable) {
        this.supervisor().reportError(message, throwable);
    }

    public void restart(String message) {
        ReceiverSupervisor qual$1 = this.supervisor();
        String x$1 = message;
        Option<Throwable> x$2 = qual$1.restartReceiver$default$2();
        qual$1.restartReceiver(x$1, x$2);
    }

    public void restart(String message, Throwable error) {
        this.supervisor().restartReceiver(message, (Option<Throwable>)new Some((Object)error));
    }

    public void restart(String message, Throwable error, int millisecond) {
        this.supervisor().restartReceiver(message, (Option<Throwable>)new Some((Object)error), millisecond);
    }

    public void stop(String message) {
        this.supervisor().stop(message, (Option<Throwable>)None$.MODULE$);
    }

    public void stop(String message, Throwable error) {
        this.supervisor().stop(message, (Option<Throwable>)new Some((Object)error));
    }

    public boolean isStarted() {
        return this.supervisor().isReceiverStarted();
    }

    public boolean isStopped() {
        return this.supervisor().isReceiverStopped();
    }

    public int streamId() {
        return this.id();
    }

    private int id() {
        return this.id;
    }

    private void id_$eq(int x$1) {
        this.id = x$1;
    }

    private ReceiverSupervisor _supervisor() {
        return this._supervisor;
    }

    private void _supervisor_$eq(ReceiverSupervisor x$1) {
        this._supervisor = x$1;
    }

    public void setReceiverId(int id_) {
        this.id_$eq(id_);
    }

    public void attachSupervisor(ReceiverSupervisor exec) {
        Predef$.MODULE$.assert(this._supervisor() == null);
        this._supervisor_$eq(exec);
    }

    public ReceiverSupervisor supervisor() {
        Predef$.MODULE$.assert(this._supervisor() != null, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "A ReceiverSupervisor have not been attached to the receiver yet. Maybe you are starting some computation in the receiver before the Receiver.onStart() has been called.";
            }
        });
        return this._supervisor();
    }

    public Receiver(StorageLevel storageLevel) {
        this.storageLevel = storageLevel;
        this.id = -1;
        this._supervisor = null;
    }
}

