/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.jdbc;

import java.sql.Connection;
import org.apache.spark.sql.execution.datasources.jdbc.JdbcUtils$;
import org.apache.spark.sql.jdbc.JdbcDialect;
import org.apache.spark.sql.jdbc.JdbcType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MetadataBuilder;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.TimestampType$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.StringOps$;

public final class PostgresDialect$
extends JdbcDialect {
    public static final PostgresDialect$ MODULE$;

    static {
        new PostgresDialect$();
    }

    @Override
    public boolean canHandle(String url) {
        return url.startsWith("jdbc:postgresql");
    }

    @Override
    public Option<DataType> getCatalystType(int sqlType, String typeName, int size, MetadataBuilder md) {
        return sqlType == -7 && typeName.equals("bit") && size != 1 ? new Some((Object)BinaryType$.MODULE$) : (sqlType == 1111 ? this.toCatalystType(typeName).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(DataType x$1) {
                DataType dataType = x$1;
                StringType$ stringType$ = StringType$.MODULE$;
                return !(dataType != null ? !dataType.equals(stringType$) : stringType$ != null);
            }
        }) : (sqlType == 2003 && typeName.length() > 1 && StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(typeName), 0) == '_' ? this.toCatalystType((String)new StringOps(Predef$.MODULE$.augmentString(typeName)).drop(1)).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final ArrayType apply(DataType x$2) {
                return ArrayType$.MODULE$.apply(x$2);
            }
        }) : None$.MODULE$));
    }

    private Option<DataType> toCatalystType(String typeName) {
        Object object;
        String string = typeName;
        if ("bool".equals(string)) {
            object = new Some((Object)BooleanType$.MODULE$);
        } else if ("bit".equals(string)) {
            object = new Some((Object)BinaryType$.MODULE$);
        } else if ("int2".equals(string)) {
            object = new Some((Object)ShortType$.MODULE$);
        } else if ("int4".equals(string)) {
            object = new Some((Object)IntegerType$.MODULE$);
        } else {
            boolean bl = "int8".equals(string) ? true : "oid".equals(string);
            if (bl) {
                object = new Some((Object)LongType$.MODULE$);
            } else if ("float4".equals(string)) {
                object = new Some((Object)FloatType$.MODULE$);
            } else {
                boolean bl2 = "money".equals(string) ? true : "float8".equals(string);
                if (bl2) {
                    object = new Some((Object)DoubleType$.MODULE$);
                } else {
                    boolean bl3 = "text".equals(string) ? true : ("varchar".equals(string) ? true : ("char".equals(string) ? true : ("cidr".equals(string) ? true : ("inet".equals(string) ? true : ("json".equals(string) ? true : ("jsonb".equals(string) ? true : "uuid".equals(string)))))));
                    if (bl3) {
                        object = new Some((Object)StringType$.MODULE$);
                    } else if ("bytea".equals(string)) {
                        object = new Some((Object)BinaryType$.MODULE$);
                    } else {
                        boolean bl4 = "timestamp".equals(string) ? true : ("timestamptz".equals(string) ? true : ("time".equals(string) ? true : "timetz".equals(string)));
                        object = bl4 ? new Some((Object)TimestampType$.MODULE$) : ("date".equals(string) ? new Some((Object)DateType$.MODULE$) : ("numeric".equals(string) ? new Some((Object)DecimalType$.MODULE$.SYSTEM_DEFAULT()) : None$.MODULE$));
                    }
                }
            }
        }
        return object;
    }

    @Override
    public Option<JdbcType> getJDBCType(DataType dt) {
        ArrayType arrayType;
        DataType et;
        DataType dataType = dt;
        Object object = StringType$.MODULE$.equals(dataType) ? new Some((Object)new JdbcType("TEXT", 1)) : (BinaryType$.MODULE$.equals(dataType) ? new Some((Object)new JdbcType("BYTEA", -2)) : (BooleanType$.MODULE$.equals(dataType) ? new Some((Object)new JdbcType("BOOLEAN", 16)) : (dataType instanceof ArrayType && (et = (arrayType = (ArrayType)dataType).elementType()) instanceof AtomicType ? this.getJDBCType(et).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(JdbcType x$3) {
                return x$3.databaseTypeDefinition();
            }
        }).orElse((Function0)new Serializable(et){
            public static final long serialVersionUID = 0L;
            private final DataType et$1;

            public final Option<String> apply() {
                return JdbcUtils$.MODULE$.getCommonJDBCType(this.et$1).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(JdbcType x$4) {
                        return x$4.databaseTypeDefinition();
                    }
                });
            }
            {
                this.et$1 = et$1;
            }
        }).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JdbcType apply(String typeName) {
                return new JdbcType(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "[]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{typeName})), 2003);
            }
        }) : None$.MODULE$)));
        return object;
    }

    @Override
    public String getTableExistsQuery(String table) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SELECT 1 FROM ", " LIMIT 1"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{table}));
    }

    @Override
    public void beforeFetch(Connection connection, Map<String, String> properties) {
        super.beforeFetch(connection, properties);
        if (new StringOps(Predef$.MODULE$.augmentString((String)properties.getOrElse((Object)"fetchsize", (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "0";
            }
        }))).toInt() > 0) {
            connection.setAutoCommit(false);
        }
    }

    private Object readResolve() {
        return MODULE$;
    }

    private PostgresDialect$() {
        MODULE$ = this;
    }
}

