/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

public class ExpressionInfo {
    private String className;
    private String usage;
    private String name;
    private String extended;
    private String db;
    private String arguments;
    private String examples;
    private String note;
    private String since;

    public String getClassName() {
        return this.className;
    }

    public String getUsage() {
        return this.usage;
    }

    public String getName() {
        return this.name;
    }

    public String getExtended() {
        return this.extended;
    }

    public String getSince() {
        return this.since;
    }

    public String getArguments() {
        return this.arguments;
    }

    public String getExamples() {
        return this.examples;
    }

    public String getNote() {
        return this.note;
    }

    public String getDb() {
        return this.db;
    }

    public ExpressionInfo(String className, String db, String name2, String usage, String arguments, String examples, String note, String since) {
        assert (name2 != null);
        assert (arguments != null);
        assert (examples != null);
        assert (examples.isEmpty() || examples.startsWith(System.lineSeparator() + "    Examples:"));
        assert (note != null);
        assert (since != null);
        this.className = className;
        this.db = db;
        this.name = name2;
        this.usage = usage;
        this.arguments = arguments;
        this.examples = examples;
        this.note = note;
        this.since = since;
        this.extended = arguments + examples;
        if (this.extended.isEmpty()) {
            this.extended = "\n    No example/argument for _FUNC_.\n";
        }
        if (!note.isEmpty()) {
            this.extended = this.extended + "\n    Note:\n      " + note.trim() + "\n";
        }
        if (!since.isEmpty()) {
            this.extended = this.extended + "\n    Since: " + since + "\n";
        }
    }

    public ExpressionInfo(String className, String name2) {
        this(className, null, name2, null, "", "", "", "");
    }

    public ExpressionInfo(String className, String db, String name2) {
        this(className, db, name2, null, "", "", "", "");
    }

    public ExpressionInfo(String className, String db, String name2, String usage, String extended) {
        this(className, db, name2, usage, extended, "", "", "");
    }
}

