/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.request;

import java.util.List;
import java.util.Map;
import org.apache.solr.client.api.model.CreateShardRequestBody;
import org.apache.solr.client.api.model.InstallShardDataRequestBody;
import org.apache.solr.client.api.model.SolrJerseyResponse;
import org.apache.solr.client.api.model.SubResponseAccumulatingJerseyResponse;
import org.apache.solr.client.solrj.JacksonContentWriter;
import org.apache.solr.client.solrj.JacksonParsingResponse;
import org.apache.solr.client.solrj.ResponseParser;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.impl.InputStreamResponseParser;
import org.apache.solr.client.solrj.request.RequestWriter;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;

public class ShardsApi {

    public static class SyncShard
    extends SolrRequest<SyncShardResponse> {
        private final String collectionName;
        private final String shardName;

        public SyncShard(String collectionName, String shardName) {
            super(SolrRequest.METHOD.valueOf("POST"), "/collections/{collectionName}/shards/{shardName}/sync".replace("{collectionName}", collectionName).replace("{shardName}", shardName));
            this.collectionName = collectionName;
            this.shardName = shardName;
        }

        @Override
        public String getRequestType() {
            return SolrRequest.SolrRequestType.ADMIN.toString();
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = new ModifiableSolrParams();
            return params;
        }

        @Override
        protected SyncShardResponse createResponse(SolrClient client) {
            return new SyncShardResponse();
        }

        @Override
        public ResponseParser getResponseParser() {
            return new InputStreamResponseParser("json");
        }
    }

    public static class SyncShardResponse
    extends JacksonParsingResponse<SolrJerseyResponse> {
        public SyncShardResponse() {
            super(SolrJerseyResponse.class);
        }
    }

    public static class InstallShardData
    extends SolrRequest<InstallShardDataResponse> {
        private final InstallShardDataRequestBody requestBody;
        private final String collName;
        private final String shardName;

        public InstallShardData(String collName, String shardName) {
            super(SolrRequest.METHOD.valueOf("POST"), "/collections/{collName}/shards/{shardName}/install".replace("{collName}", collName).replace("{shardName}", shardName));
            this.collName = collName;
            this.shardName = shardName;
            this.requestBody = new InstallShardDataRequestBody();
            this.addHeader("Content-type", "application/json");
        }

        public void setRepository(String repository) {
            this.requestBody.repository = repository;
        }

        public void setAsync(String async) {
            this.requestBody.async = async;
        }

        public void setLocation(String location) {
            this.requestBody.location = location;
        }

        @Override
        public RequestWriter.ContentWriter getContentWriter(String expectedType) {
            return new JacksonContentWriter(expectedType, this.requestBody);
        }

        @Override
        public String getRequestType() {
            return SolrRequest.SolrRequestType.ADMIN.toString();
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = new ModifiableSolrParams();
            return params;
        }

        @Override
        protected InstallShardDataResponse createResponse(SolrClient client) {
            return new InstallShardDataResponse();
        }

        @Override
        public ResponseParser getResponseParser() {
            return new InputStreamResponseParser("json");
        }
    }

    public static class InstallShardDataResponse
    extends JacksonParsingResponse<SolrJerseyResponse> {
        public InstallShardDataResponse() {
            super(SolrJerseyResponse.class);
        }
    }

    public static class ForceShardLeader
    extends SolrRequest<ForceShardLeaderResponse> {
        private final String collectionName;
        private final String shardName;

        public ForceShardLeader(String collectionName, String shardName) {
            super(SolrRequest.METHOD.valueOf("POST"), "/collections/{collectionName}/shards/{shardName}/force-leader".replace("{collectionName}", collectionName).replace("{shardName}", shardName));
            this.collectionName = collectionName;
            this.shardName = shardName;
        }

        @Override
        public String getRequestType() {
            return SolrRequest.SolrRequestType.ADMIN.toString();
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = new ModifiableSolrParams();
            return params;
        }

        @Override
        protected ForceShardLeaderResponse createResponse(SolrClient client) {
            return new ForceShardLeaderResponse();
        }

        @Override
        public ResponseParser getResponseParser() {
            return new InputStreamResponseParser("json");
        }
    }

    public static class ForceShardLeaderResponse
    extends JacksonParsingResponse<SolrJerseyResponse> {
        public ForceShardLeaderResponse() {
            super(SolrJerseyResponse.class);
        }
    }

    public static class DeleteShard
    extends SolrRequest<DeleteShardResponse> {
        private final String collectionName;
        private final String shardName;
        private Boolean deleteInstanceDir;
        private Boolean deleteDataDir;
        private Boolean deleteIndex;
        private Boolean followAliases;
        private String async;

        public DeleteShard(String collectionName, String shardName) {
            super(SolrRequest.METHOD.valueOf("DELETE"), "/collections/{collectionName}/shards/{shardName}".replace("{collectionName}", collectionName).replace("{shardName}", shardName));
            this.collectionName = collectionName;
            this.shardName = shardName;
        }

        public void setDeleteInstanceDir(Boolean deleteInstanceDir) {
            this.deleteInstanceDir = deleteInstanceDir;
        }

        public void setDeleteDataDir(Boolean deleteDataDir) {
            this.deleteDataDir = deleteDataDir;
        }

        public void setDeleteIndex(Boolean deleteIndex) {
            this.deleteIndex = deleteIndex;
        }

        public void setFollowAliases(Boolean followAliases) {
            this.followAliases = followAliases;
        }

        public void setAsync(String async) {
            this.async = async;
        }

        @Override
        public String getRequestType() {
            return SolrRequest.SolrRequestType.ADMIN.toString();
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = new ModifiableSolrParams();
            if (this.deleteInstanceDir != null) {
                params.add("deleteInstanceDir", this.deleteInstanceDir.toString());
            }
            if (this.deleteDataDir != null) {
                params.add("deleteDataDir", this.deleteDataDir.toString());
            }
            if (this.deleteIndex != null) {
                params.add("deleteIndex", this.deleteIndex.toString());
            }
            if (this.followAliases != null) {
                params.add("followAliases", this.followAliases.toString());
            }
            if (this.async != null) {
                params.add("async", this.async);
            }
            return params;
        }

        @Override
        protected DeleteShardResponse createResponse(SolrClient client) {
            return new DeleteShardResponse();
        }

        @Override
        public ResponseParser getResponseParser() {
            return new InputStreamResponseParser("json");
        }
    }

    public static class DeleteShardResponse
    extends JacksonParsingResponse<SubResponseAccumulatingJerseyResponse> {
        public DeleteShardResponse() {
            super(SubResponseAccumulatingJerseyResponse.class);
        }
    }

    public static class CreateShard
    extends SolrRequest<CreateShardResponse> {
        private final CreateShardRequestBody requestBody;
        private final String collectionName;

        public CreateShard(String collectionName) {
            super(SolrRequest.METHOD.valueOf("POST"), "/collections/{collectionName}/shards".replace("{collectionName}", collectionName));
            this.collectionName = collectionName;
            this.requestBody = new CreateShardRequestBody();
            this.addHeader("Content-type", "application/json");
        }

        public void setReplicationFactor(Integer replicationFactor) {
            this.requestBody.replicationFactor = replicationFactor;
        }

        public void setNrtReplicas(Integer nrtReplicas) {
            this.requestBody.nrtReplicas = nrtReplicas;
        }

        public void setTlogReplicas(Integer tlogReplicas) {
            this.requestBody.tlogReplicas = tlogReplicas;
        }

        public void setPullReplicas(Integer pullReplicas) {
            this.requestBody.pullReplicas = pullReplicas;
        }

        public void setWaitForFinalState(Boolean waitForFinalState) {
            this.requestBody.waitForFinalState = waitForFinalState;
        }

        public void setFollowAliases(Boolean followAliases) {
            this.requestBody.followAliases = followAliases;
        }

        public void setAsync(String async) {
            this.requestBody.async = async;
        }

        public void setProperties(Map<String, String> properties) {
            this.requestBody.properties = properties;
        }

        public void setShardName(String shardName) {
            this.requestBody.shardName = shardName;
        }

        public void setCreateReplicas(Boolean createReplicas) {
            this.requestBody.createReplicas = createReplicas;
        }

        public void setNodeSet(List<String> nodeSet) {
            this.requestBody.nodeSet = nodeSet;
        }

        @Override
        public RequestWriter.ContentWriter getContentWriter(String expectedType) {
            return new JacksonContentWriter(expectedType, this.requestBody);
        }

        @Override
        public String getRequestType() {
            return SolrRequest.SolrRequestType.ADMIN.toString();
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = new ModifiableSolrParams();
            return params;
        }

        @Override
        protected CreateShardResponse createResponse(SolrClient client) {
            return new CreateShardResponse();
        }

        @Override
        public ResponseParser getResponseParser() {
            return new InputStreamResponseParser("json");
        }
    }

    public static class CreateShardResponse
    extends JacksonParsingResponse<SubResponseAccumulatingJerseyResponse> {
        public CreateShardResponse() {
            super(SubResponseAccumulatingJerseyResponse.class);
        }
    }
}

