/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.StreamingResponseCallback;
import org.apache.solr.client.solrj.beans.DocumentObjectBinder;
import org.apache.solr.client.solrj.impl.StreamingBinaryResponseParser;
import org.apache.solr.client.solrj.request.AbstractUpdateRequest;
import org.apache.solr.client.solrj.request.QueryRequest;
import org.apache.solr.client.solrj.request.SolrPing;
import org.apache.solr.client.solrj.request.UpdateRequest;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.client.solrj.response.SolrPingResponse;
import org.apache.solr.client.solrj.response.UpdateResponse;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;

public abstract class SolrClient
implements Serializable {
    private static final long serialVersionUID = 1L;
    private DocumentObjectBinder binder;

    public UpdateResponse add(Collection<SolrInputDocument> docs) throws SolrServerException, IOException {
        return this.add(docs, -1);
    }

    public UpdateResponse add(Collection<SolrInputDocument> docs, int commitWithinMs) throws SolrServerException, IOException {
        UpdateRequest req = new UpdateRequest();
        req.add(docs);
        req.setCommitWithin(commitWithinMs);
        return req.process(this);
    }

    public UpdateResponse addBeans(Collection<?> beans) throws SolrServerException, IOException {
        return this.addBeans(beans, -1);
    }

    public UpdateResponse addBeans(Collection<?> beans, int commitWithinMs) throws SolrServerException, IOException {
        DocumentObjectBinder binder = this.getBinder();
        ArrayList<SolrInputDocument> docs = new ArrayList<SolrInputDocument>(beans.size());
        for (Object bean : beans) {
            docs.add(binder.toSolrInputDocument(bean));
        }
        return this.add(docs, commitWithinMs);
    }

    public UpdateResponse add(SolrInputDocument doc) throws SolrServerException, IOException {
        return this.add(doc, -1);
    }

    public UpdateResponse add(SolrInputDocument doc, int commitWithinMs) throws SolrServerException, IOException {
        UpdateRequest req = new UpdateRequest();
        req.add(doc);
        req.setCommitWithin(commitWithinMs);
        return req.process(this);
    }

    public UpdateResponse addBean(Object obj) throws IOException, SolrServerException {
        return this.addBean(obj, -1);
    }

    public UpdateResponse addBean(Object obj, int commitWithinMs) throws IOException, SolrServerException {
        return this.add(this.getBinder().toSolrInputDocument(obj), commitWithinMs);
    }

    public UpdateResponse commit() throws SolrServerException, IOException {
        return this.commit(true, true);
    }

    public UpdateResponse optimize() throws SolrServerException, IOException {
        return this.optimize(true, true, 1);
    }

    public UpdateResponse commit(boolean waitFlush, boolean waitSearcher) throws SolrServerException, IOException {
        return new UpdateRequest().setAction(AbstractUpdateRequest.ACTION.COMMIT, waitFlush, waitSearcher).process(this);
    }

    public UpdateResponse commit(boolean waitFlush, boolean waitSearcher, boolean softCommit) throws SolrServerException, IOException {
        return new UpdateRequest().setAction(AbstractUpdateRequest.ACTION.COMMIT, waitFlush, waitSearcher, softCommit).process(this);
    }

    public UpdateResponse optimize(boolean waitFlush, boolean waitSearcher) throws SolrServerException, IOException {
        return this.optimize(waitFlush, waitSearcher, 1);
    }

    public UpdateResponse optimize(boolean waitFlush, boolean waitSearcher, int maxSegments) throws SolrServerException, IOException {
        return new UpdateRequest().setAction(AbstractUpdateRequest.ACTION.OPTIMIZE, waitFlush, waitSearcher, maxSegments).process(this);
    }

    public UpdateResponse rollback() throws SolrServerException, IOException {
        return new UpdateRequest().rollback().process(this);
    }

    public UpdateResponse deleteById(String id) throws SolrServerException, IOException {
        return this.deleteById(id, -1);
    }

    public UpdateResponse deleteById(String id, int commitWithinMs) throws SolrServerException, IOException {
        UpdateRequest req = new UpdateRequest();
        req.deleteById(id);
        req.setCommitWithin(commitWithinMs);
        return req.process(this);
    }

    public UpdateResponse deleteById(List<String> ids) throws SolrServerException, IOException {
        return this.deleteById(ids, -1);
    }

    public UpdateResponse deleteById(List<String> ids, int commitWithinMs) throws SolrServerException, IOException {
        UpdateRequest req = new UpdateRequest();
        req.deleteById(ids);
        req.setCommitWithin(commitWithinMs);
        return req.process(this);
    }

    public UpdateResponse deleteByQuery(String query) throws SolrServerException, IOException {
        return this.deleteByQuery(query, -1);
    }

    public UpdateResponse deleteByQuery(String query, int commitWithinMs) throws SolrServerException, IOException {
        UpdateRequest req = new UpdateRequest();
        req.deleteByQuery(query);
        req.setCommitWithin(commitWithinMs);
        return req.process(this);
    }

    public SolrPingResponse ping() throws SolrServerException, IOException {
        return new SolrPing().process(this);
    }

    public QueryResponse query(SolrParams params) throws SolrServerException {
        return new QueryRequest(params).process(this);
    }

    public QueryResponse query(SolrParams params, SolrRequest.METHOD method) throws SolrServerException {
        return new QueryRequest(params, method).process(this);
    }

    public QueryResponse queryAndStreamResponse(SolrParams params, StreamingResponseCallback callback) throws SolrServerException, IOException {
        StreamingBinaryResponseParser parser = new StreamingBinaryResponseParser(callback);
        QueryRequest req = new QueryRequest(params);
        req.setStreamingResponseCallback(callback);
        req.setResponseParser(parser);
        return req.process(this);
    }

    public abstract NamedList<Object> request(SolrRequest var1) throws SolrServerException, IOException;

    public DocumentObjectBinder getBinder() {
        if (this.binder == null) {
            this.binder = new DocumentObjectBinder();
        }
        return this.binder;
    }

    public abstract void shutdown();
}

