/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.impl;

import java.io.IOException;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Queue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentProducer;
import org.apache.http.entity.EntityTemplate;
import org.apache.solr.client.solrj.ResponseParser;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.HttpSolrServer;
import org.apache.solr.client.solrj.request.RequestWriter;
import org.apache.solr.client.solrj.request.UpdateRequest;
import org.apache.solr.client.solrj.util.ClientUtils;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SolrjNamedThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConcurrentUpdateSolrServer
extends SolrServer {
    private static final long serialVersionUID = 1L;
    static final Logger log = LoggerFactory.getLogger(ConcurrentUpdateSolrServer.class);
    private HttpSolrServer server;
    final BlockingQueue<UpdateRequest> queue;
    final ExecutorService scheduler = Executors.newCachedThreadPool(new SolrjNamedThreadFactory("concurrentUpdateScheduler"));
    final Queue<Runner> runners;
    volatile CountDownLatch lock = null;
    final int threadCount;

    public ConcurrentUpdateSolrServer(String solrServerUrl, int queueSize, int threadCount) {
        this(solrServerUrl, null, queueSize, threadCount);
    }

    public ConcurrentUpdateSolrServer(String solrServerUrl, HttpClient client, int queueSize, int threadCount) {
        this.server = new HttpSolrServer(solrServerUrl, client);
        this.server.setFollowRedirects(false);
        this.queue = new LinkedBlockingQueue<UpdateRequest>(queueSize);
        this.threadCount = threadCount;
        this.runners = new LinkedList<Runner>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NamedList<Object> request(SolrRequest request) throws SolrServerException, IOException {
        if (!(request instanceof UpdateRequest)) {
            return this.server.request(request);
        }
        UpdateRequest req = (UpdateRequest)request;
        if (req.getDocuments() == null || req.getDocuments().isEmpty()) {
            this.blockUntilFinished();
            return this.server.request(request);
        }
        ModifiableSolrParams params = req.getParams();
        if (params != null && params.getBool("waitSearcher", false)) {
            log.info("blocking for commit/optimize");
            this.blockUntilFinished();
            return this.server.request(request);
        }
        try {
            CountDownLatch tmpLock = this.lock;
            if (tmpLock != null) {
                tmpLock.await();
            }
            boolean success = this.queue.offer(req);
            while (true) {
                Queue<Runner> queue = this.runners;
                synchronized (queue) {
                    if (this.runners.isEmpty() || this.queue.remainingCapacity() < this.queue.size() && this.runners.size() < this.threadCount) {
                        Runner r = new Runner();
                        this.runners.add(r);
                        this.scheduler.execute(r);
                    } else if (success) {
                        break;
                    }
                }
                if (success) continue;
                success = this.queue.offer(req, 100L, TimeUnit.MILLISECONDS);
            }
        }
        catch (InterruptedException e) {
            log.error("interrupted", (Throwable)e);
            throw new IOException(e.getLocalizedMessage());
        }
        NamedList<Object> dummy = new NamedList<Object>();
        dummy.add("NOTE", "the request is processed in a background stream");
        return dummy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void blockUntilFinished() {
        this.lock = new CountDownLatch(1);
        try {
            while (true) {
                Runner runner;
                Queue<Runner> queue = this.runners;
                synchronized (queue) {
                    runner = this.runners.peek();
                }
                if (runner == null) {
                    break;
                }
                runner.runnerLock.lock();
                runner.runnerLock.unlock();
            }
        }
        finally {
            this.lock.countDown();
            this.lock = null;
        }
    }

    public void handleError(Throwable ex) {
        log.error("error", ex);
    }

    @Override
    public void shutdown() {
        this.server.shutdown();
        this.scheduler.shutdown();
        try {
            if (!this.scheduler.awaitTermination(60L, TimeUnit.SECONDS)) {
                this.scheduler.shutdownNow();
                if (!this.scheduler.awaitTermination(60L, TimeUnit.SECONDS)) {
                    log.error("ExecutorService did not terminate");
                }
            }
        }
        catch (InterruptedException ie) {
            this.scheduler.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    public void shutdownNow() {
        this.server.shutdown();
        this.scheduler.shutdownNow();
        try {
            if (!this.scheduler.awaitTermination(30L, TimeUnit.SECONDS)) {
                log.error("ExecutorService did not terminate");
            }
        }
        catch (InterruptedException ie) {
            this.scheduler.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    public void setParser(ResponseParser responseParser) {
        this.server.setParser(responseParser);
    }

    public void setRequestWriter(RequestWriter requestWriter) {
        this.server.setRequestWriter(requestWriter);
    }

    class Runner
    implements Runnable {
        final Lock runnerLock = new ReentrantLock();

        Runner() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            this.runnerLock.lock();
            log.info("starting runner: {}", (Object)this);
            HttpPost method = null;
            HttpResponse response = null;
            try {
                while (!ConcurrentUpdateSolrServer.this.queue.isEmpty()) {
                    try {
                        final UpdateRequest updateRequest = ConcurrentUpdateSolrServer.this.queue.poll(250L, TimeUnit.MILLISECONDS);
                        if (updateRequest == null) {
                            return;
                        }
                        String contentType = ((ConcurrentUpdateSolrServer)ConcurrentUpdateSolrServer.this).server.requestWriter.getUpdateContentType();
                        final boolean isXml = "application/xml; charset=UTF-8".equals(contentType);
                        final ModifiableSolrParams origParams = new ModifiableSolrParams(updateRequest.getParams());
                        EntityTemplate template = new EntityTemplate(new ContentProducer(){

                            public void writeTo(OutputStream out) throws IOException {
                                try {
                                    if (isXml) {
                                        out.write("<stream>".getBytes("UTF-8"));
                                    }
                                    UpdateRequest req = updateRequest;
                                    while (req != null) {
                                        ModifiableSolrParams params;
                                        ModifiableSolrParams currentParams = new ModifiableSolrParams(req.getParams());
                                        if (!origParams.toNamedList().equals(currentParams.toNamedList())) {
                                            ConcurrentUpdateSolrServer.this.queue.add(req);
                                            break;
                                        }
                                        ((ConcurrentUpdateSolrServer)ConcurrentUpdateSolrServer.this).server.requestWriter.write(req, out);
                                        if (isXml && (params = req.getParams()) != null) {
                                            String fmt = null;
                                            if (params.getBool("optimize", false)) {
                                                fmt = "<optimize waitSearcher=\"%s\" />";
                                            } else if (params.getBool("commit", false)) {
                                                fmt = "<commit waitSearcher=\"%s\" />";
                                            }
                                            if (fmt != null) {
                                                byte[] content = String.format(Locale.ROOT, fmt, params.getBool("waitSearcher", false) + "").getBytes("UTF-8");
                                                out.write(content);
                                            }
                                        }
                                        out.flush();
                                        req = ConcurrentUpdateSolrServer.this.queue.poll(250L, TimeUnit.MILLISECONDS);
                                    }
                                    if (isXml) {
                                        out.write("</stream>".getBytes("UTF-8"));
                                    }
                                }
                                catch (InterruptedException e) {
                                    e.printStackTrace();
                                }
                            }
                        });
                        ModifiableSolrParams requestParams = new ModifiableSolrParams(origParams);
                        requestParams.set("wt", ((ConcurrentUpdateSolrServer)ConcurrentUpdateSolrServer.this).server.parser.getWriterType());
                        requestParams.set("version", ((ConcurrentUpdateSolrServer)ConcurrentUpdateSolrServer.this).server.parser.getVersion());
                        method = new HttpPost(ConcurrentUpdateSolrServer.this.server.getBaseURL() + "/update" + ClientUtils.toQueryString(requestParams, false));
                        method.setEntity((HttpEntity)template);
                        method.addHeader("User-Agent", HttpSolrServer.AGENT);
                        method.addHeader("Content-Type", contentType);
                        response = ConcurrentUpdateSolrServer.this.server.getHttpClient().execute((HttpUriRequest)method);
                        int statusCode = response.getStatusLine().getStatusCode();
                        log.info("Status for: " + updateRequest.getDocuments().get(0).getFieldValue("id") + " is " + statusCode);
                        if (statusCode == 200) continue;
                        StringBuilder msg = new StringBuilder();
                        msg.append(response.getStatusLine().getReasonPhrase());
                        msg.append("\n\n");
                        msg.append("\n\n");
                        msg.append("request: ").append(method.getURI());
                        ConcurrentUpdateSolrServer.this.handleError(new Exception(msg.toString()));
                    }
                    finally {
                        try {
                            if (response == null) continue;
                            response.getEntity().getContent().close();
                        }
                        catch (Exception ex) {}
                    }
                }
                return;
            }
            catch (Throwable e) {
                ConcurrentUpdateSolrServer.this.handleError(e);
                return;
            }
            finally {
                Queue<Runner> ex = ConcurrentUpdateSolrServer.this.runners;
                synchronized (ex) {
                    if (ConcurrentUpdateSolrServer.this.runners.size() == 1 && ConcurrentUpdateSolrServer.this.queue.remainingCapacity() == 0) {
                        ConcurrentUpdateSolrServer.this.scheduler.execute(this);
                    } else {
                        ConcurrentUpdateSolrServer.this.runners.remove(this);
                    }
                }
                log.info("finished: {}", (Object)this);
                this.runnerLock.unlock();
            }
        }
    }
}

