/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.netcdf;

import java.io.IOException;
import java.net.URI;
import java.nio.file.OpenOption;
import java.util.Collection;
import java.util.List;
import org.apache.sis.internal.netcdf.Decoder;
import org.apache.sis.internal.storage.URIDataStore;
import org.apache.sis.internal.util.UnmodifiableArrayList;
import org.apache.sis.metadata.ModifiableMetadata;
import org.apache.sis.setup.OptionKey;
import org.apache.sis.storage.Aggregate;
import org.apache.sis.storage.DataStore;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.DataStoreProvider;
import org.apache.sis.storage.ReadOnlyStorageException;
import org.apache.sis.storage.Resource;
import org.apache.sis.storage.StorageConnector;
import org.apache.sis.storage.UnsupportedStorageException;
import org.apache.sis.storage.netcdf.MetadataReader;
import org.apache.sis.storage.netcdf.NetcdfStoreProvider;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Version;
import org.apache.sis.util.logging.WarningListeners;
import org.opengis.metadata.Metadata;
import org.opengis.parameter.ParameterValueGroup;

public class NetcdfStore
extends DataStore
implements Aggregate {
    private final Decoder decoder;
    private final URI location;
    private Metadata metadata;
    private List<Resource> components;

    @Deprecated
    public NetcdfStore(StorageConnector storageConnector) throws DataStoreException {
        this(null, storageConnector);
    }

    public NetcdfStore(NetcdfStoreProvider netcdfStoreProvider, StorageConnector storageConnector) throws DataStoreException {
        super((DataStoreProvider)netcdfStoreProvider, storageConnector);
        this.location = (URI)storageConnector.getStorageAs(URI.class);
        try {
            this.decoder = NetcdfStoreProvider.decoder((WarningListeners<DataStore>)this.listeners, storageConnector);
        }
        catch (IOException iOException) {
            throw new DataStoreException((Throwable)iOException);
        }
        if (this.decoder == null) {
            throw new UnsupportedStorageException(super.getLocale(), "NetCDF", storageConnector.getStorage(), (OpenOption[])storageConnector.getOption(OptionKey.OPEN_OPTIONS));
        }
    }

    public synchronized Metadata getMetadata() throws DataStoreException {
        if (this.metadata == null) {
            try {
                MetadataReader metadataReader = new MetadataReader(this.decoder);
                this.metadata = metadataReader.read();
                if (this.metadata instanceof ModifiableMetadata) {
                    ((ModifiableMetadata)this.metadata).freeze();
                }
            }
            catch (IOException iOException) {
                throw new DataStoreException((Throwable)iOException);
            }
        }
        return this.metadata;
    }

    public ParameterValueGroup getOpenParameters() {
        return URIDataStore.parameters((DataStoreProvider)this.provider, (URI)this.location);
    }

    public synchronized Version getConventionVersion() throws DataStoreException {
        for (CharSequence charSequence : CharSequences.split((CharSequence)this.decoder.stringValue("Conventions"), (char)',')) {
            if (!CharSequences.regionMatches((CharSequence)charSequence, (int)0, (CharSequence)"CF-", (boolean)true)) continue;
            return new Version(charSequence.subSequence(3, charSequence.length()).toString());
        }
        return null;
    }

    public synchronized Collection<Resource> components() throws DataStoreException {
        if (this.components == null) {
            try {
                this.components = UnmodifiableArrayList.wrap((Object[])this.decoder.getDiscreteSampling());
            }
            catch (IOException iOException) {
                throw new DataStoreException((Throwable)iOException);
            }
        }
        return this.components;
    }

    public Resource add(Resource resource) throws ReadOnlyStorageException {
        throw new ReadOnlyStorageException();
    }

    public void remove(Resource resource) throws ReadOnlyStorageException {
        throw new ReadOnlyStorageException();
    }

    public synchronized void close() throws DataStoreException {
        this.metadata = null;
        try {
            this.decoder.close();
        }
        catch (IOException iOException) {
            throw new DataStoreException((Throwable)iOException);
        }
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + '[' + this.decoder + ']';
    }
}

