/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.mysql.visitor.statement.type;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.shardingsphere.sql.parser.api.ASTNode;
import org.apache.shardingsphere.sql.parser.api.visitor.statement.type.TCLStatementVisitor;
import org.apache.shardingsphere.sql.parser.autogen.MySQLStatementParser;
import org.apache.shardingsphere.sql.parser.mysql.visitor.statement.MySQLStatementVisitor;
import org.apache.shardingsphere.sql.parser.sql.common.enums.OperationScope;
import org.apache.shardingsphere.sql.parser.sql.common.enums.TransactionAccessType;
import org.apache.shardingsphere.sql.parser.sql.common.enums.TransactionIsolationLevel;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.AliasSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.tcl.AutoCommitSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.tcl.xa.XABeginStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.tcl.xa.XACommitStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.tcl.xa.XAEndStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.tcl.xa.XAPrepareStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.tcl.xa.XARecoveryStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.tcl.xa.XARollbackStatement;
import org.apache.shardingsphere.sql.parser.sql.common.value.identifier.IdentifierValue;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.tcl.MySQLBeginTransactionStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.tcl.MySQLCommitStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.tcl.MySQLLockStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.tcl.MySQLReleaseSavepointStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.tcl.MySQLRollbackStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.tcl.MySQLSavepointStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.tcl.MySQLSetAutoCommitStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.tcl.MySQLSetTransactionStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.tcl.MySQLUnlockStatement;

public final class MySQLTCLStatementVisitor
extends MySQLStatementVisitor
implements TCLStatementVisitor {
    @Override
    public ASTNode visitSetTransaction(MySQLStatementParser.SetTransactionContext ctx) {
        MySQLSetTransactionStatement result = new MySQLSetTransactionStatement();
        if (null != ctx.optionType()) {
            OperationScope scope = null;
            if (null != ctx.optionType().SESSION()) {
                scope = OperationScope.SESSION;
            } else if (null != ctx.optionType().GLOBAL()) {
                scope = OperationScope.GLOBAL;
            }
            result.setScope(scope);
        }
        if (null != ctx.transactionCharacteristics().isolationLevel()) {
            TransactionIsolationLevel isolationLevel = null;
            if (null != ctx.transactionCharacteristics().isolationLevel().isolationTypes().SERIALIZABLE()) {
                isolationLevel = TransactionIsolationLevel.SERIALIZABLE;
            } else if (null != ctx.transactionCharacteristics().isolationLevel().isolationTypes().COMMITTED()) {
                isolationLevel = TransactionIsolationLevel.READ_COMMITTED;
            } else if (null != ctx.transactionCharacteristics().isolationLevel().isolationTypes().UNCOMMITTED()) {
                isolationLevel = TransactionIsolationLevel.READ_UNCOMMITTED;
            } else if (null != ctx.transactionCharacteristics().isolationLevel().isolationTypes().REPEATABLE()) {
                isolationLevel = TransactionIsolationLevel.REPEATABLE_READ;
            }
            result.setIsolationLevel(isolationLevel);
        }
        if (null != ctx.transactionCharacteristics().transactionAccessMode()) {
            TransactionAccessType accessType = null;
            if (null != ctx.transactionCharacteristics().transactionAccessMode().ONLY()) {
                accessType = TransactionAccessType.READ_ONLY;
            } else if (null != ctx.transactionCharacteristics().transactionAccessMode().WRITE()) {
                accessType = TransactionAccessType.READ_WRITE;
            }
            result.setAccessMode(accessType);
        }
        return result;
    }

    @Override
    public ASTNode visitSetAutoCommit(MySQLStatementParser.SetAutoCommitContext ctx) {
        MySQLSetAutoCommitStatement result = new MySQLSetAutoCommitStatement();
        result.setAutoCommit(this.generateAutoCommitSegment(ctx.autoCommitValue).isAutoCommit());
        return result;
    }

    private AutoCommitSegment generateAutoCommitSegment(Token ctx) {
        boolean autoCommit = "1".equals(ctx.getText()) || "ON".equals(ctx.getText());
        return new AutoCommitSegment(ctx.getStartIndex(), ctx.getStopIndex(), autoCommit);
    }

    @Override
    public ASTNode visitBeginTransaction(MySQLStatementParser.BeginTransactionContext ctx) {
        return new MySQLBeginTransactionStatement();
    }

    @Override
    public ASTNode visitCommit(MySQLStatementParser.CommitContext ctx) {
        return new MySQLCommitStatement();
    }

    @Override
    public ASTNode visitRollback(MySQLStatementParser.RollbackContext ctx) {
        MySQLRollbackStatement result = new MySQLRollbackStatement();
        if (null != ctx.identifier()) {
            result.setSavepointName(((IdentifierValue)this.visit((ParseTree)ctx.identifier())).getValue());
        }
        return result;
    }

    @Override
    public ASTNode visitSavepoint(MySQLStatementParser.SavepointContext ctx) {
        MySQLSavepointStatement result = new MySQLSavepointStatement();
        result.setSavepointName(((IdentifierValue)this.visit((ParseTree)ctx.identifier())).getValue());
        return result;
    }

    @Override
    public ASTNode visitReleaseSavepoint(MySQLStatementParser.ReleaseSavepointContext ctx) {
        MySQLReleaseSavepointStatement result = new MySQLReleaseSavepointStatement();
        result.setSavepointName(((IdentifierValue)this.visit((ParseTree)ctx.identifier())).getValue());
        return result;
    }

    @Override
    public ASTNode visitXaBegin(MySQLStatementParser.XaBeginContext ctx) {
        return new XABeginStatement(ctx.xid().getText());
    }

    @Override
    public ASTNode visitXaPrepare(MySQLStatementParser.XaPrepareContext ctx) {
        return new XAPrepareStatement(ctx.xid().getText());
    }

    @Override
    public ASTNode visitXaCommit(MySQLStatementParser.XaCommitContext ctx) {
        return new XACommitStatement(ctx.xid().getText());
    }

    @Override
    public ASTNode visitXaRollback(MySQLStatementParser.XaRollbackContext ctx) {
        return new XARollbackStatement(ctx.xid().getText());
    }

    @Override
    public ASTNode visitXaEnd(MySQLStatementParser.XaEndContext ctx) {
        return new XAEndStatement(ctx.xid().getText());
    }

    @Override
    public ASTNode visitXaRecovery(MySQLStatementParser.XaRecoveryContext ctx) {
        return new XARecoveryStatement();
    }

    @Override
    public ASTNode visitLock(MySQLStatementParser.LockContext ctx) {
        MySQLLockStatement result = new MySQLLockStatement();
        if (null != ctx.tableLock()) {
            result.getTables().addAll(this.getLockTables(ctx.tableLock()));
        }
        return result;
    }

    private Collection<SimpleTableSegment> getLockTables(List<MySQLStatementParser.TableLockContext> tableLockContexts) {
        LinkedList<SimpleTableSegment> result = new LinkedList<SimpleTableSegment>();
        for (MySQLStatementParser.TableLockContext each : tableLockContexts) {
            SimpleTableSegment simpleTableSegment = (SimpleTableSegment)this.visit((ParseTree)each.tableName());
            if (null != each.alias()) {
                simpleTableSegment.setAlias((AliasSegment)this.visit((ParseTree)each.alias()));
            }
            result.add(simpleTableSegment);
        }
        return result;
    }

    @Override
    public ASTNode visitUnlock(MySQLStatementParser.UnlockContext ctx) {
        return new MySQLUnlockStatement();
    }
}

