/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.driver.jdbc.core.statement;

import com.google.common.base.Strings;
import java.sql.Connection;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.driver.executor.DriverExecutor;
import org.apache.shardingsphere.driver.executor.batch.BatchExecutionUnit;
import org.apache.shardingsphere.driver.executor.batch.BatchPreparedStatementExecutor;
import org.apache.shardingsphere.driver.executor.callback.impl.PreparedStatementExecuteQueryCallback;
import org.apache.shardingsphere.driver.jdbc.adapter.AbstractPreparedStatementAdapter;
import org.apache.shardingsphere.driver.jdbc.core.connection.ShardingSphereConnection;
import org.apache.shardingsphere.driver.jdbc.core.resultset.GeneratedKeysResultSet;
import org.apache.shardingsphere.driver.jdbc.core.resultset.ShardingSphereResultSet;
import org.apache.shardingsphere.driver.jdbc.core.resultset.ShardingSphereResultSetUtils;
import org.apache.shardingsphere.driver.jdbc.core.statement.StatementManager;
import org.apache.shardingsphere.driver.jdbc.core.statement.metadata.ShardingSphereParameterMetaData;
import org.apache.shardingsphere.infra.binder.context.aware.ParameterAware;
import org.apache.shardingsphere.infra.binder.context.segment.insert.keygen.GeneratedKeyContext;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.context.statement.dml.InsertStatementContext;
import org.apache.shardingsphere.infra.binder.context.statement.dml.SelectStatementContext;
import org.apache.shardingsphere.infra.binder.engine.SQLBindEngine;
import org.apache.shardingsphere.infra.config.props.ConfigurationPropertyKey;
import org.apache.shardingsphere.infra.connection.kernel.KernelProcessor;
import org.apache.shardingsphere.infra.database.core.type.DatabaseType;
import org.apache.shardingsphere.infra.database.mysql.type.MySQLDatabaseType;
import org.apache.shardingsphere.infra.exception.core.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.exception.dialect.SQLExceptionTransformEngine;
import org.apache.shardingsphere.infra.exception.kernel.syntax.EmptySQLException;
import org.apache.shardingsphere.infra.executor.audit.SQLAuditEngine;
import org.apache.shardingsphere.infra.executor.kernel.model.ExecutionGroup;
import org.apache.shardingsphere.infra.executor.kernel.model.ExecutionGroupContext;
import org.apache.shardingsphere.infra.executor.kernel.model.ExecutionGroupReportContext;
import org.apache.shardingsphere.infra.executor.sql.context.ExecutionContext;
import org.apache.shardingsphere.infra.executor.sql.context.ExecutionUnit;
import org.apache.shardingsphere.infra.executor.sql.context.SQLUnit;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.ConnectionMode;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.SQLExecutorExceptionHandler;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.jdbc.JDBCExecutionUnit;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.jdbc.JDBCExecutor;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.jdbc.JDBCExecutorCallback;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.raw.RawSQLExecutionUnit;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.raw.callback.RawSQLExecutorCallback;
import org.apache.shardingsphere.infra.executor.sql.execute.result.ExecuteResult;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.QueryResult;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.impl.driver.jdbc.type.stream.JDBCStreamQueryResult;
import org.apache.shardingsphere.infra.executor.sql.execute.result.update.UpdateResult;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.DatabaseConnectionManager;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.DriverExecutionPrepareEngine;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.ExecutorStatementManager;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.StorageResourceOption;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.jdbc.StatementOption;
import org.apache.shardingsphere.infra.executor.sql.prepare.raw.RawExecutionPrepareEngine;
import org.apache.shardingsphere.infra.hint.HintManager;
import org.apache.shardingsphere.infra.hint.HintValueContext;
import org.apache.shardingsphere.infra.hint.SQLHintUtils;
import org.apache.shardingsphere.infra.instance.InstanceContext;
import org.apache.shardingsphere.infra.merge.MergeEngine;
import org.apache.shardingsphere.infra.merge.result.MergedResult;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.rule.RuleMetaData;
import org.apache.shardingsphere.infra.metadata.user.Grantee;
import org.apache.shardingsphere.infra.parser.SQLParserEngine;
import org.apache.shardingsphere.infra.route.context.RouteContext;
import org.apache.shardingsphere.infra.rule.attribute.datanode.DataNodeRuleAttribute;
import org.apache.shardingsphere.infra.rule.attribute.raw.RawExecutionRuleAttribute;
import org.apache.shardingsphere.infra.rule.attribute.resoure.StorageConnectorReusableRuleAttribute;
import org.apache.shardingsphere.infra.session.query.QueryContext;
import org.apache.shardingsphere.mode.metadata.MetaDataContexts;
import org.apache.shardingsphere.parser.rule.SQLParserRule;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dal.DALStatement;
import org.apache.shardingsphere.sqlfederation.executor.context.SQLFederationContext;
import org.apache.shardingsphere.traffic.engine.TrafficEngine;
import org.apache.shardingsphere.traffic.exception.EmptyTrafficExecutionUnitException;
import org.apache.shardingsphere.traffic.rule.TrafficRule;
import org.apache.shardingsphere.transaction.implicit.ImplicitTransactionCallback;
import org.apache.shardingsphere.transaction.util.AutoCommitUtils;

public final class ShardingSpherePreparedStatement
extends AbstractPreparedStatementAdapter {
    private final ShardingSphereConnection connection;
    private final MetaDataContexts metaDataContexts;
    private final String sql;
    private final List<PreparedStatement> statements;
    private final List<List<Object>> parameterSets;
    private final SQLStatement sqlStatement;
    private final SQLStatementContext sqlStatementContext;
    private final String databaseName;
    private final StatementOption statementOption;
    private final ParameterMetaData parameterMetaData;
    private final DriverExecutor executor;
    private final BatchPreparedStatementExecutor batchPreparedStatementExecutor;
    private final Collection<Comparable<?>> generatedValues = new LinkedList();
    private final KernelProcessor kernelProcessor;
    private final boolean statementsCacheable;
    private final TrafficRule trafficRule;
    private final StatementManager statementManager;
    private final boolean selectContainsEnhancedTable;
    private ExecutionContext executionContext;
    private Map<String, Integer> columnLabelAndIndexMap;
    private ResultSet currentResultSet;
    private String trafficInstanceId;
    private boolean useFederation;
    private final HintValueContext hintValueContext;
    private ResultSet currentBatchGeneratedKeysResultSet;

    public ShardingSpherePreparedStatement(ShardingSphereConnection connection, String sql) throws SQLException {
        this(connection, sql, 1003, 1007, 1, false, null);
    }

    public ShardingSpherePreparedStatement(ShardingSphereConnection connection, String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this(connection, sql, resultSetType, resultSetConcurrency, 1, false, null);
    }

    public ShardingSpherePreparedStatement(ShardingSphereConnection connection, String sql, int autoGeneratedKeys) throws SQLException {
        this(connection, sql, 1003, 1007, 1, 1 == autoGeneratedKeys, null);
    }

    public ShardingSpherePreparedStatement(ShardingSphereConnection connection, String sql, String[] columns) throws SQLException {
        this(connection, sql, 1003, 1007, 1, true, columns);
    }

    public ShardingSpherePreparedStatement(ShardingSphereConnection connection, String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this(connection, sql, resultSetType, resultSetConcurrency, resultSetHoldability, false, null);
    }

    private ShardingSpherePreparedStatement(ShardingSphereConnection connection, String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability, boolean returnGeneratedKeys, String[] columns) throws SQLException {
        if (Strings.isNullOrEmpty((String)sql)) {
            throw new EmptySQLException().toSQLException();
        }
        this.connection = connection;
        this.metaDataContexts = connection.getContextManager().getMetaDataContexts();
        this.hintValueContext = SQLHintUtils.extractHint((String)sql);
        this.sql = SQLHintUtils.removeHint((String)sql);
        this.statements = new ArrayList<PreparedStatement>();
        this.parameterSets = new ArrayList<List<Object>>();
        SQLParserRule sqlParserRule = (SQLParserRule)this.metaDataContexts.getMetaData().getGlobalRuleMetaData().getSingleRule(SQLParserRule.class);
        SQLParserEngine sqlParserEngine = sqlParserRule.getSQLParserEngine(this.metaDataContexts.getMetaData().getDatabase(connection.getDatabaseName()).getProtocolType());
        this.sqlStatement = sqlParserEngine.parse(this.sql, true);
        this.sqlStatementContext = new SQLBindEngine(this.metaDataContexts.getMetaData(), connection.getDatabaseName(), this.hintValueContext).bind(this.sqlStatement, Collections.emptyList());
        this.databaseName = this.sqlStatementContext.getTablesContext().getDatabaseName().orElse(connection.getDatabaseName());
        connection.getDatabaseConnectionManager().getConnectionContext().setCurrentDatabase(this.databaseName);
        this.parameterMetaData = new ShardingSphereParameterMetaData(this.sqlStatement);
        this.statementOption = returnGeneratedKeys ? new StatementOption(true, columns) : new StatementOption(resultSetType, resultSetConcurrency, resultSetHoldability);
        this.executor = new DriverExecutor(connection);
        JDBCExecutor jdbcExecutor = new JDBCExecutor(connection.getContextManager().getExecutorEngine(), connection.getDatabaseConnectionManager().getConnectionContext());
        this.batchPreparedStatementExecutor = new BatchPreparedStatementExecutor(this.metaDataContexts, jdbcExecutor, this.databaseName, connection.getProcessId());
        this.kernelProcessor = new KernelProcessor();
        this.statementsCacheable = this.isStatementsCacheable(this.metaDataContexts.getMetaData().getDatabase(this.databaseName).getRuleMetaData());
        this.trafficRule = (TrafficRule)this.metaDataContexts.getMetaData().getGlobalRuleMetaData().getSingleRule(TrafficRule.class);
        this.selectContainsEnhancedTable = this.sqlStatementContext instanceof SelectStatementContext && ((SelectStatementContext)this.sqlStatementContext).isContainsEnhancedTable();
        this.statementManager = new StatementManager();
    }

    private boolean isStatementsCacheable(RuleMetaData databaseRuleMetaData) {
        return databaseRuleMetaData.getAttributes(StorageConnectorReusableRuleAttribute.class).size() == databaseRuleMetaData.getRules().size() && !HintManager.isInstantiated();
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        ShardingSphereResultSet result;
        try {
            if (this.statementsCacheable && !this.statements.isEmpty()) {
                this.resetParameters();
                ResultSet resultSet = this.statements.iterator().next().executeQuery();
                return resultSet;
            }
            this.clearPrevious();
            QueryContext queryContext = this.createQueryContext();
            this.handleAutoCommit(queryContext);
            this.trafficInstanceId = this.getInstanceIdAndSet(queryContext).orElse(null);
            if (null != this.trafficInstanceId) {
                JDBCExecutionUnit executionUnit = this.createTrafficExecutionUnit(this.trafficInstanceId, queryContext);
                ResultSet resultSet = (ResultSet)this.executor.getTrafficExecutor().execute(executionUnit, (statement, sql) -> ((PreparedStatement)statement).executeQuery());
                return resultSet;
            }
            this.useFederation = this.decide(queryContext, this.metaDataContexts.getMetaData().getDatabase(this.databaseName), this.metaDataContexts.getMetaData().getGlobalRuleMetaData());
            if (this.useFederation) {
                ResultSet resultSet = this.executeFederationQuery(queryContext);
                return resultSet;
            }
            this.executionContext = this.createExecutionContext(queryContext);
            result = this.doExecuteQuery(this.executionContext);
        }
        catch (RuntimeException ex) {
            this.handleExceptionInTransaction(this.connection, this.metaDataContexts);
            throw SQLExceptionTransformEngine.toSQLException((Exception)ex, (DatabaseType)this.metaDataContexts.getMetaData().getDatabase(this.databaseName).getProtocolType());
        }
        finally {
            this.clearBatch();
        }
        this.currentResultSet = result;
        return result;
    }

    private ShardingSphereResultSet doExecuteQuery(ExecutionContext executionContext) throws SQLException {
        List<QueryResult> queryResults = this.executeQuery0(executionContext);
        MergedResult mergedResult = this.mergeQuery(queryResults, executionContext.getSqlStatementContext());
        List<ResultSet> resultSets = this.getResultSets();
        if (null == this.columnLabelAndIndexMap) {
            this.columnLabelAndIndexMap = ShardingSphereResultSetUtils.createColumnLabelAndIndexMap(this.sqlStatementContext, this.selectContainsEnhancedTable, resultSets.get(0).getMetaData());
        }
        return new ShardingSphereResultSet(resultSets, mergedResult, this, this.selectContainsEnhancedTable, executionContext, this.columnLabelAndIndexMap);
    }

    private boolean decide(QueryContext queryContext, ShardingSphereDatabase database, RuleMetaData globalRuleMetaData) {
        return this.executor.getSqlFederationEngine().decide(queryContext.getSqlStatementContext(), queryContext.getParameters(), database, globalRuleMetaData);
    }

    private void handleAutoCommit(QueryContext queryContext) throws SQLException {
        if (AutoCommitUtils.needOpenTransaction((SQLStatement)queryContext.getSqlStatementContext().getSqlStatement())) {
            this.connection.handleAutoCommit();
        }
    }

    private JDBCExecutionUnit createTrafficExecutionUnit(String trafficInstanceId, QueryContext queryContext) throws SQLException {
        ExecutionUnit executionUnit;
        DriverExecutionPrepareEngine<JDBCExecutionUnit, Connection> prepareEngine = this.createDriverExecutionPrepareEngine();
        ExecutionGroupContext context = prepareEngine.prepare(new RouteContext(), Collections.singleton(executionUnit = new ExecutionUnit(trafficInstanceId, new SQLUnit(queryContext.getSql(), queryContext.getParameters()))), new ExecutionGroupReportContext(this.connection.getProcessId(), this.databaseName, new Grantee("", "")));
        ShardingSpherePreconditions.checkState((!context.getInputGroups().isEmpty() && !((ExecutionGroup)context.getInputGroups().iterator().next()).getInputs().isEmpty() ? 1 : 0) != 0, EmptyTrafficExecutionUnitException::new);
        return (JDBCExecutionUnit)((ExecutionGroup)context.getInputGroups().iterator().next()).getInputs().iterator().next();
    }

    private Optional<String> getInstanceIdAndSet(QueryContext queryContext) {
        Optional<String> result = this.connection.getDatabaseConnectionManager().getConnectionContext().getTrafficInstanceId();
        if (!result.isPresent()) {
            result = this.getInstanceId(queryContext);
        }
        if (this.connection.isHoldTransaction() && result.isPresent()) {
            this.connection.getDatabaseConnectionManager().getConnectionContext().setTrafficInstanceId(result.get());
        }
        return result;
    }

    private Optional<String> getInstanceId(QueryContext queryContext) {
        InstanceContext instanceContext = this.connection.getContextManager().getInstanceContext();
        return null != this.trafficRule && !this.trafficRule.getStrategyRules().isEmpty() ? new TrafficEngine(this.trafficRule, instanceContext).dispatch(queryContext, this.connection.isHoldTransaction()) : Optional.empty();
    }

    private void resetParameters() throws SQLException {
        this.parameterSets.clear();
        this.parameterSets.add(this.getParameters());
        this.replaySetParameter();
    }

    private List<QueryResult> executeQuery0(ExecutionContext executionContext) throws SQLException {
        if (this.hasRawExecutionRule()) {
            return this.executor.getRawExecutor().execute(this.createRawExecutionGroupContext(executionContext), executionContext.getQueryContext(), new RawSQLExecutorCallback()).stream().map(QueryResult.class::cast).collect(Collectors.toList());
        }
        ExecutionGroupContext<JDBCExecutionUnit> executionGroupContext = this.createExecutionGroupContext(executionContext);
        this.cacheStatements(executionGroupContext.getInputGroups());
        return this.executor.getRegularExecutor().executeQuery(executionGroupContext, executionContext.getQueryContext(), new PreparedStatementExecuteQueryCallback(this.metaDataContexts.getMetaData().getDatabase(this.databaseName).getProtocolType(), this.metaDataContexts.getMetaData().getDatabase(this.databaseName).getResourceMetaData(), this.sqlStatement, SQLExecutorExceptionHandler.isExceptionThrown()));
    }

    private ResultSet executeFederationQuery(QueryContext queryContext) {
        PreparedStatementExecuteQueryCallback callback = new PreparedStatementExecuteQueryCallback(this.metaDataContexts.getMetaData().getDatabase(this.databaseName).getProtocolType(), this.metaDataContexts.getMetaData().getDatabase(this.databaseName).getResourceMetaData(), this.sqlStatement, SQLExecutorExceptionHandler.isExceptionThrown());
        SQLFederationContext context = new SQLFederationContext(false, queryContext, this.metaDataContexts.getMetaData(), this.connection.getProcessId());
        return this.executor.getSqlFederationEngine().executeQuery(this.createDriverExecutionPrepareEngine(), (JDBCExecutorCallback)callback, context);
    }

    private DriverExecutionPrepareEngine<JDBCExecutionUnit, Connection> createDriverExecutionPrepareEngine() {
        int maxConnectionsSizePerQuery = (Integer)this.metaDataContexts.getMetaData().getProps().getValue((Enum)ConfigurationPropertyKey.MAX_CONNECTIONS_SIZE_PER_QUERY);
        return new DriverExecutionPrepareEngine("JDBC.PREPARED_STATEMENT", maxConnectionsSizePerQuery, (DatabaseConnectionManager)this.connection.getDatabaseConnectionManager(), (ExecutorStatementManager)this.statementManager, (StorageResourceOption)this.statementOption, this.metaDataContexts.getMetaData().getDatabase(this.databaseName).getRuleMetaData().getRules(), this.metaDataContexts.getMetaData().getDatabase(this.databaseName).getResourceMetaData().getStorageUnits());
    }

    @Override
    public int executeUpdate() throws SQLException {
        try {
            if (this.statementsCacheable && !this.statements.isEmpty()) {
                this.resetParameters();
                int n = this.statements.iterator().next().executeUpdate();
                return n;
            }
            this.clearPrevious();
            QueryContext queryContext = this.createQueryContext();
            this.handleAutoCommit(queryContext);
            this.trafficInstanceId = this.getInstanceIdAndSet(queryContext).orElse(null);
            if (null != this.trafficInstanceId) {
                JDBCExecutionUnit executionUnit = this.createTrafficExecutionUnit(this.trafficInstanceId, queryContext);
                int n = (Integer)this.executor.getTrafficExecutor().execute(executionUnit, (statement, sql) -> ((PreparedStatement)statement).executeUpdate());
                return n;
            }
            this.executionContext = this.createExecutionContext(queryContext);
            if (this.hasRawExecutionRule()) {
                List results = this.executor.getRawExecutor().execute(this.createRawExecutionGroupContext(this.executionContext), this.executionContext.getQueryContext(), new RawSQLExecutorCallback());
                int n = this.accumulate(results);
                return n;
            }
            int n = this.executeUpdateWithExecutionContext(this.executionContext);
            return n;
        }
        catch (RuntimeException ex) {
            this.handleExceptionInTransaction(this.connection, this.metaDataContexts);
            throw SQLExceptionTransformEngine.toSQLException((Exception)ex, (DatabaseType)this.metaDataContexts.getMetaData().getDatabase(this.databaseName).getProtocolType());
        }
        finally {
            this.clearBatch();
        }
    }

    private int useDriverToExecuteUpdate(ExecutionContext executionContext) throws SQLException {
        ExecutionGroupContext<JDBCExecutionUnit> executionGroupContext = this.createExecutionGroupContext(executionContext);
        this.cacheStatements(executionGroupContext.getInputGroups());
        return this.executor.getRegularExecutor().executeUpdate(executionGroupContext, executionContext.getQueryContext(), executionContext.getRouteContext().getRouteUnits(), this.createExecuteUpdateCallback());
    }

    private int accumulate(Collection<ExecuteResult> results) {
        int result = 0;
        for (ExecuteResult each : results) {
            result += ((UpdateResult)each).getUpdateCount();
        }
        return result;
    }

    private JDBCExecutorCallback<Integer> createExecuteUpdateCallback() {
        boolean isExceptionThrown = SQLExecutorExceptionHandler.isExceptionThrown();
        return new JDBCExecutorCallback<Integer>(this.metaDataContexts.getMetaData().getDatabase(this.databaseName).getProtocolType(), this.metaDataContexts.getMetaData().getDatabase(this.databaseName).getResourceMetaData(), this.sqlStatement, isExceptionThrown){

            protected Integer executeSQL(String sql, Statement statement, ConnectionMode connectionMode, DatabaseType storageType) throws SQLException {
                return ((PreparedStatement)statement).executeUpdate();
            }

            protected Optional<Integer> getSaneResult(SQLStatement sqlStatement, SQLException ex) {
                return Optional.empty();
            }
        };
    }

    @Override
    public boolean execute() throws SQLException {
        try {
            if (this.statementsCacheable && !this.statements.isEmpty()) {
                this.resetParameters();
                boolean bl = this.statements.iterator().next().execute();
                return bl;
            }
            this.clearPrevious();
            QueryContext queryContext = this.createQueryContext();
            this.handleAutoCommit(queryContext);
            this.trafficInstanceId = this.getInstanceIdAndSet(queryContext).orElse(null);
            if (null != this.trafficInstanceId) {
                JDBCExecutionUnit executionUnit = this.createTrafficExecutionUnit(this.trafficInstanceId, queryContext);
                boolean bl = (Boolean)this.executor.getTrafficExecutor().execute(executionUnit, (statement, sql) -> ((PreparedStatement)statement).execute());
                return bl;
            }
            this.useFederation = this.decide(queryContext, this.metaDataContexts.getMetaData().getDatabase(this.databaseName), this.metaDataContexts.getMetaData().getGlobalRuleMetaData());
            if (this.useFederation) {
                ResultSet resultSet = this.executeFederationQuery(queryContext);
                boolean bl = null != resultSet;
                return bl;
            }
            this.executionContext = this.createExecutionContext(queryContext);
            if (this.hasRawExecutionRule()) {
                List results = this.executor.getRawExecutor().execute(this.createRawExecutionGroupContext(this.executionContext), this.executionContext.getQueryContext(), new RawSQLExecutorCallback());
                boolean bl = results.iterator().next() instanceof QueryResult;
                return bl;
            }
            boolean bl = this.executeWithExecutionContext(this.executionContext);
            return bl;
        }
        catch (RuntimeException ex) {
            this.handleExceptionInTransaction(this.connection, this.metaDataContexts);
            throw SQLExceptionTransformEngine.toSQLException((Exception)ex, (DatabaseType)this.metaDataContexts.getMetaData().getDatabase(this.databaseName).getProtocolType());
        }
        finally {
            this.clearBatch();
        }
    }

    private boolean hasRawExecutionRule() {
        return !this.metaDataContexts.getMetaData().getDatabase(this.databaseName).getRuleMetaData().getAttributes(RawExecutionRuleAttribute.class).isEmpty();
    }

    private ExecutionGroupContext<RawSQLExecutionUnit> createRawExecutionGroupContext(ExecutionContext executionContext) throws SQLException {
        int maxConnectionsSizePerQuery = (Integer)this.metaDataContexts.getMetaData().getProps().getValue((Enum)ConfigurationPropertyKey.MAX_CONNECTIONS_SIZE_PER_QUERY);
        return new RawExecutionPrepareEngine(maxConnectionsSizePerQuery, this.metaDataContexts.getMetaData().getDatabase(this.databaseName).getRuleMetaData().getRules()).prepare(executionContext.getRouteContext(), executionContext.getExecutionUnits(), new ExecutionGroupReportContext(this.connection.getProcessId(), this.databaseName, new Grantee("", "")));
    }

    private boolean executeWithExecutionContext(ExecutionContext executionContext) throws SQLException {
        return this.isNeedImplicitCommitTransaction(this.connection, executionContext.getSqlStatementContext().getSqlStatement(), executionContext.getExecutionUnits().size() > 1) ? this.executeWithImplicitCommitTransaction((ImplicitTransactionCallback<Boolean>)((ImplicitTransactionCallback)() -> this.useDriverToExecute(executionContext))) : this.useDriverToExecute(executionContext);
    }

    private boolean executeWithImplicitCommitTransaction(ImplicitTransactionCallback<Boolean> callback) throws SQLException {
        boolean result;
        try {
            this.connection.setAutoCommit(false);
            result = (Boolean)callback.execute();
            this.connection.commit();
        }
        catch (Exception ex) {
            this.connection.rollback();
            throw SQLExceptionTransformEngine.toSQLException((Exception)ex, (DatabaseType)this.metaDataContexts.getMetaData().getDatabase(this.databaseName).getProtocolType());
        }
        finally {
            this.connection.setAutoCommit(true);
        }
        return result;
    }

    private int executeUpdateWithExecutionContext(ExecutionContext executionContext) throws SQLException {
        return this.isNeedImplicitCommitTransaction(this.connection, executionContext.getSqlStatementContext().getSqlStatement(), executionContext.getExecutionUnits().size() > 1) ? this.executeUpdateWithImplicitCommitTransaction((ImplicitTransactionCallback<Integer>)((ImplicitTransactionCallback)() -> this.useDriverToExecuteUpdate(executionContext))) : this.useDriverToExecuteUpdate(executionContext);
    }

    private int executeUpdateWithImplicitCommitTransaction(ImplicitTransactionCallback<Integer> callback) throws SQLException {
        int result;
        try {
            this.connection.setAutoCommit(false);
            result = (Integer)callback.execute();
            this.connection.commit();
        }
        catch (RuntimeException ex) {
            this.connection.rollback();
            throw SQLExceptionTransformEngine.toSQLException((Exception)ex, (DatabaseType)this.metaDataContexts.getMetaData().getDatabase(this.databaseName).getProtocolType());
        }
        finally {
            this.connection.setAutoCommit(true);
        }
        return result;
    }

    private boolean useDriverToExecute(ExecutionContext executionContext) throws SQLException {
        ExecutionGroupContext<JDBCExecutionUnit> executionGroupContext = this.createExecutionGroupContext(executionContext);
        this.cacheStatements(executionGroupContext.getInputGroups());
        return this.executor.getRegularExecutor().execute(executionGroupContext, executionContext.getQueryContext(), executionContext.getRouteContext().getRouteUnits(), this.createExecuteCallback());
    }

    private JDBCExecutorCallback<Boolean> createExecuteCallback() {
        boolean isExceptionThrown = SQLExecutorExceptionHandler.isExceptionThrown();
        return new JDBCExecutorCallback<Boolean>(this.metaDataContexts.getMetaData().getDatabase(this.databaseName).getProtocolType(), this.metaDataContexts.getMetaData().getDatabase(this.databaseName).getResourceMetaData(), this.sqlStatement, isExceptionThrown){

            protected Boolean executeSQL(String sql, Statement statement, ConnectionMode connectionMode, DatabaseType storageType) throws SQLException {
                return ((PreparedStatement)statement).execute();
            }

            protected Optional<Boolean> getSaneResult(SQLStatement sqlStatement, SQLException ex) {
                return Optional.empty();
            }
        };
    }

    private ExecutionGroupContext<JDBCExecutionUnit> createExecutionGroupContext(ExecutionContext executionContext) throws SQLException {
        DriverExecutionPrepareEngine<JDBCExecutionUnit, Connection> prepareEngine = this.createDriverExecutionPrepareEngine();
        return prepareEngine.prepare(executionContext.getRouteContext(), executionContext.getExecutionUnits(), new ExecutionGroupReportContext(this.connection.getProcessId(), this.databaseName, new Grantee("", "")));
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        if (null != this.currentResultSet) {
            return this.currentResultSet;
        }
        if (null != this.trafficInstanceId) {
            return this.executor.getTrafficExecutor().getResultSet();
        }
        if (this.useFederation) {
            return this.executor.getSqlFederationEngine().getResultSet();
        }
        if (this.executionContext.getSqlStatementContext() instanceof SelectStatementContext || this.executionContext.getSqlStatementContext().getSqlStatement() instanceof DALStatement) {
            List<ResultSet> resultSets = this.getResultSets();
            if (resultSets.isEmpty()) {
                return this.currentResultSet;
            }
            SQLStatementContext sqlStatementContext = this.executionContext.getSqlStatementContext();
            MergedResult mergedResult = this.mergeQuery(this.getQueryResults(resultSets), sqlStatementContext);
            if (null == this.columnLabelAndIndexMap) {
                this.columnLabelAndIndexMap = ShardingSphereResultSetUtils.createColumnLabelAndIndexMap(sqlStatementContext, this.selectContainsEnhancedTable, resultSets.get(0).getMetaData());
            }
            this.currentResultSet = new ShardingSphereResultSet(resultSets, mergedResult, this, this.selectContainsEnhancedTable, this.executionContext, this.columnLabelAndIndexMap);
        }
        return this.currentResultSet;
    }

    private List<ResultSet> getResultSets() throws SQLException {
        ArrayList<ResultSet> result = new ArrayList<ResultSet>(this.statements.size());
        for (Statement statement : this.statements) {
            if (null == statement.getResultSet()) continue;
            result.add(statement.getResultSet());
        }
        return result;
    }

    private List<QueryResult> getQueryResults(List<ResultSet> resultSets) throws SQLException {
        ArrayList<QueryResult> result = new ArrayList<QueryResult>(resultSets.size());
        for (ResultSet each : resultSets) {
            if (null == each) continue;
            result.add((QueryResult)new JDBCStreamQueryResult(each));
        }
        return result;
    }

    private ExecutionContext createExecutionContext(QueryContext queryContext) {
        RuleMetaData globalRuleMetaData = this.metaDataContexts.getMetaData().getGlobalRuleMetaData();
        ShardingSphereDatabase currentDatabase = this.metaDataContexts.getMetaData().getDatabase(this.databaseName);
        SQLAuditEngine.audit((SQLStatementContext)queryContext.getSqlStatementContext(), (List)queryContext.getParameters(), (RuleMetaData)globalRuleMetaData, (ShardingSphereDatabase)currentDatabase, null, (HintValueContext)queryContext.getHintValueContext());
        ExecutionContext result = this.kernelProcessor.generateExecutionContext(queryContext, currentDatabase, globalRuleMetaData, this.metaDataContexts.getMetaData().getProps(), this.connection.getDatabaseConnectionManager().getConnectionContext());
        this.findGeneratedKey(result).ifPresent(optional -> this.generatedValues.addAll(optional.getGeneratedValues()));
        return result;
    }

    private ExecutionContext createExecutionContext(QueryContext queryContext, String trafficInstanceId) {
        ExecutionUnit executionUnit = new ExecutionUnit(trafficInstanceId, new SQLUnit(queryContext.getSql(), queryContext.getParameters()));
        return new ExecutionContext(queryContext, Collections.singletonList(executionUnit), new RouteContext());
    }

    private QueryContext createQueryContext() {
        ArrayList<Object> params = new ArrayList<Object>(this.getParameters());
        if (this.sqlStatementContext instanceof ParameterAware) {
            ((ParameterAware)this.sqlStatementContext).setUpParameters(params);
        }
        return new QueryContext(this.sqlStatementContext, this.sql, params, this.hintValueContext, true);
    }

    private MergedResult mergeQuery(List<QueryResult> queryResults, SQLStatementContext sqlStatementContext) throws SQLException {
        MergeEngine mergeEngine = new MergeEngine(this.metaDataContexts.getMetaData().getDatabase(this.databaseName), this.metaDataContexts.getMetaData().getProps(), this.connection.getDatabaseConnectionManager().getConnectionContext());
        return mergeEngine.merge(queryResults, sqlStatementContext);
    }

    private void cacheStatements(Collection<ExecutionGroup<JDBCExecutionUnit>> executionGroups) throws SQLException {
        for (ExecutionGroup<JDBCExecutionUnit> each : executionGroups) {
            each.getInputs().forEach(eachInput -> {
                this.statements.add((PreparedStatement)eachInput.getStorageResource());
                this.parameterSets.add(eachInput.getExecutionUnit().getSqlUnit().getParameters());
            });
        }
        this.replay();
    }

    private void replay() throws SQLException {
        this.replaySetParameter();
        for (Statement statement : this.statements) {
            this.getMethodInvocationRecorder().replay(statement);
        }
    }

    private void replaySetParameter() throws SQLException {
        for (int i = 0; i < this.statements.size(); ++i) {
            this.replaySetParameter(this.statements.get(i), this.parameterSets.get(i));
        }
    }

    private void clearPrevious() {
        this.statements.clear();
        this.parameterSets.clear();
        this.generatedValues.clear();
    }

    private Optional<GeneratedKeyContext> findGeneratedKey(ExecutionContext executionContext) {
        return executionContext.getSqlStatementContext() instanceof InsertStatementContext ? ((InsertStatementContext)executionContext.getSqlStatementContext()).getGeneratedKeyContext() : Optional.empty();
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        if (null != this.currentBatchGeneratedKeysResultSet) {
            return this.currentBatchGeneratedKeysResultSet;
        }
        Optional<GeneratedKeyContext> generatedKey = this.findGeneratedKey(this.executionContext);
        if (generatedKey.isPresent() && this.statementOption.isReturnGeneratedKeys() && !this.generatedValues.isEmpty()) {
            return new GeneratedKeysResultSet(this.getGeneratedKeysColumnName(generatedKey.get().getColumnName()), this.generatedValues.iterator(), this);
        }
        for (PreparedStatement each : this.statements) {
            ResultSet resultSet = each.getGeneratedKeys();
            while (resultSet.next()) {
                this.generatedValues.add((Comparable)resultSet.getObject(1));
            }
        }
        String columnName = generatedKey.map(GeneratedKeyContext::getColumnName).orElse(null);
        return new GeneratedKeysResultSet(this.getGeneratedKeysColumnName(columnName), this.generatedValues.iterator(), this);
    }

    private String getGeneratedKeysColumnName(String columnName) {
        return this.metaDataContexts.getMetaData().getDatabase(this.databaseName).getProtocolType() instanceof MySQLDatabaseType ? "GENERATED_KEY" : columnName;
    }

    @Override
    public void addBatch() {
        try {
            QueryContext queryContext = this.createQueryContext();
            this.trafficInstanceId = this.getInstanceIdAndSet(queryContext).orElse(null);
            this.executionContext = null == this.trafficInstanceId ? this.createExecutionContext(queryContext) : this.createExecutionContext(queryContext, this.trafficInstanceId);
            this.batchPreparedStatementExecutor.addBatchForExecutionUnits(this.executionContext.getExecutionUnits());
        }
        finally {
            this.currentResultSet = null;
            this.clearParameters();
        }
    }

    @Override
    public int[] executeBatch() throws SQLException {
        if (null == this.executionContext) {
            return new int[0];
        }
        try {
            int[] nArray = this.doExecuteBatch(this.batchPreparedStatementExecutor);
            return nArray;
        }
        catch (RuntimeException ex) {
            this.handleExceptionInTransaction(this.connection, this.metaDataContexts);
            throw SQLExceptionTransformEngine.toSQLException((Exception)ex, (DatabaseType)this.metaDataContexts.getMetaData().getDatabase(this.databaseName).getProtocolType());
        }
        finally {
            this.clearBatch();
        }
    }

    private int[] doExecuteBatch(BatchPreparedStatementExecutor batchExecutor) throws SQLException {
        this.initBatchPreparedStatementExecutor(batchExecutor);
        int[] result = batchExecutor.executeBatch(this.executionContext.getSqlStatementContext());
        if (this.statementOption.isReturnGeneratedKeys() && this.generatedValues.isEmpty()) {
            List<Statement> batchPreparedStatementExecutorStatements = batchExecutor.getStatements();
            for (Statement statement : batchPreparedStatementExecutorStatements) {
                this.statements.add((PreparedStatement)statement);
            }
            this.currentBatchGeneratedKeysResultSet = this.getGeneratedKeys();
            this.statements.clear();
        }
        return result;
    }

    private void initBatchPreparedStatementExecutor(BatchPreparedStatementExecutor batchExecutor) throws SQLException {
        DriverExecutionPrepareEngine prepareEngine = new DriverExecutionPrepareEngine("JDBC.PREPARED_STATEMENT", ((Integer)this.metaDataContexts.getMetaData().getProps().getValue((Enum)ConfigurationPropertyKey.MAX_CONNECTIONS_SIZE_PER_QUERY)).intValue(), (DatabaseConnectionManager)this.connection.getDatabaseConnectionManager(), (ExecutorStatementManager)this.statementManager, (StorageResourceOption)this.statementOption, this.metaDataContexts.getMetaData().getDatabase(this.databaseName).getRuleMetaData().getRules(), this.metaDataContexts.getMetaData().getDatabase(this.databaseName).getResourceMetaData().getStorageUnits());
        ArrayList<ExecutionUnit> executionUnits = new ArrayList<ExecutionUnit>(batchExecutor.getBatchExecutionUnits().size());
        for (BatchExecutionUnit each : batchExecutor.getBatchExecutionUnits()) {
            ExecutionUnit executionUnit = each.getExecutionUnit();
            executionUnits.add(executionUnit);
        }
        batchExecutor.init((ExecutionGroupContext<JDBCExecutionUnit>)prepareEngine.prepare(this.executionContext.getRouteContext(), executionUnits, new ExecutionGroupReportContext(this.connection.getProcessId(), this.databaseName, new Grantee("", ""))));
        this.setBatchParametersForStatements(batchExecutor);
    }

    private void setBatchParametersForStatements(BatchPreparedStatementExecutor batchExecutor) throws SQLException {
        for (Statement each : batchExecutor.getStatements()) {
            List<List<Object>> paramSet = batchExecutor.getParameterSet(each);
            for (List<Object> eachParams : paramSet) {
                this.replaySetParameter((PreparedStatement)each, eachParams);
                ((PreparedStatement)each).addBatch();
            }
        }
    }

    @Override
    public void clearBatch() {
        this.currentResultSet = null;
        this.batchPreparedStatementExecutor.clear();
        this.clearParameters();
    }

    @Override
    public int getResultSetType() {
        return this.statementOption.getResultSetType();
    }

    @Override
    public int getResultSetConcurrency() {
        return this.statementOption.getResultSetConcurrency();
    }

    @Override
    public int getResultSetHoldability() {
        return this.statementOption.getResultSetHoldability();
    }

    @Override
    public boolean isAccumulate() {
        for (DataNodeRuleAttribute each : this.metaDataContexts.getMetaData().getDatabase(this.databaseName).getRuleMetaData().getAttributes(DataNodeRuleAttribute.class)) {
            if (!each.isNeedAccumulate(this.executionContext.getSqlStatementContext().getTablesContext().getTableNames())) continue;
            return true;
        }
        return false;
    }

    public Collection<PreparedStatement> getRoutedStatements() {
        return this.statements;
    }

    @Override
    @Generated
    public ShardingSphereConnection getConnection() {
        return this.connection;
    }

    @Override
    @Generated
    public ParameterMetaData getParameterMetaData() {
        return this.parameterMetaData;
    }

    @Override
    @Generated
    protected DriverExecutor getExecutor() {
        return this.executor;
    }

    @Override
    @Generated
    protected StatementManager getStatementManager() {
        return this.statementManager;
    }

    @Generated
    public boolean isSelectContainsEnhancedTable() {
        return this.selectContainsEnhancedTable;
    }
}

