/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shale.test.el;

import java.util.ArrayList;
import javax.el.ELContext;
import javax.el.ELResolver;
import javax.el.ValueExpression;
import javax.faces.context.FacesContext;

public class MockValueExpression
extends ValueExpression {
    private static final long serialVersionUID = -8649071428507512623L;
    private String[] elements = null;
    private Class expectedType = null;
    private String expression = null;

    public MockValueExpression(String expression, Class expectedType) {
        if (expression == null) {
            throw new NullPointerException("Expression string cannot be null");
        }
        this.expression = expression;
        this.expectedType = expectedType;
        this.parse();
    }

    public boolean equals(Object obj) {
        if (obj != null & obj instanceof ValueExpression) {
            return this.expression.equals(((ValueExpression)obj).getExpressionString());
        }
        return false;
    }

    public String getExpressionString() {
        return this.expression;
    }

    public int hashCode() {
        return this.expression.hashCode();
    }

    public boolean isLiteralText() {
        return this.expression.indexOf("${") < 0 && this.expression.indexOf("#{") < 0;
    }

    public Class getExpectedType() {
        return this.expectedType;
    }

    public Class getType(ELContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        Object value = this.getValue(context);
        if (value == null) {
            return null;
        }
        return value.getClass();
    }

    public Object getValue(ELContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (this.isLiteralText()) {
            return this.expression;
        }
        FacesContext fcontext = (FacesContext)context.getContext(FacesContext.class);
        ELResolver resolver = fcontext.getApplication().getELResolver();
        Object base = null;
        for (int i = 0; i < this.elements.length; ++i) {
            base = resolver.getValue(context, base, (Object)this.elements[i]);
        }
        return fcontext.getApplication().getExpressionFactory().coerceToType(base, this.getExpectedType());
    }

    public boolean isReadOnly(ELContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (this.isLiteralText()) {
            return true;
        }
        FacesContext fcontext = (FacesContext)context.getContext(FacesContext.class);
        ELResolver resolver = fcontext.getApplication().getELResolver();
        Object base = null;
        for (int i = 0; i < this.elements.length - 1; ++i) {
            base = resolver.getValue(context, base, (Object)this.elements[i]);
        }
        return resolver.isReadOnly(context, base, (Object)this.elements[this.elements.length - 1]);
    }

    public void setValue(ELContext context, Object value) {
        if (context == null) {
            throw new NullPointerException();
        }
        FacesContext fcontext = (FacesContext)context.getContext(FacesContext.class);
        ELResolver resolver = fcontext.getApplication().getELResolver();
        Object base = null;
        for (int i = 0; i < this.elements.length - 1; ++i) {
            base = resolver.getValue(context, base, (Object)this.elements[i]);
        }
        resolver.setValue(context, base, (Object)this.elements[this.elements.length - 1], value);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void parse() {
        if (this.isLiteralText()) {
            this.elements = new String[0];
            return;
        }
        if (!this.expression.startsWith("${") && !this.expression.startsWith("#{")) throw new IllegalArgumentException(this.expression);
        if (!this.expression.endsWith("}")) throw new IllegalArgumentException(this.expression);
        ArrayList<String> names = new ArrayList<String>();
        StringBuffer expr = new StringBuffer(this.expression.substring(2, this.expression.length() - 1).replaceAll(" ", ""));
        boolean isBlockOn = false;
        for (int i = expr.length() - 1; i > -1; --i) {
            if (expr.charAt(i) == ' ') {
                expr.deleteCharAt(i);
                continue;
            }
            if (expr.charAt(i) == ']') {
                expr.deleteCharAt(i);
                continue;
            }
            if (expr.charAt(i) == '[') {
                expr.deleteCharAt(i);
                continue;
            }
            if (expr.charAt(i) == '\'') {
                if (!isBlockOn) {
                    expr.deleteCharAt(i);
                } else {
                    names.add(0, expr.substring(i + 1));
                    expr.delete(i, expr.length());
                }
                isBlockOn = !isBlockOn;
                continue;
            }
            if (expr.charAt(i) != '.' || isBlockOn) continue;
            names.add(0, expr.substring(i + 1));
            expr.delete(i, expr.length());
        }
        if (expr.length() > 0) {
            names.add(0, expr.toString());
        }
        this.elements = names.toArray(new String[names.size()]);
    }
}

