/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.testsuite.test.jsr286.event;

import java.lang.reflect.Method;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletRequest;
import javax.portlet.StateAwareResponse;
import org.apache.pluto.testsuite.TestResult;
import org.apache.pluto.testsuite.annotations.DefaultTestPhase;
import org.apache.pluto.testsuite.annotations.TestPhase;
import org.apache.pluto.testsuite.test.AbstractReflectivePortletTest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DefaultTestPhase(value="EVENT_PHASE")
public abstract class BaseEventTest
extends AbstractReflectivePortletTest {
    private int numMethodsCache = -1;
    protected Logger LOG = LoggerFactory.getLogger(this.getClass());

    @TestPhase(value="ACTION_PHASE")
    public TestResult checkFireEventsFromActionPhase(ActionRequest request, ActionResponse response) {
        this.tally((StateAwareResponse)response);
        TestResult result = new TestResult();
        result.setReturnCode(-1);
        result.setDescription("Fire several events to test processing. Be sure to check to Companion portlet to make sure that all tests are correctly run.");
        result.setSpecPLT("15.2.3");
        this.fireEvents(request, response);
        return result;
    }

    protected int getNumberOfMethodsThatShouldRun(PortletRequest request) {
        if (this.numMethodsCache == -1) {
            Class<?> clazz = this.getClass();
            for (Method m : clazz.getMethods()) {
                if (!m.getName().startsWith("check") || !m.getReturnType().equals(TestResult.class)) continue;
                for (Class<?> paramType : m.getParameterTypes()) {
                    if (!StateAwareResponse.class.isAssignableFrom(paramType)) continue;
                    ++this.numMethodsCache;
                }
            }
        }
        return this.numMethodsCache;
    }

    protected void tally(StateAwareResponse response) {
    }

    protected abstract void fireEvents(ActionRequest var1, ActionResponse var2);
}

