/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.testsuite.test;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;
import org.apache.pluto.testsuite.TestResult;
import org.apache.pluto.testsuite.test.AbstractReflectivePortletTest;

public class ResourceBundleTest
extends AbstractReflectivePortletTest {
    private static final String TITLE_KEY = "javax.portlet.title";
    private static final String SHORT_TITLE_KEY = "javax.portlet.short-title";
    private static final String KEYWORDS_KEY = "javax.portlet.keywords";
    private static final String BUNDLE_DECLARED_PARAM = "resource-bundle";
    private static final String TITLE_PARAM = "title";
    private static final String SHORT_TITLE_PARAM = "short-title";
    private static final String KEYWORDS_PARAM = "keywords";

    protected TestResult checkResourceBundleExists(PortletConfig config, PortletRequest request) {
        TestResult result = new TestResult();
        result.setDescription("Ensure the resource bundle is not null.");
        ResourceBundle bundle = config.getResourceBundle(request.getLocale());
        if (bundle != null) {
            result.setReturnCode(2);
        } else {
            result.setReturnCode(1);
            result.setResultMessage("Unable to retrieve resource bundle for locale: " + request.getLocale());
        }
        return result;
    }

    protected TestResult checkGetNames(PortletConfig config, PortletRequest request) {
        TestResult result = new TestResult();
        result.setDescription("Retrieve the property names and ensure that the required keys are present.");
        ArrayList<String> requiredKeys = new ArrayList<String>();
        requiredKeys.add(TITLE_KEY);
        requiredKeys.add(SHORT_TITLE_KEY);
        requiredKeys.add(KEYWORDS_KEY);
        ResourceBundle bundle = config.getResourceBundle(request.getLocale());
        if (bundle == null) {
            result.setReturnCode(0);
            result.setResultMessage("A function upon which this test depends failed to execute as expected. Check the other test results in this test suite.");
            return result;
        }
        Enumeration<String> en = bundle.getKeys();
        while (en.hasMoreElements()) {
            String key = en.nextElement();
            requiredKeys.remove(key);
        }
        if (requiredKeys.isEmpty()) {
            result.setReturnCode(2);
        } else {
            result.setReturnCode(1);
            StringBuffer buffer = new StringBuffer();
            Iterator it = requiredKeys.iterator();
            while (it.hasNext()) {
                buffer.append((String)it.next()).append(", ");
            }
            result.setResultMessage("Required keys [" + buffer.toString() + "] are missing in the resource bundle.");
        }
        return result;
    }

    protected TestResult checkGetGermanBundle(PortletConfig config, PortletRequest request) {
        return this.doGenericLocaleRequiredFields(config, request, Locale.GERMAN);
    }

    protected TestResult checkGetEnglishBundle(PortletConfig config, PortletRequest request) {
        return this.doGenericLocaleRequiredFields(config, request, Locale.ENGLISH);
    }

    private TestResult doGenericLocaleRequiredFields(PortletConfig config, PortletRequest request, Locale locale) {
        TestResult result = new TestResult();
        result.setDescription("Retrieve the title and ensure it's set properly under locale " + locale);
        ResourceBundle bundle = config.getResourceBundle(locale);
        if (bundle == null) {
            result.setReturnCode(0);
            result.setResultMessage("A function upon which this test depends failed to execute as expected. Check the other test results in this test suite.");
            return result;
        }
        String title = bundle.getString(TITLE_KEY);
        String shortTitle = bundle.getString(SHORT_TITLE_KEY);
        String keywords = bundle.getString(KEYWORDS_KEY);
        String suffix = this.isBundleDeclared() ? "_" + locale.getLanguage() : "";
        Map initParams = this.getInitParameters();
        String expectedTitle = (String)initParams.get(TITLE_PARAM + suffix);
        String expectedShortTitle = (String)initParams.get(SHORT_TITLE_PARAM + suffix);
        String expectedKeywords = (String)initParams.get(KEYWORDS_PARAM + suffix);
        boolean inconsistent = false;
        StringBuffer buffer = new StringBuffer();
        buffer.append("The following information is not correct: ");
        if (title == null || expectedTitle == null || !title.trim().equals(expectedTitle.trim())) {
            inconsistent = true;
            buffer.append("Inconsistent title: '").append(title).append("' != '").append(expectedTitle).append("'; ");
        }
        if (shortTitle == null || expectedShortTitle == null || !shortTitle.trim().equals(expectedShortTitle.trim())) {
            inconsistent = true;
            buffer.append("Inconsistent short title: '").append(shortTitle).append("' != '").append(expectedShortTitle).append("'; ");
        }
        if (keywords == null || expectedKeywords == null || !keywords.trim().equals(expectedKeywords.trim())) {
            inconsistent = true;
            buffer.append("Inconsistent keywords: '").append(keywords).append("' != '").append(expectedKeywords).append("'; ");
        }
        if (!inconsistent) {
            result.setReturnCode(2);
        } else {
            result.setReturnCode(1);
            result.setResultMessage(buffer.toString());
        }
        return result;
    }

    private boolean isBundleDeclared() {
        String bundleDeclared = (String)this.getInitParameters().get(BUNDLE_DECLARED_PARAM);
        return Boolean.TRUE.toString().equalsIgnoreCase(bundleDeclared);
    }
}

