/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.testsuite.test;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.portlet.PortletRequest;
import org.apache.pluto.testsuite.TestResult;
import org.apache.pluto.testsuite.TestUtils;
import org.apache.pluto.testsuite.test.AbstractReflectivePortletTest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RenderParameterTest
extends AbstractReflectivePortletTest {
    private static final String ACTION_KEY = "org.apache.pluto.testsuite.PARAM_ACTION_KEY";
    private static final String RENDER_KEY = "org.apache.pluto.testsuite.PARAM_RENDER_KEY";
    private static final String RENDER_VALUE = "org.apache.pluto.testsuite.RENDER_VALUE";

    public Map<String, String[]> getRenderParameters(PortletRequest request) {
        HashMap<String, String[]> parameterMap = new HashMap<String, String[]>();
        parameterMap.put(RENDER_KEY, new String[]{RENDER_VALUE});
        return parameterMap;
    }

    protected TestResult checkActionParametersNotHere(PortletRequest request) {
        TestResult result = new TestResult();
        result.setDescription("Ensure that action parameters are not available in the following render request.");
        String value = request.getParameter(ACTION_KEY);
        if (value == null) {
            result.setReturnCode(2);
        } else {
            TestUtils.failOnAssertion((String)"parameter", (Object)value, null, (TestResult)result);
        }
        return result;
    }

    protected TestResult checkRenderParameterValue(PortletRequest request) {
        TestResult result = new TestResult();
        result.setDescription("Ensure that render parameters set in action response are available in the following render request.");
        String value = request.getParameter(RENDER_KEY);
        if (RENDER_VALUE.equals(value)) {
            result.setReturnCode(2);
        } else {
            TestUtils.failOnAssertion((String)"parameter", (Object)value, (Object)RENDER_VALUE, (TestResult)result);
        }
        return result;
    }

    protected TestResult checkRenderParameterValues(PortletRequest request) {
        TestResult result = new TestResult();
        result.setDescription("Ensure that render parameters set in action response are available in the following render request.");
        String[] values = request.getParameterValues(RENDER_KEY);
        if (values != null && values.length == 1 && RENDER_VALUE.equals(values[0])) {
            result.setReturnCode(2);
        } else {
            TestUtils.failOnAssertion((String)"parameter values", (String[])values, (String[])new String[]{RENDER_VALUE}, (TestResult)result);
        }
        return result;
    }

    protected TestResult checkParameterMap(PortletRequest request) {
        TestResult result = new TestResult();
        result.setDescription("Ensure that render request returns the correct parameter map.");
        Map parameterMap = request.getParameterMap();
        String[] values = (String[])parameterMap.get(RENDER_KEY);
        if (values != null && values.length == 1 && RENDER_VALUE.equals(values[0]) && !parameterMap.containsKey(ACTION_KEY)) {
            result.setReturnCode(2);
        } else if (parameterMap.containsKey(ACTION_KEY)) {
            result.setReturnCode(1);
            result.setResultMessage("Action parameter org.apache.pluto.testsuite.PARAM_ACTION_KEY was found in render request with value(s): " + parameterMap.get(ACTION_KEY));
        } else {
            TestUtils.failOnAssertion((String)"parameter values", (String[])values, (String[])new String[]{RENDER_VALUE}, (TestResult)result);
        }
        return result;
    }

    protected TestResult checkParameterNames(PortletRequest request) {
        TestResult result = new TestResult();
        result.setDescription("Ensure that render request returns the correct parameter names enumeration.");
        boolean hasActionParameter = false;
        boolean hasRenderParameter = false;
        Enumeration en = request.getParameterNames();
        while (en.hasMoreElements()) {
            String name = (String)en.nextElement();
            if (ACTION_KEY.equals(name)) {
                hasActionParameter = true;
            }
            if (!RENDER_KEY.equals(name)) continue;
            hasRenderParameter = true;
        }
        if (!hasActionParameter && hasRenderParameter) {
            result.setReturnCode(2);
        } else {
            result.setReturnCode(1);
            StringBuffer buffer = new StringBuffer();
            if (!hasRenderParameter) {
                buffer.append("Render parameter not found. ");
            }
            if (!hasActionParameter) {
                buffer.append("Action parameter found. ");
            }
            result.setResultMessage(buffer.toString());
        }
        return result;
    }
}

