/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.testsuite.test;

import java.io.IOException;
import javax.portlet.ActionRequest;
import javax.portlet.PortletPreferences;
import javax.portlet.ReadOnlyException;
import javax.portlet.ValidatorException;
import org.apache.pluto.testsuite.TestResult;
import org.apache.pluto.testsuite.TestUtils;
import org.apache.pluto.testsuite.annotations.DefaultTestPhase;
import org.apache.pluto.testsuite.test.PreferenceCommonTest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DefaultTestPhase(value="ACTION_PHASE")
public class PreferenceInActionTest
extends PreferenceCommonTest {
    private static final Logger LOG = LoggerFactory.getLogger(PreferenceInActionTest.class);

    protected TestResult checkPreferenceValidator(ActionRequest request) {
        TestResult result = new TestResult();
        result.setDescription("Ensure the validator catches invalid preferences.");
        result.setSpecPLT("14.4");
        PortletPreferences preferences = request.getPreferences();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Original preferences:");
            this.logPreferences(preferences);
        }
        boolean exceptionThrown = false;
        try {
            preferences.setValue("TEST", " Spaces removed by trim ");
            if (LOG.isDebugEnabled()) {
                LOG.debug("Modified VALIDATION_TEST_KEY preference:");
                this.logPreferences(preferences);
            }
            preferences.store();
        }
        catch (ReadOnlyException ex) {
            TestUtils.failOnException((String)"Unable to set preference value.", (Throwable)ex, (TestResult)result);
            return result;
        }
        catch (IOException ex) {
            TestUtils.failOnException((String)"Unable to store preference value.", (Throwable)ex, (TestResult)result);
            return result;
        }
        catch (ValidatorException ex) {
            exceptionThrown = true;
            try {
                preferences.setValue("TEST", "OK");
                preferences.reset("TEST");
            }
            catch (Throwable th) {
                LOG.error(th.getMessage(), th);
            }
        }
        if (exceptionThrown) {
            result.setReturnCode(2);
        } else {
            result.setReturnCode(1);
            result.setResultMessage("Illegal value not caught by validator.");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TestResult checkOnePreferenceValidatorPerPortletDefinition(ActionRequest request) {
        TestResult result = new TestResult();
        result.setDescription("Ensure only one validator instance is created per portlet definition.");
        result.setSpecPLT("14.4");
        PortletPreferences preferences = request.getPreferences();
        try {
            preferences.setValue("checkValidatorCount", "true");
            preferences.store();
            result.setReturnCode(2);
        }
        catch (ReadOnlyException ex) {
            TestUtils.failOnException((String)"Unable to set preference value.", (Throwable)ex, (TestResult)result);
        }
        catch (IOException ex) {
            TestUtils.failOnException((String)"Unable to store preference value.", (Throwable)ex, (TestResult)result);
        }
        catch (ValidatorException ex) {
            TestUtils.failOnException((String)"Unable to store preference value.", (Throwable)ex, (TestResult)result);
        }
        finally {
            try {
                preferences.reset("checkValidatorCount");
                preferences.store();
            }
            catch (Exception ex) {
                TestUtils.failOnException((String)"Unable to reset preference value for checkValidatorCount", (Throwable)ex, (TestResult)result);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TestResult checkStorePreferences(ActionRequest request) {
        TestResult result = new TestResult();
        result.setDescription("Ensure storage works for portlet preferences.");
        result.setSpecPLT("14.1");
        PortletPreferences preferences = request.getPreferences();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Preferences to store: " + preferences);
        }
        boolean setOccured = false;
        boolean storeOccured = false;
        try {
            preferences.setValue("dummyName", "notTheOriginal");
            String value = preferences.getValue("dummyName", "Default");
            if ("notTheOriginal".equals(value)) {
                setOccured = true;
            }
            preferences.store();
            value = preferences.getValue("dummyName", "Default");
            if ("notTheOriginal".equals(value)) {
                storeOccured = true;
            }
        }
        catch (ReadOnlyException ex) {
            TestUtils.failOnException((String)"Unable to set preference value.", (Throwable)ex, (TestResult)result);
            TestResult testResult = result;
            return testResult;
        }
        catch (ValidatorException ex) {
            TestUtils.failOnException((String)"Unable to store preference value.", (Throwable)ex, (TestResult)result);
            TestResult testResult = result;
            return testResult;
        }
        catch (IOException ex) {
            TestUtils.failOnException((String)"Unable to store preference value.", (Throwable)ex, (TestResult)result);
            TestResult testResult = result;
            return testResult;
        }
        finally {
            try {
                preferences.reset("dummyName");
                preferences.store();
            }
            catch (Exception ex) {
                TestUtils.failOnException((String)"Unable to set preference value.", (Throwable)ex, (TestResult)result);
                return result;
            }
        }
        if (setOccured && storeOccured) {
            result.setReturnCode(2);
        } else if (!setOccured) {
            result.setReturnCode(0);
            result.setResultMessage("A function upon which the reset test depends failed to execute as expected. Check the other test results in this test suite.");
        } else {
            result.setReturnCode(1);
            result.setResultMessage("Preferences not successfully stored.");
        }
        return result;
    }
}

