/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xslf.usermodel;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.poi.POIXMLException;
import org.apache.poi.xslf.usermodel.DrawingParagraph;
import org.apache.poi.xslf.usermodel.DrawingTable;
import org.apache.poi.xslf.usermodel.DrawingTableCell;
import org.apache.poi.xslf.usermodel.DrawingTableRow;
import org.apache.poi.xslf.usermodel.DrawingTextBody;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.impl.values.XmlAnyTypeImpl;
import org.openxmlformats.schemas.drawingml.x2006.main.CTGraphicalObjectData;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTable;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextBody;
import org.openxmlformats.schemas.presentationml.x2006.main.CTCommonSlideData;
import org.openxmlformats.schemas.presentationml.x2006.main.CTGraphicalObjectFrame;
import org.openxmlformats.schemas.presentationml.x2006.main.CTGroupShape;
import org.openxmlformats.schemas.presentationml.x2006.main.CTShape;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XSLFCommonSlideData {
    private final CTCommonSlideData data;

    public XSLFCommonSlideData(CTCommonSlideData data) {
        this.data = data;
    }

    public List<DrawingParagraph> getText() {
        CTGroupShape gs = this.data.getSpTree();
        ArrayList<DrawingParagraph> out = new ArrayList<DrawingParagraph>();
        this.processShape(gs, out);
        for (CTGroupShape shape : gs.getGrpSpList()) {
            this.processShape(shape, out);
        }
        for (CTGraphicalObjectFrame frame : gs.getGraphicFrameList()) {
            CTGraphicalObjectData data = frame.getGraphic().getGraphicData();
            XmlCursor c = data.newCursor();
            c.selectPath("declare namespace pic='" + CTTable.type.getName().getNamespaceURI() + "' .//pic:tbl");
            while (c.toNextSelection()) {
                XmlObject o = c.getObject();
                if (o instanceof XmlAnyTypeImpl) {
                    try {
                        o = CTTable.Factory.parse((String)o.toString());
                    }
                    catch (XmlException e) {
                        throw new POIXMLException(e);
                    }
                }
                if (!(o instanceof CTTable)) continue;
                DrawingTable table = new DrawingTable((CTTable)o);
                for (DrawingTableRow row : table.getRows()) {
                    for (DrawingTableCell cell : row.getCells()) {
                        DrawingTextBody textBody = cell.getTextBody();
                        out.addAll(Arrays.asList(textBody.getParagraphs()));
                    }
                }
            }
            c.dispose();
        }
        return out;
    }

    private void processShape(CTGroupShape gs, List<DrawingParagraph> out) {
        List shapes = gs.getSpList();
        for (int i = 0; i < shapes.size(); ++i) {
            CTTextBody ctTextBody = ((CTShape)shapes.get(i)).getTxBody();
            if (ctTextBody == null) continue;
            DrawingTextBody textBody = new DrawingTextBody(ctTextBody);
            out.addAll(Arrays.asList(textBody.getParagraphs()));
        }
    }
}

