/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xssf.usermodel;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.poi.POIXMLException;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.ss.usermodel.PictureData;
import org.apache.poi.util.IOUtils;
import org.apache.poi.xssf.model.XSSFWritableModel;

public final class XSSFActiveXData
implements PictureData,
XSSFWritableModel {
    private final PackagePart _packagePart;
    private final String _originalId;

    public XSSFActiveXData(PackagePart packagePart, String originalId) {
        this._packagePart = packagePart;
        this._originalId = originalId;
    }

    public XSSFActiveXData(PackagePart packagePart) {
        this(packagePart, null);
    }

    public String getOriginalId() {
        return this._originalId;
    }

    public PackagePart getPart() {
        return this._packagePart;
    }

    public void writeTo(OutputStream out) throws IOException {
        IOUtils.copy((InputStream)this._packagePart.getInputStream(), (OutputStream)out);
    }

    public byte[] getData() {
        try {
            return IOUtils.toByteArray((InputStream)this._packagePart.getInputStream());
        }
        catch (IOException e) {
            throw new POIXMLException(e);
        }
    }

    public String suggestFileExtension() {
        return this._packagePart.getPartName().getExtension();
    }
}

