/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.examples.signature;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.net.URL;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.Calendar;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.examples.signature.CreateSignatureBase;
import org.apache.pdfbox.examples.signature.TSAClient;
import org.apache.pdfbox.io.IOUtils;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.ExternalSigningSupport;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.PDSignature;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.SignatureInterface;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.SignatureOptions;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.visible.PDVisibleSigProperties;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.visible.PDVisibleSignDesigner;
import org.apache.pdfbox.pdmodel.interactive.form.PDAcroForm;
import org.apache.pdfbox.pdmodel.interactive.form.PDSignatureField;
import org.apache.pdfbox.util.Hex;

public class CreateVisibleSignature
extends CreateSignatureBase {
    private SignatureOptions signatureOptions;
    private PDVisibleSignDesigner visibleSignDesigner;
    private final PDVisibleSigProperties visibleSignatureProperties = new PDVisibleSigProperties();
    private boolean lateExternalSigning = false;

    public boolean isLateExternalSigning() {
        return this.lateExternalSigning;
    }

    public void setLateExternalSigning(boolean lateExternalSigning) {
        this.lateExternalSigning = lateExternalSigning;
    }

    public void setVisibleSignDesigner(String filename, int x, int y, int zoomPercent, FileInputStream imageStream, int page) throws IOException {
        this.visibleSignDesigner = new PDVisibleSignDesigner(filename, (InputStream)imageStream, page);
        this.visibleSignDesigner.xAxis((float)x).yAxis((float)y).zoom((float)zoomPercent).adjustForRotation();
    }

    public void setVisibleSignDesigner(int zoomPercent, FileInputStream imageStream) throws IOException {
        this.visibleSignDesigner = new PDVisibleSignDesigner((InputStream)imageStream);
        this.visibleSignDesigner.zoom((float)zoomPercent);
    }

    public void setVisibleSignatureProperties(String name, String location, String reason, int preferredSize, int page, boolean visualSignEnabled) throws IOException {
        this.visibleSignatureProperties.signerName(name).signerLocation(location).signatureReason(reason).preferredSize(preferredSize).page(page).visualSignEnabled(visualSignEnabled).setPdVisibleSignature(this.visibleSignDesigner);
    }

    public void setVisibleSignatureProperties(String name, String location, String reason, boolean visualSignEnabled) throws IOException {
        this.visibleSignatureProperties.signerName(name).signerLocation(location).signatureReason(reason).visualSignEnabled(visualSignEnabled).setPdVisibleSignature(this.visibleSignDesigner);
    }

    public CreateVisibleSignature(KeyStore keystore, char[] pin) throws KeyStoreException, UnrecoverableKeyException, NoSuchAlgorithmException, IOException, CertificateException {
        super(keystore, pin);
    }

    public void signPDF(File inputFile, File signedFile, TSAClient tsaClient) throws IOException {
        this.signPDF(inputFile, signedFile, tsaClient, null);
    }

    public void signPDF(File inputFile, File signedFile, TSAClient tsaClient, String signatureFieldName) throws IOException {
        CreateVisibleSignature signatureInterface;
        PDAcroForm acroForm;
        this.setTsaClient(tsaClient);
        if (inputFile == null || !inputFile.exists()) {
            throw new IOException("Document for signing does not exist");
        }
        FileOutputStream fos = new FileOutputStream(signedFile);
        PDDocument doc = PDDocument.load((File)inputFile);
        int accessPermissions = this.getMDPPermission(doc);
        if (accessPermissions == 1) {
            throw new IllegalStateException("No changes to the document are permitted due to DocMDP transform parameters dictionary");
        }
        PDSignature signature = this.findExistingSignature(doc, signatureFieldName);
        if (signature == null) {
            signature = new PDSignature();
        }
        if (doc.getVersion() >= 1.5f && accessPermissions == 0) {
            this.setMDPPermission(doc, signature, 2);
        }
        if ((acroForm = doc.getDocumentCatalog().getAcroForm()) != null && acroForm.getNeedAppearances()) {
            if (acroForm.getFields().isEmpty()) {
                acroForm.getCOSObject().removeItem(COSName.NEED_APPEARANCES);
            } else {
                System.out.println("/NeedAppearances is set, signature may be ignored by Adobe Reader");
            }
        }
        signature.setFilter(PDSignature.FILTER_ADOBE_PPKLITE);
        signature.setSubFilter(PDSignature.SUBFILTER_ADBE_PKCS7_DETACHED);
        if (this.visibleSignatureProperties != null) {
            this.visibleSignatureProperties.buildSignature();
            signature.setName(this.visibleSignatureProperties.getSignerName());
            signature.setLocation(this.visibleSignatureProperties.getSignerLocation());
            signature.setReason(this.visibleSignatureProperties.getSignatureReason());
        }
        signature.setSignDate(Calendar.getInstance());
        CreateVisibleSignature createVisibleSignature = signatureInterface = this.isExternalSigning() ? null : this;
        if (this.visibleSignatureProperties != null && this.visibleSignatureProperties.isVisualSignEnabled()) {
            this.signatureOptions = new SignatureOptions();
            this.signatureOptions.setVisualSignature(this.visibleSignatureProperties.getVisibleSignature());
            this.signatureOptions.setPage(this.visibleSignatureProperties.getPage() - 1);
            doc.addSignature(signature, (SignatureInterface)signatureInterface, this.signatureOptions);
        } else {
            doc.addSignature(signature, (SignatureInterface)signatureInterface);
        }
        if (this.isExternalSigning()) {
            System.out.println("Signing externally " + signedFile.getName());
            ExternalSigningSupport externalSigning = doc.saveIncrementalForExternalSigning((OutputStream)fos);
            byte[] cmsSignature = this.sign(externalSigning.getContent());
            if (this.isLateExternalSigning()) {
                externalSigning.setSignature(new byte[0]);
                int offset = signature.getByteRange()[1] + 1;
                RandomAccessFile raf = new RandomAccessFile(signedFile, "rw");
                raf.seek(offset);
                raf.write(Hex.getBytes((byte[])cmsSignature));
                raf.close();
            } else {
                externalSigning.setSignature(cmsSignature);
            }
        } else {
            doc.saveIncremental((OutputStream)fos);
        }
        doc.close();
        IOUtils.closeQuietly((Closeable)this.signatureOptions);
    }

    private PDSignature findExistingSignature(PDDocument doc, String sigFieldName) {
        PDSignatureField signatureField;
        PDSignature signature = null;
        PDAcroForm acroForm = doc.getDocumentCatalog().getAcroForm();
        if (acroForm != null && (signatureField = (PDSignatureField)acroForm.getField(sigFieldName)) != null) {
            signature = signatureField.getSignature();
            if (signature == null) {
                signature = new PDSignature();
                signatureField.getCOSObject().setItem(COSName.V, (COSObjectable)signature);
            } else {
                throw new IllegalStateException("The signature field " + sigFieldName + " is already signed.");
            }
        }
        return signature;
    }

    public static void main(String[] args) throws KeyStoreException, CertificateException, IOException, NoSuchAlgorithmException, UnrecoverableKeyException {
        if (args.length < 4) {
            CreateVisibleSignature.usage();
            System.exit(1);
        }
        String tsaUrl = null;
        boolean externalSig = false;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-tsa")) {
                if (++i >= args.length) {
                    CreateVisibleSignature.usage();
                    System.exit(1);
                }
                tsaUrl = args[i];
            }
            if (!args[i].equals("-e")) continue;
            externalSig = true;
        }
        File ksFile = new File(args[0]);
        KeyStore keystore = KeyStore.getInstance("PKCS12");
        char[] pin = args[1].toCharArray();
        keystore.load(new FileInputStream(ksFile), pin);
        TSAClient tsaClient = null;
        if (tsaUrl != null) {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            tsaClient = new TSAClient(new URL(tsaUrl), null, null, digest);
        }
        File documentFile = new File(args[2]);
        CreateVisibleSignature signing = new CreateVisibleSignature(keystore, (char[])pin.clone());
        FileInputStream imageStream = new FileInputStream(args[3]);
        String name = documentFile.getName();
        String substring = name.substring(0, name.lastIndexOf(46));
        File signedDocumentFile = new File(documentFile.getParent(), substring + "_signed.pdf");
        int page = 1;
        signing.setVisibleSignDesigner(args[2], 0, 0, -50, imageStream, page);
        imageStream.close();
        signing.setVisibleSignatureProperties("name", "location", "Security", 0, page, true);
        signing.setExternalSigning(externalSig);
        signing.signPDF(documentFile, signedDocumentFile, tsaClient);
    }

    private static void usage() {
        System.err.println("Usage: java " + CreateVisibleSignature.class.getName() + " <pkcs12-keystore-file> <pin> <input-pdf> <sign-image>\n" + "" + "options:\n" + "  -tsa <url>    sign timestamp using the given TSA server\n" + "  -e            sign using external signature creation scenario");
    }
}

