/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.examples.signature;

import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.examples.signature.CMSProcessableInputStream;
import org.apache.pdfbox.examples.signature.TSAClient;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.PDSignature;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.SignatureInterface;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.cms.Attributes;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.Certificate;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaCertStore;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSSignedDataGenerator;
import org.bouncycastle.cms.CMSTypedData;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.cms.jcajce.JcaSignerInfoGeneratorBuilder;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;
import org.bouncycastle.tsp.TSPException;
import org.bouncycastle.util.Store;

public abstract class CreateSignatureBase
implements SignatureInterface {
    private PrivateKey privateKey;
    private java.security.cert.Certificate certificate;
    private java.security.cert.Certificate[] certificateChain;
    private TSAClient tsaClient;
    private boolean externalSigning;

    public CreateSignatureBase(KeyStore keystore, char[] pin) throws KeyStoreException, UnrecoverableKeyException, NoSuchAlgorithmException, IOException, CertificateException {
        Enumeration<String> aliases = keystore.aliases();
        java.security.cert.Certificate cert = null;
        while (aliases.hasMoreElements()) {
            String alias = aliases.nextElement();
            this.setPrivateKey((PrivateKey)keystore.getKey(alias, pin));
            java.security.cert.Certificate[] certChain = keystore.getCertificateChain(alias);
            if (certChain == null) continue;
            this.setCertificateChain(certChain);
            cert = keystore.getCertificate(alias);
            this.setCertificate(cert);
            if (!(cert instanceof X509Certificate)) break;
            ((X509Certificate)cert).checkValidity();
            break;
        }
        if (cert == null) {
            throw new IOException("Could not find certificate");
        }
    }

    public final void setPrivateKey(PrivateKey privateKey) {
        this.privateKey = privateKey;
    }

    public final void setCertificate(java.security.cert.Certificate certificate) {
        this.certificate = certificate;
    }

    public final void setCertificateChain(java.security.cert.Certificate[] certificateChain) {
        this.certificateChain = certificateChain;
    }

    public void setTsaClient(TSAClient tsaClient) {
        this.tsaClient = tsaClient;
    }

    public TSAClient getTsaClient() {
        return this.tsaClient;
    }

    private CMSSignedData signTimeStamps(CMSSignedData signedData) throws IOException, TSPException {
        SignerInformationStore signerStore = signedData.getSignerInfos();
        ArrayList<SignerInformation> newSigners = new ArrayList<SignerInformation>();
        for (SignerInformation signer : signerStore.getSigners()) {
            newSigners.add(this.signTimeStamp(signer));
        }
        return CMSSignedData.replaceSigners((CMSSignedData)signedData, (SignerInformationStore)new SignerInformationStore(newSigners));
    }

    private SignerInformation signTimeStamp(SignerInformation signer) throws IOException, TSPException {
        AttributeTable unsignedAttributes = signer.getUnsignedAttributes();
        ASN1EncodableVector vector = new ASN1EncodableVector();
        if (unsignedAttributes != null) {
            vector = unsignedAttributes.toASN1EncodableVector();
        }
        byte[] token = this.getTsaClient().getTimeStampToken(signer.getSignature());
        ASN1ObjectIdentifier oid = PKCSObjectIdentifiers.id_aa_signatureTimeStampToken;
        Attribute signatureTimeStamp = new Attribute(oid, (ASN1Set)new DERSet((ASN1Encodable)ASN1Primitive.fromByteArray((byte[])token)));
        vector.add((ASN1Encodable)signatureTimeStamp);
        Attributes signedAttributes = new Attributes(vector);
        SignerInformation newSigner = SignerInformation.replaceUnsignedAttributes((SignerInformation)signer, (AttributeTable)new AttributeTable(signedAttributes));
        if (newSigner == null) {
            return signer;
        }
        return newSigner;
    }

    public byte[] sign(InputStream content) throws IOException {
        try {
            ArrayList<java.security.cert.Certificate> certList = new ArrayList<java.security.cert.Certificate>();
            certList.addAll(Arrays.asList(this.certificateChain));
            certList.add(this.certificate);
            JcaCertStore certs = new JcaCertStore(certList);
            CMSSignedDataGenerator gen = new CMSSignedDataGenerator();
            Certificate cert = Certificate.getInstance((Object)ASN1Primitive.fromByteArray((byte[])this.certificate.getEncoded()));
            ContentSigner sha1Signer = new JcaContentSignerBuilder("SHA256WithRSA").build(this.privateKey);
            gen.addSignerInfoGenerator(new JcaSignerInfoGeneratorBuilder(new JcaDigestCalculatorProviderBuilder().build()).build(sha1Signer, new X509CertificateHolder(cert)));
            gen.addCertificates((Store)certs);
            CMSProcessableInputStream msg = new CMSProcessableInputStream(content);
            CMSSignedData signedData = gen.generate((CMSTypedData)msg, false);
            if (this.tsaClient != null) {
                signedData = this.signTimeStamps(signedData);
            }
            return signedData.getEncoded();
        }
        catch (GeneralSecurityException e) {
            throw new IOException(e);
        }
        catch (CMSException e) {
            throw new IOException(e);
        }
        catch (TSPException e) {
            throw new IOException(e);
        }
        catch (OperatorCreationException e) {
            throw new IOException(e);
        }
    }

    public void setExternalSigning(boolean externalSigning) {
        this.externalSigning = externalSigning;
    }

    public boolean isExternalSigning() {
        return this.externalSigning;
    }

    public int getMDPPermission(PDDocument doc) {
        COSDictionary signatureDict;
        COSDictionary permsDict;
        COSBase base = doc.getDocumentCatalog().getCOSObject().getDictionaryObject(COSName.PERMS);
        if (base instanceof COSDictionary && (base = (permsDict = (COSDictionary)base).getDictionaryObject(COSName.DOCMDP)) instanceof COSDictionary && (base = (signatureDict = (COSDictionary)base).getDictionaryObject("Reference")) instanceof COSArray) {
            COSArray refArray = (COSArray)base;
            for (int i = 0; i < refArray.size(); ++i) {
                COSDictionary sigRefDict;
                base = refArray.getObject(i);
                if (!(base instanceof COSDictionary) || !COSName.DOCMDP.equals((Object)(sigRefDict = (COSDictionary)base).getDictionaryObject("TransformMethod")) || !((base = sigRefDict.getDictionaryObject("TransformParams")) instanceof COSDictionary)) continue;
                COSDictionary transformDict = (COSDictionary)base;
                int accessPermissions = transformDict.getInt(COSName.P, 2);
                if (accessPermissions < 1 || accessPermissions > 3) {
                    accessPermissions = 2;
                }
                return accessPermissions;
            }
        }
        return 0;
    }

    public void setMDPPermission(PDDocument doc, PDSignature signature, int accessPermissions) {
        COSDictionary sigDict = signature.getCOSObject();
        COSDictionary transformParameters = new COSDictionary();
        transformParameters.setItem(COSName.TYPE, (COSBase)COSName.getPDFName((String)"TransformParams"));
        transformParameters.setInt(COSName.P, accessPermissions);
        transformParameters.setName(COSName.V, "1.2");
        transformParameters.setNeedToBeUpdated(true);
        COSDictionary referenceDict = new COSDictionary();
        referenceDict.setItem(COSName.TYPE, (COSBase)COSName.getPDFName((String)"SigRef"));
        referenceDict.setItem("TransformMethod", (COSBase)COSName.getPDFName((String)"DocMDP"));
        referenceDict.setItem("DigestMethod", (COSBase)COSName.getPDFName((String)"SHA1"));
        referenceDict.setItem("TransformParams", (COSBase)transformParameters);
        referenceDict.setNeedToBeUpdated(true);
        COSArray referenceArray = new COSArray();
        referenceArray.add((COSBase)referenceDict);
        sigDict.setItem("Reference", (COSBase)referenceArray);
        referenceArray.setNeedToBeUpdated(true);
        COSDictionary catalogDict = doc.getDocumentCatalog().getCOSObject();
        COSDictionary permsDict = new COSDictionary();
        catalogDict.setItem(COSName.PERMS, (COSBase)permsDict);
        permsDict.setItem(COSName.DOCMDP, (COSObjectable)signature);
        catalogDict.setNeedToBeUpdated(true);
        permsDict.setNeedToBeUpdated(true);
    }
}

