/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.examples.signature;

import java.io.IOException;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDType1Font;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationWidget;
import org.apache.pdfbox.pdmodel.interactive.form.PDAcroForm;
import org.apache.pdfbox.pdmodel.interactive.form.PDSignatureField;

public final class CreateEmptySignatureForm {
    private CreateEmptySignatureForm() {
    }

    public static void main(String[] args) throws IOException {
        PDDocument document = new PDDocument();
        PDPage page = new PDPage(PDRectangle.A4);
        document.addPage(page);
        PDType1Font font = PDType1Font.HELVETICA;
        PDResources resources = new PDResources();
        resources.put(COSName.getPDFName((String)"Helv"), (PDFont)font);
        PDAcroForm acroForm = new PDAcroForm(document);
        document.getDocumentCatalog().setAcroForm(acroForm);
        acroForm.setDefaultResources(resources);
        String defaultAppearanceString = "/Helv 0 Tf 0 g";
        acroForm.setDefaultAppearance(defaultAppearanceString);
        PDSignatureField signatureField = new PDSignatureField(acroForm);
        PDAnnotationWidget widget = (PDAnnotationWidget)signatureField.getWidgets().get(0);
        PDRectangle rect = new PDRectangle(50.0f, 650.0f, 200.0f, 50.0f);
        widget.setRectangle(rect);
        widget.setPage(page);
        page.getAnnotations().add(widget);
        acroForm.getFields().add(signatureField);
        document.save("target/EmptySignatureForm.pdf");
        document.close();
    }
}

