/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.examples.pdmodel;

import java.io.File;
import java.io.IOException;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.interactive.action.PDActionGoTo;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.destination.PDPageDestination;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.outline.PDDocumentOutline;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.outline.PDOutlineItem;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.outline.PDOutlineNode;

public class PrintBookmarks {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException {
        if (args.length != 1) {
            PrintBookmarks.usage();
        } else {
            PDDocument document = null;
            try {
                document = PDDocument.load((File)new File(args[0]));
                PrintBookmarks meta = new PrintBookmarks();
                PDDocumentOutline outline = document.getDocumentCatalog().getDocumentOutline();
                if (outline != null) {
                    meta.printBookmark(document, (PDOutlineNode)outline, "");
                } else {
                    System.out.println("This document does not contain any bookmarks");
                }
            }
            finally {
                if (document != null) {
                    document.close();
                }
            }
        }
    }

    private static void usage() {
        System.err.println("Usage: java " + PrintBookmarks.class.getName() + " <input-pdf>");
    }

    public void printBookmark(PDDocument document, PDOutlineNode bookmark, String indentation) throws IOException {
        for (PDOutlineItem current = bookmark.getFirstChild(); current != null; current = current.getNextSibling()) {
            PDActionGoTo gta;
            if (current.getDestination() instanceof PDPageDestination) {
                PDPageDestination pd = (PDPageDestination)current.getDestination();
                System.out.println(indentation + "Destination page: " + (pd.retrievePageNumber() + 1));
            }
            if (current.getAction() instanceof PDActionGoTo && (gta = (PDActionGoTo)current.getAction()).getDestination() instanceof PDPageDestination) {
                PDPageDestination pd = (PDPageDestination)gta.getDestination();
                System.out.println(indentation + "Destination page: " + (pd.retrievePageNumber() + 1));
            }
            System.out.println(indentation + current.getTitle());
            this.printBookmark(document, (PDOutlineNode)current, indentation + "    ");
        }
    }
}

