/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.examples.pdmodel;

import java.io.IOException;
import java.util.List;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDType1Font;
import org.apache.pdfbox.pdmodel.graphics.color.PDColor;
import org.apache.pdfbox.pdmodel.graphics.color.PDColorSpace;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceRGB;
import org.apache.pdfbox.pdmodel.interactive.action.PDAction;
import org.apache.pdfbox.pdmodel.interactive.action.PDActionGoTo;
import org.apache.pdfbox.pdmodel.interactive.action.PDActionURI;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationLine;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationLink;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationSquareCircle;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationTextMarkup;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDBorderStyleDictionary;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.destination.PDDestination;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.destination.PDPageFitWidthDestination;

public final class AddAnnotations {
    static final float INCH = 72.0f;

    private AddAnnotations() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException {
        if (args.length != 1) {
            System.err.println("Usage: " + AddAnnotations.class.getName() + " <output-pdf>");
            System.exit(1);
        }
        PDDocument document = new PDDocument();
        try {
            float[] quads;
            PDPage page1 = new PDPage();
            PDPage page2 = new PDPage();
            PDPage page3 = new PDPage();
            document.addPage(page1);
            document.addPage(page2);
            document.addPage(page3);
            List annotations = page1.getAnnotations();
            PDColor red = new PDColor(new float[]{1.0f, 0.0f, 0.0f}, (PDColorSpace)PDDeviceRGB.INSTANCE);
            PDColor blue = new PDColor(new float[]{0.0f, 0.0f, 1.0f}, (PDColorSpace)PDDeviceRGB.INSTANCE);
            PDColor black = new PDColor(new float[]{0.0f, 0.0f, 0.0f}, (PDColorSpace)PDDeviceRGB.INSTANCE);
            PDBorderStyleDictionary borderThick = new PDBorderStyleDictionary();
            borderThick.setWidth(6.0f);
            PDBorderStyleDictionary borderThin = new PDBorderStyleDictionary();
            borderThin.setWidth(1.0f);
            PDBorderStyleDictionary borderULine = new PDBorderStyleDictionary();
            borderULine.setStyle("U");
            borderULine.setWidth(1.0f);
            float pw = page1.getMediaBox().getUpperRightX();
            float ph = page1.getMediaBox().getUpperRightY();
            PDType1Font font = PDType1Font.HELVETICA_BOLD;
            PDPageContentStream contents = new PDPageContentStream(document, page1);
            contents.beginText();
            contents.setFont((PDFont)font, 18.0f);
            contents.newLineAtOffset(72.0f, ph - 72.0f - 18.0f);
            contents.showText("PDFBox");
            contents.newLineAtOffset(0.0f, -36.0f);
            contents.showText("External URL");
            contents.newLineAtOffset(0.0f, -36.0f);
            contents.showText("Jump to page three");
            contents.endText();
            contents.close();
            PDAnnotationTextMarkup txtMark = new PDAnnotationTextMarkup("Highlight");
            txtMark.setColor(blue);
            txtMark.setConstantOpacity(0.2f);
            float textWidth = font.getStringWidth("PDFBox") / 1000.0f * 18.0f;
            PDRectangle position = new PDRectangle();
            position.setLowerLeftX(72.0f);
            position.setLowerLeftY(ph - 72.0f - 18.0f);
            position.setUpperRightX(72.0f + textWidth);
            position.setUpperRightY(ph - 72.0f);
            txtMark.setRectangle(position);
            quads = new float[]{position.getLowerLeftX(), position.getUpperRightY() - 2.0f, position.getUpperRightX(), quads[1], quads[0], position.getLowerLeftY() - 2.0f, quads[2], quads[5]};
            txtMark.setQuadPoints(quads);
            txtMark.setContents("Highlighted since it's important");
            annotations.add(txtMark);
            PDAnnotationLink txtLink = new PDAnnotationLink();
            txtLink.setBorderStyle(borderULine);
            textWidth = font.getStringWidth("External URL") / 1000.0f * 18.0f;
            position = new PDRectangle();
            position.setLowerLeftX(72.0f);
            position.setLowerLeftY(ph - 108.0f - 20.0f);
            position.setUpperRightX(72.0f + textWidth);
            position.setUpperRightY(ph - 108.0f);
            txtLink.setRectangle(position);
            PDActionURI action = new PDActionURI();
            action.setURI("http://pdfbox.apache.org");
            txtLink.setAction((PDAction)action);
            annotations.add(txtLink);
            PDAnnotationSquareCircle aCircle = new PDAnnotationSquareCircle("Circle");
            aCircle.setContents("Circle Annotation");
            aCircle.setInteriorColor(red);
            aCircle.setColor(blue);
            aCircle.setBorderStyle(borderThin);
            position = new PDRectangle();
            position.setLowerLeftX(72.0f);
            position.setLowerLeftY(ph - 216.0f - 72.0f);
            position.setUpperRightX(144.0f);
            position.setUpperRightY(ph - 216.0f);
            aCircle.setRectangle(position);
            annotations.add(aCircle);
            PDAnnotationSquareCircle aSquare = new PDAnnotationSquareCircle("Square");
            aSquare.setContents("Square Annotation");
            aSquare.setColor(red);
            aSquare.setBorderStyle(borderThick);
            position = new PDRectangle();
            position.setLowerLeftX(pw - 144.0f);
            position.setLowerLeftY(ph - 252.0f - 72.0f);
            position.setUpperRightX(pw - 72.0f);
            position.setUpperRightY(ph - 252.0f);
            aSquare.setRectangle(position);
            annotations.add(aSquare);
            PDAnnotationLine aLine = new PDAnnotationLine();
            aLine.setEndPointEndingStyle("OpenArrow");
            aLine.setContents("Circle->Square");
            aLine.setCaption(true);
            position = new PDRectangle();
            position.setLowerLeftX(144.0f);
            position.setLowerLeftY(ph - 252.0f - 72.0f);
            position.setUpperRightX(pw - 72.0f - 72.0f);
            position.setUpperRightY(ph - 216.0f);
            aLine.setRectangle(position);
            float[] linepos = new float[]{144.0f, ph - 252.0f, pw - 144.0f, ph - 288.0f};
            aLine.setLine(linepos);
            aLine.setBorderStyle(borderThick);
            aLine.setColor(black);
            annotations.add(aLine);
            PDAnnotationLink pageLink = new PDAnnotationLink();
            pageLink.setBorderStyle(borderULine);
            textWidth = font.getStringWidth("Jump to page three") / 1000.0f * 18.0f;
            position = new PDRectangle();
            position.setLowerLeftX(72.0f);
            position.setLowerLeftY(ph - 144.0f - 20.0f);
            position.setUpperRightX(72.0f + textWidth);
            position.setUpperRightY(ph - 144.0f);
            pageLink.setRectangle(position);
            PDActionGoTo actionGoto = new PDActionGoTo();
            PDPageFitWidthDestination dest = new PDPageFitWidthDestination();
            dest.setPage(page3);
            actionGoto.setDestination((PDDestination)dest);
            pageLink.setAction((PDAction)actionGoto);
            annotations.add(pageLink);
            AddAnnotations.showPageNo(document, page1, "Page 1");
            AddAnnotations.showPageNo(document, page2, "Page 2");
            AddAnnotations.showPageNo(document, page3, "Page 3");
            document.save(args[0]);
        }
        finally {
            document.close();
        }
    }

    private static void showPageNo(PDDocument document, PDPage page, String pageText) throws IOException {
        int fontSize = 10;
        PDPageContentStream contents = new PDPageContentStream(document, page, PDPageContentStream.AppendMode.PREPEND, true);
        float pageWidth = page.getMediaBox().getWidth();
        float pageHeight = page.getMediaBox().getHeight();
        PDType1Font font = PDType1Font.HELVETICA;
        contents.setFont((PDFont)font, (float)fontSize);
        float textWidth = font.getStringWidth(pageText) / 1000.0f * (float)fontSize;
        contents.beginText();
        contents.newLineAtOffset(pageWidth / 2.0f - textWidth / 2.0f, pageHeight - 36.0f);
        contents.showText(pageText);
        contents.endText();
        contents.close();
    }
}

