/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.examples.pdmodel;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.pdfbox.exceptions.COSVisitorException;
import org.apache.pdfbox.io.RandomAccess;
import org.apache.pdfbox.io.RandomAccessFile;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.edit.PDPageContentStream;
import org.apache.pdfbox.pdmodel.graphics.xobject.PDCcitt;
import org.apache.pdfbox.pdmodel.graphics.xobject.PDJpeg;
import org.apache.pdfbox.pdmodel.graphics.xobject.PDXObjectImage;

public class ImageToPDF {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createPDFFromImage(String file, String image) throws IOException, COSVisitorException {
        PDDocument doc = null;
        try {
            doc = new PDDocument();
            PDPage page = new PDPage();
            doc.addPage(page);
            PDJpeg ximage = null;
            if (image.toLowerCase().endsWith(".jpg")) {
                ximage = new PDJpeg(doc, (InputStream)new FileInputStream(image));
            } else if (image.toLowerCase().endsWith(".tif") || image.toLowerCase().endsWith(".tiff")) {
                ximage = new PDCcitt(doc, (RandomAccess)new RandomAccessFile(new File(image), "r"));
            } else {
                throw new IOException("Image type not supported:" + image);
            }
            PDPageContentStream contentStream = new PDPageContentStream(doc, page);
            contentStream.drawImage((PDXObjectImage)ximage, 20.0f, 20.0f);
            contentStream.close();
            doc.save(file);
        }
        finally {
            if (doc != null) {
                doc.close();
            }
        }
    }

    public static void main(String[] args) {
        ImageToPDF app = new ImageToPDF();
        try {
            if (args.length != 2) {
                app.usage();
            } else {
                app.createPDFFromImage(args[0], args[1]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void usage() {
        System.err.println("usage: " + this.getClass().getName() + " <output-file> <image>");
    }
}

