/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.examples.fdf;

import java.io.IOException;
import org.apache.pdfbox.examples.AbstractExample;
import org.apache.pdfbox.exceptions.COSVisitorException;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentCatalog;
import org.apache.pdfbox.pdmodel.interactive.form.PDAcroForm;
import org.apache.pdfbox.pdmodel.interactive.form.PDField;

public class SetField
extends AbstractExample {
    public void setField(PDDocument pdfDocument, String name, String value) throws IOException {
        PDDocumentCatalog docCatalog = pdfDocument.getDocumentCatalog();
        PDAcroForm acroForm = docCatalog.getAcroForm();
        PDField field = acroForm.getField(name);
        if (field != null) {
            field.setValue(value);
        } else {
            System.err.println("No field found with name:" + name);
        }
    }

    public static void main(String[] args) throws IOException, COSVisitorException {
        SetField setter = new SetField();
        setter.setField(args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setField(String[] args) throws IOException, COSVisitorException {
        PDDocument pdf = null;
        try {
            if (args.length != 3) {
                SetField.usage();
            } else {
                SetField example = new SetField();
                pdf = PDDocument.load((String)args[0]);
                example.setField(pdf, args[1], args[2]);
                pdf.save(args[0]);
            }
        }
        finally {
            if (pdf != null) {
                pdf.close();
            }
        }
    }

    private static void usage() {
        System.err.println("usage: org.apache.pdfbox.examples.fdf.SetField <pdf-file> <field-name> <field-value>");
    }
}

