/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.debugger.ui;

import java.awt.Desktop;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.StringJoiner;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.tree.TreePath;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSInputStream;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.debugger.PDFDebugger;
import org.apache.pdfbox.debugger.treestatus.TreeStatus;
import org.apache.pdfbox.debugger.ui.ArrayEntry;
import org.apache.pdfbox.debugger.ui.FileOpenSaveDialog;
import org.apache.pdfbox.debugger.ui.MapEntry;
import org.apache.pdfbox.debugger.ui.XrefEntry;
import org.apache.pdfbox.io.IOUtils;
import org.apache.pdfbox.pdmodel.common.PDStream;

public class Tree
extends JTree {
    private final JPopupMenu treePopupMenu = new JPopupMenu();
    private final Object rootNode;

    public Tree() {
        this.setComponentPopupMenu(this.treePopupMenu);
        this.rootNode = this.getModel().getRoot();
        int treeRowHeight = Integer.parseInt(PDFDebugger.configuration.getProperty("treeRowHeight", Integer.toString(this.getRowHeight())));
        this.setRowHeight(treeRowHeight);
    }

    @Override
    public Point getPopupLocation(MouseEvent event) {
        if (event != null) {
            TreePath path = this.getClosestPathForLocation(event.getX(), event.getY());
            if (path == null) {
                return null;
            }
            this.setSelectionPath(path);
            this.treePopupMenu.removeAll();
            this.addPopupMenuItems(path);
            return event.getPoint();
        }
        return null;
    }

    private void addPopupMenuItems(TreePath nodePath) {
        JMenuItem open;
        Object obj = nodePath.getLastPathComponent();
        this.treePopupMenu.add(this.getTreePathMenuItem(nodePath));
        if (obj instanceof MapEntry) {
            obj = ((MapEntry)obj).getValue();
        } else if (obj instanceof ArrayEntry) {
            obj = ((ArrayEntry)obj).getValue();
        } else if (obj instanceof XrefEntry) {
            obj = ((XrefEntry)obj).getObject();
        }
        if (!(obj instanceof COSStream)) {
            return;
        }
        this.treePopupMenu.addSeparator();
        COSStream stream = (COSStream)obj;
        this.treePopupMenu.add(this.getStreamSaveMenu(stream, nodePath));
        List filters = new PDStream(stream).getFilters();
        if (!filters.isEmpty()) {
            if (filters.size() >= 2) {
                this.getPartiallyDecodedStreamSaveMenu(stream).forEach(this.treePopupMenu::add);
            }
            this.treePopupMenu.add(this.getRawStreamSaveMenu(stream));
        }
        if ((open = this.getFileOpenMenu(stream, nodePath)) != null) {
            this.treePopupMenu.addSeparator();
            this.treePopupMenu.add(open);
        }
    }

    private JMenuItem getTreePathMenuItem(TreePath path) {
        JMenuItem copyPathMenuItem = new JMenuItem("Copy Tree Path");
        copyPathMenuItem.addActionListener(actionEvent -> {
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            clipboard.setContents(new StringSelection(new TreeStatus(this.rootNode).getStringForPath(path)), null);
        });
        return copyPathMenuItem;
    }

    private JMenuItem getRawStreamSaveMenu(COSStream cosStream) {
        JMenuItem saveMenuItem = new JMenuItem("Save Raw Stream (" + this.getFilters(cosStream) + ") As...");
        saveMenuItem.addActionListener(actionEvent -> {
            try {
                byte[] bytes = IOUtils.toByteArray((InputStream)cosStream.createRawInputStream());
                this.saveStream(bytes, null, null);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
        return saveMenuItem;
    }

    private String getFilters(COSStream cosStream) {
        StringJoiner sj = new StringJoiner(", ");
        COSBase filters = cosStream.getFilters();
        if (filters instanceof COSName) {
            sj.add(((COSName)filters).getName());
        } else if (filters instanceof COSArray) {
            COSArray filterArray = (COSArray)filters;
            for (COSBase name : filterArray) {
                sj.add(((COSName)name).getName());
            }
        }
        return sj.toString();
    }

    private JMenuItem getStreamSaveMenu(COSStream cosStream, TreePath nodePath) {
        String format;
        FileNameExtensionFilter fileFilter;
        String extension = this.getFileExtensionForStream(cosStream, nodePath);
        if (extension != null) {
            switch (extension) {
                case "pdb": {
                    fileFilter = new FileNameExtensionFilter("Type 1 Font (*.pfb)", "pfb");
                    break;
                }
                case "ttf": {
                    fileFilter = new FileNameExtensionFilter("TrueType Font (*.ttf)", "ttf");
                    break;
                }
                case "cff": {
                    fileFilter = new FileNameExtensionFilter("Compact Font Format (*.cff)", "cff");
                    break;
                }
                case "otf": {
                    fileFilter = new FileNameExtensionFilter("OpenType Font (*.otf)", "otf");
                    break;
                }
                default: {
                    fileFilter = null;
                }
            }
            format = " " + extension.toUpperCase();
        } else {
            fileFilter = null;
            format = "";
        }
        JMenuItem saveMenuItem = new JMenuItem("Save Stream As" + format + "...");
        saveMenuItem.addActionListener(actionEvent -> {
            try {
                byte[] bytes = IOUtils.toByteArray((InputStream)cosStream.createInputStream());
                this.saveStream(bytes, fileFilter, extension);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
        return saveMenuItem;
    }

    private String getFileExtensionForStream(COSStream cosStream, TreePath nodePath) {
        String name;
        switch (name = nodePath.getLastPathComponent().toString()) {
            case "FontFile": {
                return "pfb";
            }
            case "FontFile2": {
                return "ttf";
            }
            case "FontFile3": {
                return cosStream.getCOSName(COSName.SUBTYPE) == COSName.OPEN_TYPE ? "otf" : "cff";
            }
        }
        return null;
    }

    private JMenuItem getFileOpenMenu(COSStream cosStream, TreePath nodePath) {
        String extension = this.getFileExtensionForStream(cosStream, nodePath);
        if (extension == null) {
            return null;
        }
        JMenuItem openMenuItem = new JMenuItem("Open with Default Application");
        openMenuItem.addActionListener(actionEvent -> {
            try {
                File temp = File.createTempFile("pdfbox", "." + extension);
                temp.deleteOnExit();
                try (COSInputStream is = cosStream.createInputStream();
                     FileOutputStream os = new FileOutputStream(temp);){
                    IOUtils.copy((InputStream)is, (OutputStream)os);
                }
                Desktop.getDesktop().open(temp);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
        return openMenuItem;
    }

    private List<JMenuItem> getPartiallyDecodedStreamSaveMenu(COSStream cosStream) {
        ArrayList<JMenuItem> menuItems = new ArrayList<JMenuItem>();
        PDStream stream = new PDStream(cosStream);
        List filters = stream.getFilters();
        for (int i = filters.size() - 1; i >= 1; --i) {
            menuItems.add(this.getPartialStreamSavingMenuItem(i, stream));
        }
        return menuItems;
    }

    private JMenuItem getPartialStreamSavingMenuItem(int indexOfStopFilter, PDStream stream) {
        List filters = stream.getFilters();
        ArrayList<String> stopFilters = new ArrayList<String>(1);
        stopFilters.add(((COSName)filters.get(indexOfStopFilter)).getName());
        StringBuilder nameListBuilder = new StringBuilder();
        for (int i = indexOfStopFilter; i < filters.size(); ++i) {
            nameListBuilder.append(((COSName)filters.get(i)).getName()).append(" & ");
        }
        nameListBuilder.delete(nameListBuilder.lastIndexOf("&"), nameListBuilder.length());
        JMenuItem menuItem = new JMenuItem("Keep " + nameListBuilder.toString() + "...");
        menuItem.addActionListener(actionEvent -> {
            try {
                InputStream data = stream.createInputStream(stopFilters);
                this.saveStream(IOUtils.toByteArray((InputStream)data), null, null);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
        return menuItem;
    }

    private void saveStream(byte[] bytes, FileFilter filter, String extension) throws IOException {
        FileOpenSaveDialog saveDialog = new FileOpenSaveDialog(this.getParent(), filter);
        saveDialog.saveFile(bytes, extension);
    }
}

