/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.intercept;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.Interceptor;
import javax.interceptor.AroundInvoke;
import org.apache.webbeans.annotation.AnnotationManager;
import org.apache.webbeans.component.AbstractInjectionTargetBean;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.config.inheritance.IBeanInheritedMetaData;
import org.apache.webbeans.exception.WebBeansConfigurationException;
import org.apache.webbeans.intercept.InterceptorData;
import org.apache.webbeans.intercept.InterceptorDataComparator;
import org.apache.webbeans.intercept.webbeans.WebBeansInterceptor;
import org.apache.webbeans.logger.WebBeansLogger;
import org.apache.webbeans.plugins.OpenWebBeansEjbLCAPlugin;
import org.apache.webbeans.spi.BDABeansXmlScanner;
import org.apache.webbeans.spi.ScannerService;
import org.apache.webbeans.util.AnnotationUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WebBeansInterceptorConfig {
    private static WebBeansLogger logger = WebBeansLogger.getLogger(WebBeansInterceptorConfig.class);
    private WebBeansContext webBeansContext;

    public WebBeansInterceptorConfig(WebBeansContext webBeansContext) {
        this.webBeansContext = webBeansContext;
    }

    public <T> void configureInterceptorClass(AbstractInjectionTargetBean<T> delegate, Annotation[] interceptorBindingTypes) {
        if (delegate.getScope() != Dependent.class && logger.wblWillLogWarn()) {
            logger.warn("WARN_0005_1", delegate.getBeanClass().getName());
        }
        if (delegate.getName() != null && logger.wblWillLogWarn()) {
            logger.warn("WARN_0005_2", delegate.getBeanClass().getName());
        }
        if (delegate.isAlternative() && logger.wblWillLogWarn()) {
            logger.warn("WARN_0005_3", delegate.getBeanClass().getName());
        }
        if (logger.wblWillLogDebug()) {
            logger.debug("Configuring interceptor class : [{0}]", delegate.getReturnType());
        }
        WebBeansInterceptor<T> interceptor = new WebBeansInterceptor<T>(delegate);
        List<Annotation> anns = Arrays.asList(interceptorBindingTypes);
        for (Annotation ann : interceptorBindingTypes) {
            this.checkAnns(anns, ann, delegate);
            interceptor.addInterceptorBinding(ann.annotationType(), ann);
        }
        delegate.getWebBeansContext().getBeanManagerImpl().addInterceptor(interceptor);
    }

    private void checkAnns(List<Annotation> list, Annotation ann, Bean<?> bean) {
        for (Annotation old : list) {
            if (!old.annotationType().equals(ann.annotationType()) || AnnotationUtil.isQualifierEqual(ann, old)) continue;
            throw new WebBeansConfigurationException("Interceptor Binding types must be equal for interceptor : " + bean);
        }
    }

    public void configure(AbstractInjectionTargetBean<?> component, List<InterceptorData> stack) {
        Annotation[] stereoTypes;
        Annotation[] anns;
        Class clazz = component.getReturnType();
        AnnotatedType<?> annotatedType = component.getAnnotatedType();
        Set annotations = null;
        if (annotatedType != null) {
            annotations = annotatedType.getAnnotations();
        }
        Set<Interceptor<?>> componentInterceptors = null;
        HashSet<Annotation> bindingTypeSet = new HashSet<Annotation>();
        Annotation[] typeAnns = null;
        typeAnns = annotations != null ? annotations.toArray(new Annotation[annotations.size()]) : clazz.getDeclaredAnnotations();
        AnnotationManager annotationManager = component.getWebBeansContext().getAnnotationManager();
        if (annotationManager.hasInterceptorBindingMetaAnnotation(typeAnns)) {
            for (Annotation ann : anns = annotationManager.getInterceptorBindingMetaAnnotations(typeAnns)) {
                bindingTypeSet.add(ann);
            }
        }
        for (Annotation stero : stereoTypes = annotationManager.getStereotypeMetaAnnotations(typeAnns)) {
            Annotation[] steroInterceptorBindings;
            if (!annotationManager.hasInterceptorBindingMetaAnnotation(stero.annotationType().getDeclaredAnnotations())) continue;
            for (Annotation ann : steroInterceptorBindings = annotationManager.getInterceptorBindingMetaAnnotations(stero.annotationType().getDeclaredAnnotations())) {
                bindingTypeSet.add(ann);
            }
        }
        IBeanInheritedMetaData metadata = component.getInheritedMetaData();
        if (metadata != null) {
            Set<Annotation> inheritedStereotypes;
            Set<Annotation> inheritedBindingTypes = metadata.getInheritedInterceptorBindings();
            if (!inheritedBindingTypes.isEmpty()) {
                Annotation[] inheritedAnns = new Annotation[inheritedBindingTypes.size()];
                inheritedAnns = inheritedBindingTypes.toArray(inheritedAnns);
                anns = annotationManager.getInterceptorBindingMetaAnnotations(inheritedAnns);
                bindingTypeSet.addAll(Arrays.asList(anns));
            }
            if (!(inheritedStereotypes = metadata.getInheritedStereoTypes()).isEmpty()) {
                Annotation[] inherited = new Annotation[inheritedStereotypes.size()];
                inherited = inheritedStereotypes.toArray(inherited);
                Annotation[] transitiveStereotypes = annotationManager.getStereotypeMetaAnnotations(inherited);
                for (Annotation stereo : transitiveStereotypes) {
                    Annotation[] steroInterceptorBindings;
                    if (!annotationManager.hasInterceptorBindingMetaAnnotation(stereo.annotationType().getDeclaredAnnotations())) continue;
                    for (Annotation ann : steroInterceptorBindings = annotationManager.getInterceptorBindingMetaAnnotations(stereo.annotationType().getDeclaredAnnotations())) {
                        bindingTypeSet.add(ann);
                    }
                }
            }
        }
        anns = new Annotation[bindingTypeSet.size()];
        anns = bindingTypeSet.toArray(anns);
        List<Annotation> beanAnnots = Arrays.asList(anns);
        for (Annotation checkAnn : anns) {
            this.checkAnns(beanAnnots, checkAnn, component);
        }
        if (anns.length > 0) {
            componentInterceptors = this.findDeployedWebBeansInterceptor(anns, component.getWebBeansContext());
            this.addComponentInterceptors(componentInterceptors, stack);
        }
        if (annotatedType == null) {
            this.addMethodInterceptors(component, clazz, stack, componentInterceptors, bindingTypeSet);
        } else {
            this.addMethodInterceptors(annotatedType, stack, componentInterceptors);
        }
        this.filterInterceptorsPerBDA(component, stack);
        Collections.sort(stack, new InterceptorDataComparator(component.getWebBeansContext()));
    }

    private void filterInterceptorsPerBDA(AbstractInjectionTargetBean<?> component, List<InterceptorData> stack) {
        ScannerService scannerService = component.getWebBeansContext().getScannerService();
        if (!scannerService.isBDABeansXmlScanningEnabled()) {
            return;
        }
        BDABeansXmlScanner beansXMLScanner = scannerService.getBDABeansXmlScanner();
        String beanBDABeansXML = beansXMLScanner.getBeansXml(component.getBeanClass());
        Set definedInterceptors = beansXMLScanner.getInterceptors(beanBDABeansXML);
        if (stack != null && stack.size() > 0) {
            Iterator<InterceptorData> it = stack.iterator();
            while (it.hasNext()) {
                InterceptorData interceptorData = it.next();
                if (definedInterceptors.contains(interceptorData.getInterceptorClass())) continue;
                it.remove();
            }
        }
    }

    public void addComponentInterceptors(Set<Interceptor<?>> set, List<InterceptorData> stack) {
        for (WebBeansInterceptor webBeansInterceptor : set) {
            AnnotatedType annotatedType = webBeansInterceptor.getAnnotatedType();
            OpenWebBeansEjbLCAPlugin ejbPlugin = this.webBeansContext.getPluginLoader().getEjbLCAPlugin();
            Class<? extends Annotation> prePassivateClass = null;
            Class<? extends Annotation> postActivateClass = null;
            if (null != ejbPlugin) {
                prePassivateClass = ejbPlugin.getPrePassivateClass();
                postActivateClass = ejbPlugin.getPostActivateClass();
            }
            if (annotatedType != null) {
                this.webBeansContext.getWebBeansUtil().configureInterceptorMethods(webBeansInterceptor, annotatedType, AroundInvoke.class, true, false, stack, null);
                this.webBeansContext.getWebBeansUtil().configureInterceptorMethods(webBeansInterceptor, annotatedType, PostConstruct.class, true, false, stack, null);
                this.webBeansContext.getWebBeansUtil().configureInterceptorMethods(webBeansInterceptor, annotatedType, PreDestroy.class, true, false, stack, null);
                if (null == ejbPlugin) continue;
                this.webBeansContext.getWebBeansUtil().configureInterceptorMethods(webBeansInterceptor, annotatedType, prePassivateClass, true, false, stack, null);
                this.webBeansContext.getWebBeansUtil().configureInterceptorMethods(webBeansInterceptor, annotatedType, postActivateClass, true, false, stack, null);
                continue;
            }
            this.webBeansContext.getWebBeansUtil().configureInterceptorMethods(webBeansInterceptor, webBeansInterceptor.getClazz(), AroundInvoke.class, true, false, stack, null, true);
            this.webBeansContext.getWebBeansUtil().configureInterceptorMethods(webBeansInterceptor, webBeansInterceptor.getClazz(), PostConstruct.class, true, false, stack, null, true);
            this.webBeansContext.getWebBeansUtil().configureInterceptorMethods(webBeansInterceptor, webBeansInterceptor.getClazz(), PreDestroy.class, true, false, stack, null, true);
            if (null == ejbPlugin) continue;
            this.webBeansContext.getWebBeansUtil().configureInterceptorMethods(webBeansInterceptor, webBeansInterceptor.getClazz(), prePassivateClass, true, false, stack, null, true);
            this.webBeansContext.getWebBeansUtil().configureInterceptorMethods(webBeansInterceptor, webBeansInterceptor.getClazz(), postActivateClass, true, false, stack, null, true);
        }
    }

    /*
     * Could not resolve type clashes
     */
    private void addMethodInterceptors(AbstractInjectionTargetBean<?> component, Class<?> clazz, List<InterceptorData> stack, Set<Interceptor<?>> componentInterceptors, Set<Annotation> resolvedComponentInterceptorBindings) {
        AnnotationManager annotationManager = this.webBeansContext.getAnnotationManager();
        Method[] methods = clazz.getMethods();
        HashSet<Method> set = new HashSet<Method>();
        for (Method m : methods) {
            set.add(m);
        }
        for (Method m : methods = this.webBeansContext.getSecurityService().doPrivilegedGetDeclaredMethods(clazz)) {
            set.add(m);
        }
        for (Method method : methods = set.toArray(new Method[set.size()])) {
            HashSet<Annotation> interceptorAnns = new HashSet<Annotation>();
            if (annotationManager.hasInterceptorBindingMetaAnnotation(method.getDeclaredAnnotations())) {
                Annotation[] anns;
                for (Annotation ann : anns = annotationManager.getInterceptorBindingMetaAnnotations(method.getAnnotations())) {
                    interceptorAnns.add(ann);
                }
            }
            interceptorAnns.addAll(resolvedComponentInterceptorBindings);
            if (interceptorAnns.isEmpty()) continue;
            Annotation[] result = new Annotation[interceptorAnns.size()];
            result = interceptorAnns.toArray(result);
            Set<Interceptor<Interceptor<?>>> setInterceptors = this.findDeployedWebBeansInterceptor(result, this.webBeansContext);
            if (componentInterceptors != null) {
                setInterceptors.removeAll(componentInterceptors);
            }
            for (WebBeansInterceptor interceptor : setInterceptors) {
                this.webBeansContext.getWebBeansUtil().configureInterceptorMethods(interceptor, interceptor.getClazz(), AroundInvoke.class, true, true, stack, method, true);
                this.webBeansContext.getWebBeansUtil().configureInterceptorMethods(interceptor, interceptor.getClazz(), PostConstruct.class, true, true, stack, method, true);
                this.webBeansContext.getWebBeansUtil().configureInterceptorMethods(interceptor, interceptor.getClazz(), PreDestroy.class, true, true, stack, method, true);
                OpenWebBeansEjbLCAPlugin ejbPlugin = this.webBeansContext.getPluginLoader().getEjbLCAPlugin();
                if (null == ejbPlugin) continue;
                this.webBeansContext.getWebBeansUtil().configureInterceptorMethods(interceptor, interceptor.getClazz(), ejbPlugin.getPrePassivateClass(), true, true, stack, method, true);
                this.webBeansContext.getWebBeansUtil().configureInterceptorMethods(interceptor, interceptor.getClazz(), ejbPlugin.getPostActivateClass(), true, true, stack, method, true);
            }
        }
    }

    /*
     * Could not resolve type clashes
     */
    private <T> void addMethodInterceptors(AnnotatedType<T> annotatedType, List<InterceptorData> stack, Set<Interceptor<?>> componentInterceptors) {
        AnnotationManager annotationManager = this.webBeansContext.getAnnotationManager();
        Set methods = annotatedType.getMethods();
        Iterator i$ = methods.iterator();
        while (i$.hasNext()) {
            Annotation[] stereoTypes;
            AnnotatedMethod methodA;
            AnnotatedMethod methodB = methodA = (AnnotatedMethod)i$.next();
            Method method = methodB.getJavaMember();
            HashSet<Annotation> interceptorAnns = new HashSet<Annotation>();
            Annotation[] methodAnns = AnnotationUtil.getAnnotationsFromSet(methodB.getAnnotations());
            if (annotationManager.hasInterceptorBindingMetaAnnotation(methodAnns)) {
                Annotation[] anns = annotationManager.getInterceptorBindingMetaAnnotations(methodAnns);
                Annotation[] annsClazz = annotationManager.getInterceptorBindingMetaAnnotations(AnnotationUtil.getAnnotationsFromSet(annotatedType.getAnnotations()));
                for (Annotation ann : anns) {
                    interceptorAnns.add(ann);
                }
                for (Annotation ann : annsClazz) {
                    interceptorAnns.add(ann);
                }
            }
            for (Annotation stero : stereoTypes = annotationManager.getStereotypeMetaAnnotations(AnnotationUtil.getAnnotationsFromSet(annotatedType.getAnnotations()))) {
                Annotation[] steroInterceptorBindings;
                if (!annotationManager.hasInterceptorBindingMetaAnnotation(stero.annotationType().getDeclaredAnnotations())) continue;
                for (Annotation ann : steroInterceptorBindings = annotationManager.getInterceptorBindingMetaAnnotations(stero.annotationType().getDeclaredAnnotations())) {
                    interceptorAnns.add(ann);
                }
            }
            if (interceptorAnns.isEmpty()) continue;
            Annotation[] result = new Annotation[interceptorAnns.size()];
            result = interceptorAnns.toArray(result);
            Set<Interceptor<Interceptor<?>>> setInterceptors = this.findDeployedWebBeansInterceptor(result, this.webBeansContext);
            if (componentInterceptors != null) {
                setInterceptors.removeAll(componentInterceptors);
            }
            for (WebBeansInterceptor interceptor : setInterceptors) {
                AnnotatedType interAnnoType = interceptor.getAnnotatedType();
                if (interAnnoType == null) {
                    this.webBeansContext.getWebBeansUtil().configureInterceptorMethods(interceptor, interceptor.getClazz(), AroundInvoke.class, true, true, stack, method, true);
                    this.webBeansContext.getWebBeansUtil().configureInterceptorMethods(interceptor, interceptor.getClazz(), PostConstruct.class, true, true, stack, method, true);
                    this.webBeansContext.getWebBeansUtil().configureInterceptorMethods(interceptor, interceptor.getClazz(), PreDestroy.class, true, true, stack, method, true);
                    continue;
                }
                this.webBeansContext.getWebBeansUtil().configureInterceptorMethods(interceptor, interAnnoType, AroundInvoke.class, true, true, stack, method);
                this.webBeansContext.getWebBeansUtil().configureInterceptorMethods(interceptor, interAnnoType, PostConstruct.class, true, true, stack, method);
                this.webBeansContext.getWebBeansUtil().configureInterceptorMethods(interceptor, interAnnoType, PreDestroy.class, true, true, stack, method);
            }
        }
    }

    public Set<Interceptor<?>> findDeployedWebBeansInterceptor(Annotation[] anns, WebBeansContext webBeansContext) {
        HashSet set = new HashSet();
        Iterator<Interceptor<?>> it = webBeansContext.getBeanManagerImpl().getInterceptors().iterator();
        ArrayList<Class<? extends Annotation>> bindingTypes = new ArrayList<Class<? extends Annotation>>();
        ArrayList<Annotation> listAnnot = new ArrayList<Annotation>();
        for (Annotation ann : anns) {
            bindingTypes.add(ann.annotationType());
            listAnnot.add(ann);
        }
        while (it.hasNext()) {
            WebBeansInterceptor interceptor = (WebBeansInterceptor)it.next();
            if (!interceptor.hasBinding(bindingTypes, listAnnot)) continue;
            set.add(interceptor);
            set.addAll(interceptor.getMetaInceptors());
        }
        return set;
    }
}

