/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Expression;
import org.hsqldb.ExpressionLogical;
import org.hsqldb.ParserDQL;
import org.hsqldb.RangeVariable;
import org.hsqldb.Session;
import org.hsqldb.error.Error;
import org.hsqldb.index.Index;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.IntKeyIntValueHashMap;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.MultiValueHashMap;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.lib.OrderedIntHashSet;

public class RangeVariableResolver {
    Session session;
    RangeVariable[] rangeVariables;
    Expression conditions;
    OrderedHashSet rangeVarSet = new OrderedHashSet();
    ParserDQL.CompileContext compileContext;
    HsqlArrayList[] tempJoinExpressions;
    HsqlArrayList[] joinExpressions;
    HsqlArrayList[] whereExpressions;
    HsqlArrayList queryExpressions = new HsqlArrayList();
    Expression[] inExpressions;
    boolean[] inInJoin;
    int inExpressionCount = 0;
    boolean hasOuterJoin = false;
    int firstLeftJoinIndex;
    int firstRightJoinIndex;
    OrderedIntHashSet colIndexSetEqual = new OrderedIntHashSet();
    IntKeyIntValueHashMap colIndexSetOther = new IntKeyIntValueHashMap();
    OrderedHashSet tempSet = new OrderedHashSet();
    MultiValueHashMap tempMap = new MultiValueHashMap();

    RangeVariableResolver(RangeVariable[] rangeVariableArray, Expression expression, ParserDQL.CompileContext compileContext) {
        int n;
        this.rangeVariables = rangeVariableArray;
        this.conditions = expression;
        this.compileContext = compileContext;
        this.firstLeftJoinIndex = rangeVariableArray.length;
        this.firstRightJoinIndex = rangeVariableArray.length;
        for (n = 0; n < rangeVariableArray.length; ++n) {
            RangeVariable rangeVariable = rangeVariableArray[n];
            if (rangeVariable.isLeftJoin) {
                if (this.firstLeftJoinIndex == rangeVariableArray.length) {
                    this.firstLeftJoinIndex = n;
                }
                this.hasOuterJoin = true;
            }
            if (!rangeVariable.isRightJoin) continue;
            if (this.firstRightJoinIndex == rangeVariableArray.length) {
                this.firstRightJoinIndex = n;
            }
            this.hasOuterJoin = true;
        }
        this.inExpressions = new Expression[rangeVariableArray.length];
        this.inInJoin = new boolean[rangeVariableArray.length];
        this.tempJoinExpressions = new HsqlArrayList[rangeVariableArray.length];
        for (n = 0; n < rangeVariableArray.length; ++n) {
            this.tempJoinExpressions[n] = new HsqlArrayList();
        }
        this.joinExpressions = new HsqlArrayList[rangeVariableArray.length];
        for (n = 0; n < rangeVariableArray.length; ++n) {
            this.joinExpressions[n] = new HsqlArrayList();
        }
        this.whereExpressions = new HsqlArrayList[rangeVariableArray.length];
        for (n = 0; n < rangeVariableArray.length; ++n) {
            this.whereExpressions[n] = new HsqlArrayList();
        }
    }

    void processConditions(Session session) {
        int n;
        this.session = session;
        RangeVariableResolver.decomposeAndConditions(session, this.conditions, this.queryExpressions);
        for (n = 0; n < this.rangeVariables.length; ++n) {
            if (this.rangeVariables[n].joinCondition == null) continue;
            RangeVariableResolver.decomposeAndConditions(session, this.rangeVariables[n].joinCondition, this.tempJoinExpressions[n]);
        }
        this.conditions = null;
        for (n = 0; n < this.rangeVariables.length; ++n) {
            this.rangeVarSet.add(this.rangeVariables[n]);
        }
        this.reorder();
        this.rangeVarSet.clear();
        for (n = 0; n < this.rangeVariables.length; ++n) {
            this.rangeVarSet.add(this.rangeVariables[n]);
        }
        this.assignToLists();
        this.expandConditions();
        this.assignToRangeVariables();
    }

    void reorder() {
        Object object;
        int n;
        if (this.rangeVariables.length == 1 || this.firstLeftJoinIndex == 1 || this.firstRightJoinIndex != this.rangeVariables.length) {
            return;
        }
        for (int i = 0; i < this.rangeVariables.length; ++i) {
            if (this.rangeVariables[i].rangeTable.isSchemaBaseTable()) continue;
            return;
        }
        HsqlArrayList hsqlArrayList = new HsqlArrayList();
        HsqlArrayList hsqlArrayList2 = new HsqlArrayList();
        HsqlArrayList hsqlArrayList3 = new HsqlArrayList();
        for (n = 0; n < this.firstLeftJoinIndex; ++n) {
            object = this.tempJoinExpressions[n];
            for (int i = 0; i < ((HsqlArrayList)object).size(); ++i) {
                Expression expression = (Expression)((HsqlArrayList)object).get(i);
                if (expression.isColumnEqual) {
                    hsqlArrayList.add(expression);
                    continue;
                }
                if (expression.isSingleColumnCondition) {
                    hsqlArrayList2.add(expression);
                    continue;
                }
                hsqlArrayList3.add(expression);
            }
        }
        for (n = 0; n < this.queryExpressions.size(); ++n) {
            object = (Expression)this.queryExpressions.get(n);
            RangeVariable[] rangeVariableArray = ((Expression)object).getJoinRangeVariables(this.rangeVariables);
            int n2 = ArrayUtil.countCommonElements(this.rangeVariables, this.firstLeftJoinIndex, rangeVariableArray);
            if (n2 != rangeVariableArray.length) continue;
            if (((Expression)object).isColumnEqual) {
                hsqlArrayList.add(object);
                continue;
            }
            if (((Expression)object).isSingleColumnCondition) {
                hsqlArrayList2.add(object);
                continue;
            }
            hsqlArrayList3.add(object);
        }
        if (hsqlArrayList2.size() == 0) {
            return;
        }
        Expression expression = null;
        double d = this.rangeVariables[0].rangeTable.getRowStore(this.session).elementCount();
        int n3 = 0;
        RangeVariable rangeVariable = null;
        if (d < 16.0) {
            d = 16.0;
        }
        if (this.rangeVariables[0].rangeTable.getTableType() == 5) {
            d *= 8.0;
        }
        for (int i = 0; i < hsqlArrayList2.size(); ++i) {
            Expression expression2 = (Expression)hsqlArrayList2.get(i);
            rangeVariable = expression2.getJoinRangeVariables(this.rangeVariables)[0];
            double d2 = expression2.costFactor(this.session, rangeVariable, 41);
            if (rangeVariable == this.rangeVariables[0]) {
                expression = null;
                break;
            }
            if (!(d2 < d)) continue;
            expression = expression2;
        }
        if (expression == null) {
            return;
        }
        n3 = ArrayUtil.find(this.rangeVariables, rangeVariable);
        if (n3 <= 0) {
            return;
        }
        RangeVariable[] rangeVariableArray = new RangeVariable[this.rangeVariables.length];
        ArrayUtil.copyArray(this.rangeVariables, rangeVariableArray, this.rangeVariables.length);
        rangeVariableArray[n3] = rangeVariableArray[0];
        rangeVariableArray[0] = rangeVariable;
        for (n3 = 1; n3 < this.firstLeftJoinIndex; ++n3) {
            boolean bl = false;
            for (int i = 0; i < hsqlArrayList.size(); ++i) {
                int n4;
                Expression expression3 = (Expression)hsqlArrayList.get(i);
                if (expression3 == null || (n4 = this.getJoinedRangePosition(expression3, n3)) < n3) continue;
                rangeVariable = rangeVariableArray[n3];
                rangeVariableArray[n3] = rangeVariableArray[n4];
                rangeVariableArray[n4] = rangeVariable;
                hsqlArrayList.set(i, null);
                bl = true;
                break;
            }
            if (!bl) break;
        }
        if (n3 != this.firstLeftJoinIndex) {
            return;
        }
        ArrayUtil.copyArray(rangeVariableArray, this.rangeVariables, this.rangeVariables.length);
        hsqlArrayList.clear();
        for (int i = 0; i < this.firstLeftJoinIndex; ++i) {
            HsqlArrayList hsqlArrayList4 = this.tempJoinExpressions[i];
            hsqlArrayList.addAll(hsqlArrayList4);
            hsqlArrayList4.clear();
        }
        this.tempJoinExpressions[this.firstLeftJoinIndex - 1].addAll(hsqlArrayList);
    }

    int getJoinedRangePosition(Expression expression, int n) {
        int n2 = -1;
        RangeVariable[] rangeVariableArray = expression.getJoinRangeVariables(this.rangeVariables);
        for (int i = 0; i < rangeVariableArray.length; ++i) {
            for (int j = 0; j < this.rangeVariables.length; ++j) {
                if (rangeVariableArray[i] != this.rangeVariables[j] || j < n) continue;
                if (n2 > 0) {
                    return -1;
                }
                n2 = j;
            }
        }
        return n2;
    }

    static Expression decomposeAndConditions(Session session, Expression expression, HsqlArrayList hsqlArrayList) {
        if (expression == null) {
            return Expression.EXPR_TRUE;
        }
        Expression expression2 = expression.getLeftNode();
        Expression expression3 = expression.getRightNode();
        int n = expression.getType();
        if (n == 49) {
            expression2 = RangeVariableResolver.decomposeAndConditions(session, expression2, hsqlArrayList);
            expression3 = RangeVariableResolver.decomposeAndConditions(session, expression3, hsqlArrayList);
            if (expression2 == Expression.EXPR_TRUE) {
                return expression3;
            }
            if (expression3 == Expression.EXPR_TRUE) {
                return expression2;
            }
            expression.setLeftNode(expression2);
            expression.setRightNode(expression3);
            return expression;
        }
        if (n == 41 && expression2.getType() == 25 && expression3.getType() == 25) {
            for (int i = 0; i < expression2.nodes.length; ++i) {
                ExpressionLogical expressionLogical = new ExpressionLogical(expression2.nodes[i], expression3.nodes[i]);
                ((Expression)expressionLogical).resolveTypes(session, null);
                hsqlArrayList.add(expressionLogical);
            }
            return Expression.EXPR_TRUE;
        }
        if (expression != Expression.EXPR_TRUE) {
            hsqlArrayList.add(expression);
        }
        return Expression.EXPR_TRUE;
    }

    static Expression decomposeOrConditions(Expression expression, HsqlArrayList hsqlArrayList) {
        if (expression == null) {
            return Expression.EXPR_FALSE;
        }
        Expression expression2 = expression.getLeftNode();
        Expression expression3 = expression.getRightNode();
        int n = expression.getType();
        if (n == 50) {
            expression2 = RangeVariableResolver.decomposeOrConditions(expression2, hsqlArrayList);
            expression3 = RangeVariableResolver.decomposeOrConditions(expression3, hsqlArrayList);
            if (expression2 == Expression.EXPR_FALSE) {
                return expression3;
            }
            if (expression3 == Expression.EXPR_FALSE) {
                return expression2;
            }
            expression = new ExpressionLogical(50, expression2, expression3);
            return expression;
        }
        if (expression != Expression.EXPR_FALSE) {
            hsqlArrayList.add(expression);
        }
        return Expression.EXPR_FALSE;
    }

    void assignToLists() {
        int n;
        int n2 = 0;
        int n3 = -1;
        int n4 = -1;
        for (n = 0; n < this.rangeVariables.length; ++n) {
            if (this.rangeVariables[n].isLeftJoin) {
                n3 = n;
            }
            if (this.rangeVariables[n].isRightJoin) {
                n3 = n;
                n4 = n;
            }
            if (this.rangeVariables[n].isBoundary) {
                n2 = n;
            }
            if (n3 == n) {
                this.joinExpressions[n].addAll(this.tempJoinExpressions[n]);
                continue;
            }
            int n5 = n3 + 1;
            if (n2 > n5) {
                n5 = n2;
            }
            for (int i = 0; i < this.tempJoinExpressions[n].size(); ++i) {
                this.assignToJoinLists((Expression)this.tempJoinExpressions[n].get(i), this.joinExpressions, n5);
            }
        }
        for (n = 0; n < this.queryExpressions.size(); ++n) {
            this.assignToJoinLists((Expression)this.queryExpressions.get(n), this.whereExpressions, n4);
        }
    }

    void assignToJoinLists(Expression expression, HsqlArrayList[] hsqlArrayListArray, int n) {
        this.tempSet.clear();
        expression.collectRangeVariables(this.rangeVariables, this.tempSet);
        int n2 = this.rangeVarSet.getLargestIndex(this.tempSet);
        if (n2 == -1) {
            n2 = 0;
        }
        if (n2 < n) {
            n2 = n;
        }
        hsqlArrayListArray[n2].add(expression);
    }

    void expandConditions() {
        if (this.hasOuterJoin) {
            return;
        }
        this.expandConditions(this.joinExpressions, true);
        this.expandConditions(this.whereExpressions, false);
    }

    void expandConditions(HsqlArrayList[] hsqlArrayListArray, boolean bl) {
        for (int i = 0; i < this.rangeVariables.length; ++i) {
            Object object;
            HsqlArrayList hsqlArrayList = hsqlArrayListArray[i];
            this.tempMap.clear();
            this.tempSet.clear();
            boolean bl2 = false;
            for (int j = 0; j < hsqlArrayList.size(); ++j) {
                object = (Expression)hsqlArrayList.get(j);
                if (!((Expression)object).isColumnEqual || ((Expression)object).getLeftNode().getRangeVariable() == ((Expression)object).getRightNode().getRangeVariable()) continue;
                if (((Expression)object).getLeftNode().getRangeVariable() == this.rangeVariables[i]) {
                    this.tempMap.put(((Expression)object).getLeftNode().getColumn(), ((Expression)object).getRightNode());
                    if (this.tempSet.add(((Expression)object).getLeftNode().getColumn())) continue;
                    bl2 = true;
                    continue;
                }
                if (((Expression)object).getRightNode().getRangeVariable() != this.rangeVariables[i]) continue;
                this.tempMap.put(((Expression)object).getRightNode().getColumn(), ((Expression)object).getLeftNode());
                if (this.tempSet.add(((Expression)object).getRightNode().getColumn())) continue;
                bl2 = true;
            }
            if (!bl2) continue;
            Iterator iterator = this.tempMap.keySet().iterator();
            while (iterator.hasNext()) {
                object = iterator.next();
                Iterator iterator2 = this.tempMap.get(object);
                this.tempSet.clear();
                while (iterator2.hasNext()) {
                    this.tempSet.add(iterator2.next());
                }
                while (this.tempSet.size() > 1) {
                    Expression expression = (Expression)this.tempSet.remove(this.tempSet.size() - 1);
                    for (int j = 0; j < this.tempSet.size(); ++j) {
                        Expression expression2 = (Expression)this.tempSet.get(j);
                        this.closeJoinChain(hsqlArrayListArray, expression, expression2);
                    }
                }
            }
        }
    }

    void closeJoinChain(HsqlArrayList[] hsqlArrayListArray, Expression expression, Expression expression2) {
        int n;
        int n2;
        int n3 = this.rangeVarSet.getIndex(expression.getRangeVariable());
        int n4 = n2 = n3 > (n = this.rangeVarSet.getIndex(expression2.getRangeVariable())) ? n3 : n;
        if (n3 == -1 || n == -1) {
            return;
        }
        ExpressionLogical expressionLogical = new ExpressionLogical(expression, expression2);
        for (int i = 0; i < hsqlArrayListArray[n2].size(); ++i) {
            if (!expressionLogical.equals(hsqlArrayListArray[n2].get(i))) continue;
            return;
        }
        hsqlArrayListArray[n2].add(expressionLogical);
    }

    void assignToRangeVariables() {
        for (int i = 0; i < this.rangeVariables.length; ++i) {
            RangeVariable.RangeVariableConditions rangeVariableConditions;
            boolean bl = false;
            if (i < this.firstLeftJoinIndex && this.firstRightJoinIndex == this.rangeVariables.length) {
                rangeVariableConditions = this.rangeVariables[i].joinConditions[0];
                this.joinExpressions[i].addAll(this.whereExpressions[i]);
                this.assignToRangeVariable(this.rangeVariables[i], rangeVariableConditions, i, this.joinExpressions[i]);
                this.assignToRangeVariable(rangeVariableConditions, this.joinExpressions[i]);
                continue;
            }
            rangeVariableConditions = this.rangeVariables[i].joinConditions[0];
            this.assignToRangeVariable(this.rangeVariables[i], rangeVariableConditions, i, this.joinExpressions[i]);
            rangeVariableConditions = this.rangeVariables[i].joinConditions[0];
            if (rangeVariableConditions.hasIndexCondition()) {
                bl = true;
            }
            this.assignToRangeVariable(rangeVariableConditions, this.joinExpressions[i]);
            rangeVariableConditions = this.rangeVariables[i].whereConditions[0];
            for (int j = i + 1; j < this.rangeVariables.length; ++j) {
                if (!this.rangeVariables[j].isRightJoin) continue;
                this.assignToRangeVariable(this.rangeVariables[j].whereConditions[0], this.whereExpressions[i]);
            }
            if (!bl) {
                this.assignToRangeVariable(this.rangeVariables[i], rangeVariableConditions, i, this.whereExpressions[i]);
            }
            this.assignToRangeVariable(rangeVariableConditions, this.whereExpressions[i]);
        }
        if (this.inExpressionCount != 0) {
            this.setInConditionsAsTables();
        }
    }

    void assignToRangeVariable(RangeVariable.RangeVariableConditions rangeVariableConditions, HsqlArrayList hsqlArrayList) {
        int n = hsqlArrayList.size();
        for (int i = 0; i < n; ++i) {
            Expression expression = (Expression)hsqlArrayList.get(i);
            rangeVariableConditions.addCondition(expression);
        }
    }

    Expression getIndexableColumn(HsqlArrayList hsqlArrayList, int n) {
        int n2 = hsqlArrayList.size();
        for (int i = n; i < n2; ++i) {
            int n3;
            RangeVariable rangeVariable;
            Expression expression = (Expression)hsqlArrayList.get(i);
            if (expression.getType() != 41 || expression.exprSubType == 51 || expression.exprSubType == 52) continue;
            this.tempSet.clear();
            expression.collectRangeVariables(this.rangeVariables, this.tempSet);
            if (this.tempSet.size() != 1 || (expression = expression.getIndexableExpression(rangeVariable = (RangeVariable)this.tempSet.get(0))) == null || (expression = expression.getLeftNode()).getType() != 2 || rangeVariable.rangeTable.indexTypeForColumn(this.session, n3 = expression.getColumnIndex()) == 0) continue;
            return expression;
        }
        return null;
    }

    void assignToRangeVariable(RangeVariable rangeVariable, RangeVariable.RangeVariableConditions rangeVariableConditions, int n, HsqlArrayList hsqlArrayList) {
        if (hsqlArrayList.isEmpty()) {
            return;
        }
        this.setIndexConditions(rangeVariableConditions, hsqlArrayList, n, true);
    }

    private void setIndexConditions(RangeVariable.RangeVariableConditions rangeVariableConditions, HsqlArrayList hsqlArrayList, int n, boolean bl) {
        int n2;
        this.colIndexSetEqual.clear();
        this.colIndexSetOther.clear();
        int n3 = hsqlArrayList.size();
        block8: for (n2 = 0; n2 < n3; ++n2) {
            Expression expression = (Expression)hsqlArrayList.get(n2);
            if (expression == null || !expression.isIndexable(rangeVariableConditions.rangeVar)) continue;
            int n4 = expression.getType();
            switch (n4) {
                case 50: {
                    continue block8;
                }
                case 2: {
                    continue block8;
                }
                case 41: {
                    if (expression.exprSubType == 52 || expression.exprSubType == 51 || expression.getLeftNode().getRangeVariable() != rangeVariableConditions.rangeVar) continue block8;
                    int n5 = expression.getLeftNode().getColumnIndex();
                    this.colIndexSetEqual.add(n5);
                    continue block8;
                }
                case 47: {
                    if (expression.getLeftNode().getRangeVariable() != rangeVariableConditions.rangeVar || rangeVariableConditions.rangeVar.isLeftJoin) continue block8;
                    int n5 = expression.getLeftNode().getColumnIndex();
                    this.colIndexSetEqual.add(n5);
                    continue block8;
                }
                case 48: {
                    if (expression.getLeftNode().getLeftNode().getRangeVariable() != rangeVariableConditions.rangeVar || rangeVariableConditions.rangeVar.isLeftJoin) continue block8;
                    int n5 = expression.getLeftNode().getLeftNode().getColumnIndex();
                    int n6 = this.colIndexSetOther.get(n5, 0);
                    this.colIndexSetOther.put(n5, n6 + 1);
                    continue block8;
                }
                case 42: 
                case 43: 
                case 44: 
                case 45: {
                    if (expression.getLeftNode().getRangeVariable() != rangeVariableConditions.rangeVar) continue block8;
                    int n5 = expression.getLeftNode().getColumnIndex();
                    int n6 = this.colIndexSetOther.get(n5, 0);
                    this.colIndexSetOther.put(n5, n6 + 1);
                    continue block8;
                }
                default: {
                    Error.runtimeError(201, "RangeVariableResolver");
                }
            }
        }
        this.setEqaulityConditions(rangeVariableConditions, hsqlArrayList);
        boolean bl2 = rangeVariableConditions.hasIndexCondition();
        if (!bl2) {
            this.setNonEqualityConditions(rangeVariableConditions, hsqlArrayList);
        }
        bl2 = rangeVariableConditions.hasIndexCondition();
        n2 = 0;
        if (!bl2 && bl) {
            int n7 = hsqlArrayList.size();
            for (n3 = 0; n3 < n7; ++n3) {
                Expression expression = (Expression)hsqlArrayList.get(n3);
                if (expression == null) continue;
                if (expression.getType() == 50) {
                    bl2 = ((ExpressionLogical)expression).isIndexable(rangeVariableConditions.rangeVar);
                    if (bl2) {
                        bl2 = this.setOrConditions(rangeVariableConditions, (ExpressionLogical)expression, n);
                    }
                    if (!bl2) continue;
                    hsqlArrayList.set(n3, null);
                    n2 = 1;
                    break;
                }
                if (expression.getType() != 41 || expression.exprSubType != 52 || n >= this.firstLeftJoinIndex || this.firstRightJoinIndex != this.rangeVariables.length || expression.getRightNode().isCorrelated()) continue;
                OrderedIntHashSet orderedIntHashSet = new OrderedIntHashSet();
                ((ExpressionLogical)expression).addLeftColumnsForAllAny(rangeVariableConditions.rangeVar, orderedIntHashSet);
                Index index = rangeVariableConditions.rangeVar.rangeTable.getIndexForColumns(this.session, orderedIntHashSet, false);
                if (index == null || this.inExpressions[n] != null) continue;
                this.inExpressions[n] = expression;
                this.inInJoin[n] = rangeVariableConditions.isJoin;
                ++this.inExpressionCount;
                hsqlArrayList.set(n3, null);
                break;
            }
        }
        int n8 = hsqlArrayList.size();
        for (n3 = 0; n3 < n8; ++n3) {
            Expression expression = (Expression)hsqlArrayList.get(n3);
            if (expression == null) continue;
            if (n2 != 0) {
                for (int i = 0; i < rangeVariableConditions.rangeVar.joinConditions.length; ++i) {
                    if (rangeVariableConditions.isJoin) {
                        rangeVariableConditions.rangeVar.joinConditions[i].nonIndexCondition = ExpressionLogical.andExpressions(expression, rangeVariableConditions.rangeVar.joinConditions[i].nonIndexCondition);
                        continue;
                    }
                    rangeVariableConditions.rangeVar.whereConditions[i].nonIndexCondition = ExpressionLogical.andExpressions(expression, rangeVariableConditions.rangeVar.whereConditions[i].nonIndexCondition);
                }
                continue;
            }
            rangeVariableConditions.addCondition(expression);
        }
    }

    private boolean setOrConditions(RangeVariable.RangeVariableConditions rangeVariableConditions, ExpressionLogical expressionLogical, int n) {
        Object object;
        Object object2;
        HsqlArrayList hsqlArrayList = new HsqlArrayList();
        RangeVariableResolver.decomposeOrConditions(expressionLogical, hsqlArrayList);
        Object[] objectArray = new RangeVariable.RangeVariableConditions[hsqlArrayList.size()];
        for (int i = 0; i < hsqlArrayList.size(); ++i) {
            HsqlArrayList hsqlArrayList2 = new HsqlArrayList();
            object2 = (Expression)hsqlArrayList.get(i);
            RangeVariableResolver.decomposeAndConditions(this.session, (Expression)object2, hsqlArrayList2);
            object = new RangeVariable.RangeVariableConditions(rangeVariableConditions);
            this.setIndexConditions((RangeVariable.RangeVariableConditions)object, hsqlArrayList2, n, false);
            objectArray[i] = object;
            if (((RangeVariable.RangeVariableConditions)object).hasIndexCondition()) continue;
            return false;
        }
        Expression expression = null;
        for (int i = 0; i < objectArray.length; ++i) {
            object2 = objectArray[i];
            objectArray[i].excludeConditions = expression;
            if (i == objectArray.length - 1) break;
            object = null;
            if (((RangeVariable.RangeVariableConditions)object2).indexCond != null) {
                for (int j = 0; j < ((RangeVariable.RangeVariableConditions)object2).indexedColumnCount; ++j) {
                    object = ExpressionLogical.andExpressions((Expression)object, ((RangeVariable.RangeVariableConditions)object2).indexCond[j]);
                }
            }
            object = ExpressionLogical.andExpressions((Expression)object, ((RangeVariable.RangeVariableConditions)object2).indexEndCondition);
            object = ExpressionLogical.andExpressions((Expression)object, ((RangeVariable.RangeVariableConditions)object2).nonIndexCondition);
            expression = ExpressionLogical.orExpressions((Expression)object, expression);
        }
        if (expression != null) {
            // empty if block
        }
        if (rangeVariableConditions.isJoin) {
            rangeVariableConditions.rangeVar.joinConditions = objectArray;
            objectArray = new RangeVariable.RangeVariableConditions[hsqlArrayList.size()];
            ArrayUtil.fillArray(objectArray, rangeVariableConditions.rangeVar.whereConditions[0]);
            rangeVariableConditions.rangeVar.whereConditions = objectArray;
        } else {
            rangeVariableConditions.rangeVar.whereConditions = objectArray;
            objectArray = new RangeVariable.RangeVariableConditions[hsqlArrayList.size()];
            ArrayUtil.fillArray(objectArray, rangeVariableConditions.rangeVar.joinConditions[0]);
            rangeVariableConditions.rangeVar.joinConditions = objectArray;
        }
        return true;
    }

    private void setEqaulityConditions(RangeVariable.RangeVariableConditions rangeVariableConditions, HsqlArrayList hsqlArrayList) {
        int n;
        Index index = rangeVariableConditions.rangeVar.rangeTable.getIndexForColumns(this.session, this.colIndexSetEqual, false);
        if (index == null) {
            return;
        }
        int[] nArray = index.getColumns();
        int n2 = nArray.length;
        Expression[] expressionArray = new Expression[nArray.length];
        for (n = 0; n < hsqlArrayList.size(); ++n) {
            int n3;
            int n4;
            Expression expression = (Expression)hsqlArrayList.get(n);
            if (expression == null || (n4 = expression.getType()) != 41 && n4 != 47 || expression.getLeftNode().getRangeVariable() != rangeVariableConditions.rangeVar || !expression.isIndexable(rangeVariableConditions.rangeVar) || (n3 = ArrayUtil.find(nArray, expression.getLeftNode().getColumnIndex())) == -1 || expressionArray[n3] != null) continue;
            expressionArray[n3] = expression;
            hsqlArrayList.set(n, null);
        }
        n = 0;
        for (int i = 0; i < expressionArray.length; ++i) {
            Expression expression = expressionArray[i];
            if (expression == null) {
                if (n2 == nArray.length) {
                    n2 = i;
                }
                n = 1;
                continue;
            }
            if (n == 0) continue;
            rangeVariableConditions.addCondition(expression);
            expressionArray[i] = null;
        }
        rangeVariableConditions.addIndexCondition(expressionArray, index, n2);
    }

    private void setNonEqualityConditions(RangeVariable.RangeVariableConditions rangeVariableConditions, HsqlArrayList hsqlArrayList) {
        int n;
        if (this.colIndexSetOther.isEmpty()) {
            return;
        }
        int n2 = 0;
        int n3 = 0;
        Iterator iterator = this.colIndexSetOther.keySet().iterator();
        while (iterator.hasNext()) {
            int n4 = iterator.nextInt();
            n = this.colIndexSetOther.get(n4);
            if (n <= n2) continue;
            n3 = n4;
        }
        Index index = rangeVariableConditions.rangeVar.rangeTable.getIndexForColumn(this.session, n3);
        if (index == null) {
            iterator = this.colIndexSetOther.keySet().iterator();
            while (iterator.hasNext() && ((n = iterator.nextInt()) == n3 || (index = rangeVariableConditions.rangeVar.rangeTable.getIndexForColumn(this.session, n)) == null)) {
            }
        }
        if (index == null) {
            return;
        }
        int[] nArray = index.getColumns();
        for (int i = 0; i < hsqlArrayList.size(); ++i) {
            Expression expression = (Expression)hsqlArrayList.get(i);
            if (expression == null) continue;
            boolean bl = false;
            switch (expression.getType()) {
                case 48: {
                    if (expression.getLeftNode().getType() != 47 || nArray[0] != expression.getLeftNode().getLeftNode().getColumnIndex()) break;
                    bl = true;
                    break;
                }
                case 42: 
                case 43: 
                case 44: 
                case 45: {
                    if (nArray[0] != expression.getLeftNode().getColumnIndex() || expression.getRightNode() == null || expression.getRightNode().isCorrelated()) break;
                    bl = true;
                }
            }
            if (!bl) continue;
            Expression[] expressionArray = new Expression[index.getColumnCount()];
            expressionArray[0] = expression;
            rangeVariableConditions.addIndexCondition(expressionArray, index, 1);
            hsqlArrayList.set(i, null);
            break;
        }
    }

    void setInConditionsAsTables() {
        for (int i = this.rangeVariables.length - 1; i >= 0; --i) {
            int n;
            int n2;
            RangeVariable rangeVariable = this.rangeVariables[i];
            ExpressionLogical expressionLogical = (ExpressionLogical)this.inExpressions[i];
            if (expressionLogical == null) continue;
            OrderedIntHashSet orderedIntHashSet = new OrderedIntHashSet();
            expressionLogical.addLeftColumnsForAllAny(rangeVariable, orderedIntHashSet);
            Index index = rangeVariable.rangeTable.getIndexForColumns(this.session, orderedIntHashSet, false);
            int n3 = 0;
            for (int j = 0; j < index.getColumnCount() && orderedIntHashSet.contains(index.getColumns()[j]); ++j) {
                ++n3;
            }
            RangeVariable rangeVariable2 = new RangeVariable(expressionLogical.getRightNode().getTable(), null, null, null, this.compileContext);
            rangeVariable2.isGenerated = true;
            RangeVariable[] rangeVariableArray = new RangeVariable[this.rangeVariables.length + 1];
            ArrayUtil.copyAdjustArray(this.rangeVariables, rangeVariableArray, rangeVariable2, i, 1);
            this.rangeVariables = rangeVariableArray;
            Expression[] expressionArray = new Expression[index.getColumnCount()];
            for (n2 = 0; n2 < n3; ++n2) {
                int n4 = index.getColumns()[n2];
                n = orderedIntHashSet.getIndex(n4);
                ExpressionLogical expressionLogical2 = new ExpressionLogical(rangeVariable, n4, rangeVariable2, n);
                expressionArray[n2] = expressionLogical2;
            }
            n2 = this.rangeVariables[i].isLeftJoin || this.rangeVariables[i].isRightJoin ? 1 : 0;
            RangeVariable.RangeVariableConditions rangeVariableConditions = !this.inInJoin[i] && n2 != 0 ? rangeVariable.whereConditions[0] : rangeVariable.joinConditions[0];
            rangeVariableConditions.addIndexCondition(expressionArray, index, n3);
            n = 0;
            while (n < orderedIntHashSet.size()) {
                int n5 = orderedIntHashSet.get(n);
                int n6 = n++;
                ExpressionLogical expressionLogical3 = new ExpressionLogical(rangeVariable, n5, rangeVariable2, n6);
                rangeVariableConditions.addCondition(expressionLogical3);
            }
        }
    }
}

