/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.openejb.core.timer;

import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

/**
 * @version $Rev$ $Date$
 */
public class EjbTimeoutJob implements Job {

    public static final String EJB_TIMERS_SERVICE = "EJB_TIMERS_SERVICE";

    public static final String TIMER_DATA = "TIMER_DATA";

    @Override
    public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        JobDataMap jobDataMap = jobExecutionContext.getMergedJobDataMap();
        EjbTimerServiceImpl ejbTimerService = (EjbTimerServiceImpl) jobDataMap.get(EJB_TIMERS_SERVICE);
        TimerData timerData = (TimerData) jobDataMap.get(TIMER_DATA);
        ejbTimerService.ejbTimeout(timerData);
    }
}
