/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.openejb.core.ivm.naming;

import org.apache.openejb.loader.SystemInstance;

import javax.naming.NamingException;
import javax.naming.NameNotFoundException;

/**
 * @version $Rev: 1153797 $ $Date: 2011-08-04 02:09:44 -0700 (Thu, 04 Aug 2011) $
 */
public class SystemComponentReference extends Reference {
    private final Class<? extends Object> type;

    public SystemComponentReference(Class<? extends Object> type) {
        if (type == null) throw new NullPointerException("type is null");
        this.type = type;
    }

    public Object getObject() throws NamingException {
        Object component = SystemInstance.get().getComponent(type);
        if (component == null) {
            throw new NameNotFoundException("No " + type.getSimpleName() + " registered with the OpenEJB system");
        }
        return component;
    }
}
