/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.client;

import java.lang.reflect.Method;
import java.rmi.RemoteException;
import org.apache.openejb.client.ClientMetaData;
import org.apache.openejb.client.EJBMetaDataImpl;
import org.apache.openejb.client.EJBObjectHandler;
import org.apache.openejb.client.EJBObjectProxy;
import org.apache.openejb.client.EJBRequest;
import org.apache.openejb.client.EJBResponse;
import org.apache.openejb.client.ServerMetaData;

public class StatefulEJBObjectHandler
extends EJBObjectHandler {
    public StatefulEJBObjectHandler() {
    }

    public StatefulEJBObjectHandler(EJBMetaDataImpl ejb, ServerMetaData server, ClientMetaData client) {
        super(ejb, server, client);
    }

    public StatefulEJBObjectHandler(EJBMetaDataImpl ejb, ServerMetaData server, ClientMetaData client, Object primaryKey) {
        super(ejb, server, client, primaryKey);
        StatefulEJBObjectHandler.registerHandler(primaryKey, this);
    }

    @Override
    public Object getRegistryId() {
        return this.primaryKey;
    }

    @Override
    protected Object getPrimaryKey(Method method, Object[] args, Object proxy) throws Throwable {
        throw new RemoteException("Session objects are private resources and do not have primary keys");
    }

    @Override
    protected Object isIdentical(Method method, Object[] args, Object proxy) throws Throwable {
        if (args[0] == null) {
            return Boolean.FALSE;
        }
        EJBObjectProxy ejbObject = (EJBObjectProxy)args[0];
        EJBObjectHandler that = ejbObject.getEJBObjectHandler();
        return new Boolean(this.primaryKey.equals(that.primaryKey));
    }

    @Override
    protected Object equals(Method method, Object[] args, Object proxy) throws Throwable {
        return this.isIdentical(method, args, proxy);
    }

    @Override
    protected Object remove(Method method, Object[] args, Object proxy) throws Throwable {
        EJBRequest req = new EJBRequest(18, this.ejb, method, args, this.primaryKey);
        EJBResponse res = this.request(req);
        if (11 == res.getResponseCode()) {
            throw (Throwable)res.getResult();
        }
        StatefulEJBObjectHandler.invalidateAllHandlers(this.getRegistryId());
        this.invalidateReference();
        return null;
    }
}

