/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.config;

import java.util.Map;
import javax.faces.context.ExternalContext;
import org.apache.myfaces.trinidad.bean.util.StateUtils;
import org.apache.myfaces.trinidad.config.Configurator;
import org.apache.myfaces.trinidad.context.ExternalContextDecorator;
import org.apache.myfaces.trinidad.util.CollectionUtils;

public final class CheckSerializationConfigurator
extends Configurator {
    public ExternalContext getExternalContext(ExternalContext externalContext) {
        boolean checkSession = StateUtils.checkSessionSerialization((ExternalContext)externalContext);
        boolean checkApplication = StateUtils.checkApplicationSerialization((ExternalContext)externalContext);
        if (checkSession || checkApplication) {
            return new SessionSerializationChecker(externalContext, checkSession, checkApplication);
        }
        return externalContext;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SessionSerializationChecker
    extends ExternalContextDecorator {
        private final ExternalContext _extContext;
        private final Map _sessionMap;
        private final Map _applicationMap;

        public SessionSerializationChecker(ExternalContext extContext, boolean checkSession, boolean checkApplication) {
            this._extContext = extContext;
            Map sessionMap = extContext.getSessionMap();
            this._sessionMap = checkSession ? CollectionUtils.getCheckedSerializationMap((Map)sessionMap) : sessionMap;
            Map applicationMap = extContext.getApplicationMap();
            this._applicationMap = checkApplication ? CollectionUtils.getCheckedSerializationMap((Map)applicationMap) : applicationMap;
        }

        protected ExternalContext getExternalContext() {
            return this._extContext;
        }

        public Map<String, Object> getSessionMap() {
            return this._sessionMap;
        }

        public Map<String, Object> getApplicationMap() {
            return this._applicationMap;
        }
    }
}

