/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.webdav.client.methods;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class XmlRequestEntity
implements RequestEntity {
    private static Logger log = LoggerFactory.getLogger((Class)XmlRequestEntity.class);
    private final RequestEntity delegatee;

    public XmlRequestEntity(Document xmlDocument) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer();
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("indent", "no");
            transformer.transform(new DOMSource(xmlDocument), new StreamResult(out));
        }
        catch (TransformerException e) {
            log.error("XML serialization failed", (Throwable)e);
            IOException exception = new IOException("XML serialization failed");
            exception.initCause(e);
            throw exception;
        }
        this.delegatee = new StringRequestEntity(out.toString(), "text/xml", "UTF-8");
    }

    public boolean isRepeatable() {
        return this.delegatee.isRepeatable();
    }

    public String getContentType() {
        return this.delegatee.getContentType();
    }

    public void writeRequest(OutputStream out) throws IOException {
        this.delegatee.writeRequest(out);
    }

    public long getContentLength() {
        return this.delegatee.getContentLength();
    }
}

