/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.testng;

import java.io.File;
import java.lang.reflect.Constructor;
import java.util.List;
import java.util.Map;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.surefire.report.ReporterManager;
import org.apache.maven.surefire.testng.TestNGReporter;
import org.apache.maven.surefire.testng.TestNgTestSuite;
import org.apache.maven.surefire.testng.conf.Configurator;
import org.apache.maven.surefire.testng.conf.TestNG4751Configurator;
import org.apache.maven.surefire.testng.conf.TestNG52Configurator;
import org.apache.maven.surefire.testng.conf.TestNGMapConfigurator;
import org.apache.maven.surefire.testset.TestSetFailedException;
import org.testng.IReporter;
import org.testng.TestNG;

public class TestNGExecutor {
    private TestNGExecutor() {
    }

    public static void run(Class[] testClasses, String testSourceDirectory, Map options, ArtifactVersion version, String classifier, ReporterManager reportManager, TestNgTestSuite suite, File reportsDirectory) throws TestSetFailedException {
        TestNG testng = new TestNG(true);
        Configurator configurator = TestNGExecutor.getConfigurator(version);
        configurator.configure(testng, options);
        TestNGExecutor.postConfigure(testng, testSourceDirectory, classifier, reportManager, suite, reportsDirectory);
        testng.setTestClasses(testClasses);
        testng.run();
    }

    public static void run(List suiteFiles, String testSourceDirectory, Map options, ArtifactVersion version, String classifier, ReporterManager reportManager, TestNgTestSuite suite, File reportsDirectory) throws TestSetFailedException {
        TestNG testng = new TestNG(true);
        Configurator configurator = TestNGExecutor.getConfigurator(version);
        configurator.configure(testng, options);
        TestNGExecutor.postConfigure(testng, testSourceDirectory, classifier, reportManager, suite, reportsDirectory);
        testng.setTestSuites(suiteFiles);
        testng.run();
    }

    private static Configurator getConfigurator(ArtifactVersion version) throws TestSetFailedException {
        try {
            VersionRange range = VersionRange.createFromVersionSpec((String)"[4.7,5.1]");
            if (range.containsVersion(version)) {
                return new TestNG4751Configurator();
            }
            range = VersionRange.createFromVersionSpec((String)"[5.2]");
            if (range.containsVersion(version)) {
                return new TestNG52Configurator();
            }
            range = VersionRange.createFromVersionSpec((String)"[5.3,)");
            if (range.containsVersion(version)) {
                return new TestNGMapConfigurator();
            }
            throw new TestSetFailedException("Unknown TestNG version " + version);
        }
        catch (InvalidVersionSpecificationException invsex) {
            throw new TestSetFailedException("Bug in plugin. Please report it with the attached stacktrace", (Throwable)invsex);
        }
    }

    private static void postConfigure(TestNG testNG, String sourcePath, String classifier, ReporterManager reportManager, TestNgTestSuite suite, File reportsDirectory) throws TestSetFailedException {
        testNG.setVerbose(0);
        TestNGReporter reporter = TestNGExecutor.createTestNGReporter(reportManager, suite);
        testNG.addListener((Object)reporter);
        if (sourcePath != null) {
            testNG.setSourcePath(sourcePath);
        }
        testNG.setOutputDirectory(reportsDirectory.getAbsolutePath());
    }

    private static TestNGReporter createTestNGReporter(ReporterManager reportManager, TestNgTestSuite suite) {
        try {
            Class.forName("org.testng.internal.IResultListener");
            Class<?> c = Class.forName("org.apache.maven.surefire.testng.ConfigurationAwareTestNGReporter");
            try {
                Constructor<?> ctor = c.getConstructor(ReporterManager.class, TestNgTestSuite.class);
                return (TestNGReporter)ctor.newInstance(reportManager, suite);
            }
            catch (Exception e) {
                throw new RuntimeException("Bug in ConfigurationAwareTestNGReporter", e);
            }
        }
        catch (ClassNotFoundException e) {
            return new TestNGReporter(reportManager);
        }
    }

    private static void attachNonStandardReporter(TestNG testNG, String className) {
        try {
            Class<?> c = Class.forName(className);
            if (IReporter.class.isAssignableFrom(c)) {
                testNG.addListener(c.newInstance());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

