/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.report;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import org.apache.maven.surefire.report.ConsoleOutputReceiver;

public class ConsoleOutputCapture {
    private static final PrintStream oldOut = System.out;
    private static final PrintStream oldErr = System.err;

    public ConsoleOutputCapture(ConsoleOutputReceiver target) {
        System.setOut(new ForwardingPrintStream(true, target));
        System.setErr(new ForwardingPrintStream(false, target));
    }

    public void restoreStreams() {
        System.setOut(oldOut);
        System.setErr(oldErr);
    }

    static class ForwardingPrintStream
    extends PrintStream {
        private final boolean isStdout;
        private final ConsoleOutputReceiver target;

        ForwardingPrintStream(boolean stdout, ConsoleOutputReceiver target) {
            super(new ByteArrayOutputStream());
            this.isStdout = stdout;
            this.target = target;
        }

        public void write(byte[] buf, int off, int len) {
            this.target.writeTestOutput(buf, off, len, this.isStdout);
        }

        public void write(byte[] b) throws IOException {
            this.target.writeTestOutput(b, 0, b.length, this.isStdout);
        }

        public void close() {
        }

        public void flush() {
        }
    }
}

