/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.suite;

import java.io.File;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.maven.surefire.report.ReportEntry;
import org.apache.maven.surefire.report.ReporterException;
import org.apache.maven.surefire.report.ReporterManager;
import org.apache.maven.surefire.shade.org.codehaus.plexus.util.DirectoryScanner;
import org.apache.maven.surefire.shade.org.codehaus.plexus.util.StringUtils;
import org.apache.maven.surefire.suite.SurefireTestSuite;
import org.apache.maven.surefire.testset.SurefireTestSet;
import org.apache.maven.surefire.testset.TestSetFailedException;

public abstract class AbstractDirectoryTestSuite
implements SurefireTestSuite {
    protected static ResourceBundle bundle = ResourceBundle.getBundle("org.apache.maven.surefire.surefire");
    private static final String FS = System.getProperty("file.separator");
    private File basedir;
    private List includes;
    private List excludes;
    protected Map testSets;
    private int totalTests;
    private static final String[] EMPTY_STRING_ARRAY = new String[0];

    protected AbstractDirectoryTestSuite(File basedir, List includes, List excludes) {
        this.basedir = basedir;
        this.includes = new ArrayList(includes);
        this.excludes = new ArrayList(excludes);
    }

    public Map locateTestSets(ClassLoader classLoader) throws TestSetFailedException {
        if (this.testSets != null) {
            throw new IllegalStateException("You can't call locateTestSets twice");
        }
        this.testSets = new HashMap();
        String[] tests = this.collectTests(this.basedir, this.includes, this.excludes);
        for (int i = 0; i < tests.length; ++i) {
            SurefireTestSet testSet;
            Class<?> testClass;
            String className = tests[i];
            try {
                testClass = classLoader.loadClass(className);
            }
            catch (ClassNotFoundException e) {
                throw new TestSetFailedException("Unable to create test class '" + className + "'", e);
            }
            if (Modifier.isAbstract(testClass.getModifiers()) || (testSet = this.createTestSet(testClass, classLoader)) == null) continue;
            if (this.testSets.containsKey(testSet.getName())) {
                throw new TestSetFailedException("Duplicate test set '" + testSet.getName() + "'");
            }
            this.testSets.put(testSet.getName(), testSet);
            ++this.totalTests;
        }
        return Collections.unmodifiableMap(this.testSets);
    }

    protected abstract SurefireTestSet createTestSet(Class var1, ClassLoader var2) throws TestSetFailedException;

    public void execute(ReporterManager reporterManager, ClassLoader classLoader) throws ReporterException, TestSetFailedException {
        if (this.testSets == null) {
            throw new IllegalStateException("You must call locateTestSets before calling execute");
        }
        Iterator i = this.testSets.values().iterator();
        while (i.hasNext()) {
            SurefireTestSet testSet = (SurefireTestSet)i.next();
            this.executeTestSet(testSet, reporterManager, classLoader);
        }
    }

    private void executeTestSet(SurefireTestSet testSet, ReporterManager reporterManager, ClassLoader classLoader) throws ReporterException, TestSetFailedException {
        String rawString = bundle.getString("testSetStarting");
        ReportEntry report = new ReportEntry(this, testSet.getName(), rawString);
        reporterManager.testSetStarting(report);
        testSet.execute(reporterManager, classLoader);
        rawString = bundle.getString("testSetCompletedNormally");
        report = new ReportEntry(this, testSet.getName(), rawString);
        reporterManager.testSetCompleted(report);
        reporterManager.reset();
    }

    public void execute(String testSetName, ReporterManager reporterManager, ClassLoader classLoader) throws ReporterException, TestSetFailedException {
        if (this.testSets == null) {
            throw new IllegalStateException("You must call locateTestSets before calling execute");
        }
        SurefireTestSet testSet = (SurefireTestSet)this.testSets.get(testSetName);
        if (testSet == null) {
            throw new TestSetFailedException("Unable to find test set '" + testSetName + "' in suite");
        }
        this.executeTestSet(testSet, reporterManager, classLoader);
    }

    public int getNumTests() {
        if (this.testSets == null) {
            throw new IllegalStateException("You must call locateTestSets before calling getNumTests");
        }
        return this.totalTests;
    }

    private String[] collectTests(File basedir, List includes, List excludes) {
        String[] tests = EMPTY_STRING_ARRAY;
        if (basedir.exists()) {
            DirectoryScanner scanner = new DirectoryScanner();
            scanner.setBasedir(basedir);
            if (includes != null) {
                scanner.setIncludes(AbstractDirectoryTestSuite.processIncludesExcludes(includes));
            }
            if (excludes != null) {
                scanner.setExcludes(AbstractDirectoryTestSuite.processIncludesExcludes(excludes));
            }
            scanner.scan();
            tests = scanner.getIncludedFiles();
            for (int i = 0; i < tests.length; ++i) {
                String test = tests[i];
                test = test.substring(0, test.indexOf("."));
                tests[i] = test.replace(FS.charAt(0), '.');
            }
        }
        return tests;
    }

    private static String[] processIncludesExcludes(List list) {
        String[] incs = new String[list.size()];
        for (int i = 0; i < incs.length; ++i) {
            incs[i] = StringUtils.replace((String)list.get(i), "java", "class");
        }
        return incs;
    }
}

