/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.util.internal;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class TestClassMethodNameUtils {
    private static final Pattern METHOD_CLASS_PATTERN = Pattern.compile("([\\s\\S]*)\\((.*)\\)");

    private TestClassMethodNameUtils() {
        throw new IllegalStateException("no instantiable constructor");
    }

    public static String extractClassName(String displayName) {
        Matcher m = METHOD_CLASS_PATTERN.matcher(displayName);
        return m.matches() ? m.group(2) : displayName;
    }

    public static String extractMethodName(String displayName) {
        Matcher m = METHOD_CLASS_PATTERN.matcher(displayName);
        return m.matches() ? m.group(1) : displayName;
    }
}

