/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.dependency.graph.internal;

import java.util.ArrayList;
import java.util.Collections;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.model.Exclusion;
import org.apache.maven.project.DefaultDependencyResolutionRequest;
import org.apache.maven.project.DependencyResolutionException;
import org.apache.maven.project.DependencyResolutionRequest;
import org.apache.maven.project.DependencyResolutionResult;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.project.ProjectDependenciesResolver;
import org.apache.maven.shared.dependency.graph.DependencyGraphBuilder;
import org.apache.maven.shared.dependency.graph.DependencyGraphBuilderException;
import org.apache.maven.shared.dependency.graph.DependencyNode;
import org.apache.maven.shared.dependency.graph.internal.DefaultDependencyNode;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyFilter;
import org.eclipse.aether.util.graph.manager.DependencyManagerUtils;
import org.eclipse.aether.version.VersionConstraint;

@Named
public class DefaultDependencyGraphBuilder
implements DependencyGraphBuilder {
    private final ProjectDependenciesResolver resolver;

    @Inject
    public DefaultDependencyGraphBuilder(ProjectDependenciesResolver resolver) {
        this.resolver = resolver;
    }

    @Override
    public DependencyNode buildDependencyGraph(ProjectBuildingRequest buildingRequest, ArtifactFilter filter) throws DependencyGraphBuilderException {
        MavenProject project = buildingRequest.getProject();
        RepositorySystemSession session = buildingRequest.getRepositorySession();
        if (Boolean.TRUE != session.getConfigProperties().get("premanaged.version")) {
            DefaultRepositorySystemSession newSession = new DefaultRepositorySystemSession(session);
            newSession.setConfigProperty("premanaged.version", (Object)true);
            session = newSession;
        }
        DefaultDependencyResolutionRequest request = new DefaultDependencyResolutionRequest();
        request.setMavenProject(project);
        request.setRepositorySession(session);
        DependencyFilter collectFilter = (node, parents) -> false;
        request.setResolutionFilter(collectFilter);
        DependencyResolutionResult result = this.resolveDependencies((DependencyResolutionRequest)request);
        org.eclipse.aether.graph.DependencyNode graph = result.getDependencyGraph();
        return this.buildDependencyNode(null, graph, project.getArtifact(), filter);
    }

    private DependencyResolutionResult resolveDependencies(DependencyResolutionRequest request) throws DependencyGraphBuilderException {
        try {
            return this.resolver.resolve(request);
        }
        catch (DependencyResolutionException e) {
            throw new DependencyGraphBuilderException("Could not resolve following dependencies: " + e.getResult().getUnresolvedDependencies(), e);
        }
    }

    private org.apache.maven.artifact.Artifact getDependencyArtifact(Dependency dep) {
        Artifact artifact = dep.getArtifact();
        org.apache.maven.artifact.Artifact mavenArtifact = RepositoryUtils.toArtifact((Artifact)artifact);
        mavenArtifact.setScope(dep.getScope());
        mavenArtifact.setOptional(dep.isOptional());
        return mavenArtifact;
    }

    private DependencyNode buildDependencyNode(DependencyNode parent, org.eclipse.aether.graph.DependencyNode node, org.apache.maven.artifact.Artifact artifact, ArtifactFilter filter) {
        String premanagedVersion = DependencyManagerUtils.getPremanagedVersion((org.eclipse.aether.graph.DependencyNode)node);
        String premanagedScope = DependencyManagerUtils.getPremanagedScope((org.eclipse.aether.graph.DependencyNode)node);
        ArrayList<Exclusion> exclusions = null;
        Boolean optional = artifact.isOptional();
        if (node.getDependency() != null) {
            exclusions = new ArrayList<Exclusion>(node.getDependency().getExclusions().size());
            for (org.eclipse.aether.graph.Exclusion exclusion : node.getDependency().getExclusions()) {
                Exclusion modelExclusion = new Exclusion();
                modelExclusion.setGroupId(exclusion.getGroupId());
                modelExclusion.setArtifactId(exclusion.getArtifactId());
                exclusions.add(modelExclusion);
            }
        }
        DefaultDependencyNode current = new DefaultDependencyNode(parent, artifact, premanagedVersion, premanagedScope, this.getVersionSelectedFromRange(node.getVersionConstraint()), optional, exclusions);
        ArrayList<DependencyNode> nodes = new ArrayList<DependencyNode>(node.getChildren().size());
        for (org.eclipse.aether.graph.DependencyNode child : node.getChildren()) {
            org.apache.maven.artifact.Artifact childArtifact = this.getDependencyArtifact(child.getDependency());
            if (filter != null && !filter.include(childArtifact)) continue;
            nodes.add(this.buildDependencyNode(current, child, childArtifact, filter));
        }
        current.setChildren(Collections.unmodifiableList(nodes));
        return current;
    }

    private String getVersionSelectedFromRange(VersionConstraint constraint) {
        if (constraint == null || constraint.getVersion() != null) {
            return null;
        }
        return constraint.getRange().toString();
    }
}

