/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.git.gitexe.command.changelog;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.apache.maven.scm.CommandParameter;
import org.apache.maven.scm.CommandParameters;
import org.apache.maven.scm.ScmBranch;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.ScmVersion;
import org.apache.maven.scm.command.changelog.AbstractChangeLogCommand;
import org.apache.maven.scm.command.changelog.ChangeLogScmRequest;
import org.apache.maven.scm.command.changelog.ChangeLogScmResult;
import org.apache.maven.scm.command.changelog.ChangeLogSet;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.git.command.GitCommand;
import org.apache.maven.scm.provider.git.gitexe.command.GitCommandLineUtils;
import org.apache.maven.scm.provider.git.gitexe.command.changelog.GitChangeLogConsumer;
import org.apache.maven.scm.provider.git.repository.GitScmProviderRepository;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

public class GitChangeLogCommand
extends AbstractChangeLogCommand
implements GitCommand {
    private static final String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss Z";

    public ScmResult executeCommand(ScmProviderRepository repository, ScmFileSet fileSet, CommandParameters parameters) throws ScmException {
        return this.executeChangeLogCommand(repository, fileSet, parameters.getDate(CommandParameter.START_DATE, null), parameters.getDate(CommandParameter.END_DATE, null), (ScmBranch)parameters.getScmVersion(CommandParameter.BRANCH, null), parameters.getString(CommandParameter.CHANGELOG_DATE_PATTERN, null), parameters.getScmVersion(CommandParameter.START_SCM_VERSION, null), parameters.getScmVersion(CommandParameter.END_SCM_VERSION, null), parameters.getInt(CommandParameter.LIMIT, -1), parameters.getScmVersion(CommandParameter.SCM_VERSION, null));
    }

    protected ChangeLogScmResult executeChangeLogCommand(ScmProviderRepository repo, ScmFileSet fileSet, ScmVersion startVersion, ScmVersion endVersion, String datePattern) throws ScmException {
        return this.executeChangeLogCommand(repo, fileSet, null, null, null, datePattern, startVersion, endVersion);
    }

    protected ChangeLogScmResult executeChangeLogCommand(ScmProviderRepository repo, ScmFileSet fileSet, Date startDate, Date endDate, ScmBranch branch, String datePattern) throws ScmException {
        return this.executeChangeLogCommand(repo, fileSet, startDate, endDate, branch, datePattern, null, null);
    }

    protected ChangeLogScmResult executeChangeLogCommand(ScmProviderRepository repository, ScmFileSet fileSet, ScmVersion version, String datePattern) throws ScmException {
        return this.executeChangeLogCommand(repository, fileSet, null, null, null, datePattern, null, null, null, version);
    }

    protected ChangeLogScmResult executeChangeLogCommand(ScmProviderRepository repo, ScmFileSet fileSet, Date startDate, Date endDate, ScmBranch branch, String datePattern, ScmVersion startVersion, ScmVersion endVersion) throws ScmException {
        return this.executeChangeLogCommand(repo, fileSet, startDate, endDate, branch, datePattern, startVersion, endVersion, null, null);
    }

    protected ChangeLogScmResult executeChangeLogCommand(ChangeLogScmRequest request) throws ScmException {
        ScmVersion startVersion = request.getStartRevision();
        ScmVersion endVersion = request.getEndRevision();
        ScmVersion revision = request.getRevision();
        ScmFileSet fileSet = request.getScmFileSet();
        String datePattern = request.getDatePattern();
        ScmProviderRepository providerRepository = request.getScmRepository().getProviderRepository();
        Date startDate = request.getStartDate();
        Date endDate = request.getEndDate();
        ScmBranch branch = request.getScmBranch();
        Integer limit = request.getLimit();
        return this.executeChangeLogCommand(providerRepository, fileSet, startDate, endDate, branch, datePattern, startVersion, endVersion, limit, revision);
    }

    protected ChangeLogScmResult executeChangeLogCommand(ScmProviderRepository repo, ScmFileSet fileSet, Date startDate, Date endDate, ScmBranch branch, String datePattern, ScmVersion startVersion, ScmVersion endVersion, Integer limit) throws ScmException {
        return this.executeChangeLogCommand(repo, fileSet, startDate, endDate, branch, datePattern, startVersion, endVersion, limit, null);
    }

    protected ChangeLogScmResult executeChangeLogCommand(ScmProviderRepository repo, ScmFileSet fileSet, Date startDate, Date endDate, ScmBranch branch, String datePattern, ScmVersion startVersion, ScmVersion endVersion, Integer limit, ScmVersion version) throws ScmException {
        CommandLineUtils.StringStreamConsumer stderr;
        GitChangeLogConsumer consumer;
        Commandline cl = GitChangeLogCommand.createCommandLine((GitScmProviderRepository)repo, fileSet.getBasedir(), branch, startDate, endDate, startVersion, endVersion, limit, version);
        int exitCode = GitCommandLineUtils.execute(cl, (StreamConsumer)(consumer = new GitChangeLogConsumer(datePattern)), stderr = new CommandLineUtils.StringStreamConsumer());
        if (exitCode != 0) {
            return new ChangeLogScmResult(cl.toString(), "The git-log command failed.", stderr.getOutput(), false);
        }
        ChangeLogSet changeLogSet = new ChangeLogSet(consumer.getModifications(), startDate, endDate);
        changeLogSet.setStartVersion(startVersion);
        changeLogSet.setEndVersion(endVersion);
        return new ChangeLogScmResult(cl.toString(), changeLogSet);
    }

    public static Commandline createCommandLine(GitScmProviderRepository repository, File workingDirectory, ScmBranch branch, Date startDate, Date endDate, ScmVersion startVersion, ScmVersion endVersion) {
        return GitChangeLogCommand.createCommandLine(repository, workingDirectory, branch, startDate, endDate, startVersion, endVersion, null);
    }

    static Commandline createCommandLine(GitScmProviderRepository repository, File workingDirectory, ScmBranch branch, Date startDate, Date endDate, ScmVersion startVersion, ScmVersion endVersion, Integer limit) {
        return GitChangeLogCommand.createCommandLine(repository, workingDirectory, branch, startDate, endDate, startVersion, endVersion, limit, null);
    }

    static Commandline createCommandLine(GitScmProviderRepository repository, File workingDirectory, ScmBranch branch, Date startDate, Date endDate, ScmVersion startVersion, ScmVersion endVersion, Integer limit, ScmVersion version) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(DATE_FORMAT);
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        Commandline cl = GitCommandLineUtils.getBaseGitCommandLine(workingDirectory, "whatchanged");
        cl.createArg().setValue("--format=medium");
        cl.createArg().setValue("--decorate=short");
        cl.createArg().setValue("--raw");
        cl.createArg().setValue("--no-merges");
        if (startDate != null || endDate != null) {
            if (startDate != null) {
                cl.createArg().setValue("--since=" + StringUtils.escape((String)dateFormat.format(startDate)));
            }
            if (endDate != null) {
                cl.createArg().setValue("--until=" + StringUtils.escape((String)dateFormat.format(endDate)));
            }
        }
        cl.createArg().setValue("--date=iso");
        if (startVersion != null || endVersion != null) {
            StringBuilder versionRange = new StringBuilder();
            if (startVersion != null) {
                versionRange.append(StringUtils.escape((String)startVersion.getName()));
            }
            versionRange.append("..");
            if (endVersion != null) {
                versionRange.append(StringUtils.escape((String)endVersion.getName()));
            }
            cl.createArg().setValue(versionRange.toString());
        } else if (version != null) {
            cl.createArg().setValue(StringUtils.escape((String)version.getName()));
        }
        if (limit != null && limit > 0) {
            cl.createArg().setValue("--max-count=" + limit);
        }
        if (branch != null && branch.getName() != null && branch.getName().length() > 0) {
            cl.createArg().setValue(branch.getName());
        }
        cl.createArg().setValue("--");
        cl.createArg().setValue(".");
        return cl;
    }
}

