/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.cvslib.command.add;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFile;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmFileStatus;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.command.add.AbstractAddCommand;
import org.apache.maven.scm.command.add.AddScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.cvslib.command.CvsCommand;
import org.apache.maven.scm.provider.cvslib.command.CvsCommandUtils;
import org.apache.maven.scm.provider.cvslib.repository.CvsScmProviderRepository;
import org.codehaus.plexus.util.cli.Commandline;

public abstract class AbstractCvsAddCommand
extends AbstractAddCommand
implements CvsCommand {
    protected ScmResult executeAddCommand(ScmProviderRepository repo, ScmFileSet fileSet, String message, boolean binary) throws ScmException {
        CvsScmProviderRepository repository = (CvsScmProviderRepository)repo;
        Commandline cl = CvsCommandUtils.getBaseCommand("add", repository, fileSet);
        if (binary) {
            cl.createArgument().setValue("-kb");
        }
        if (message != null && message.length() > 0) {
            cl.createArgument().setValue("-m");
            cl.createArgument().setValue("\"" + message + "\"");
        }
        File[] files = fileSet.getFiles();
        ArrayList<ScmFile> addedFiles = new ArrayList<ScmFile>();
        for (int i = 0; i < files.length; ++i) {
            String path = files[i].getPath().replace('\\', '/');
            cl.createArgument().setValue(path);
            addedFiles.add(new ScmFile(path, ScmFileStatus.ADDED));
        }
        this.getLogger().info("Executing: " + cl);
        this.getLogger().info("Working directory: " + cl.getWorkingDirectory().getAbsolutePath());
        return this.executeCvsCommand(cl, addedFiles);
    }

    protected abstract AddScmResult executeCvsCommand(Commandline var1, List var2) throws ScmException;
}

