/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.release.phase;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.artifact.InvalidDependencyVersionException;
import org.apache.maven.shared.release.ReleaseExecutionException;
import org.apache.maven.shared.release.ReleaseFailureException;
import org.apache.maven.shared.release.ReleaseResult;
import org.apache.maven.shared.release.config.ReleaseDescriptor;
import org.apache.maven.shared.release.env.ReleaseEnvironment;
import org.apache.maven.shared.release.phase.AbstractReleasePhase;
import org.apache.maven.shared.release.versions.DefaultVersionInfo;
import org.apache.maven.shared.release.versions.VersionParseException;
import org.codehaus.plexus.components.interactivity.Prompter;
import org.codehaus.plexus.components.interactivity.PrompterException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckDependencySnapshotsPhase
extends AbstractReleasePhase {
    public static final String RESOLVE_SNAPSHOT_MESSAGE = "There are still some remaining snapshot dependencies.\n";
    public static final String RESOLVE_SNAPSHOT_PROMPT = "Do you want to resolve them now?";
    public static final String RESOLVE_SNAPSHOT_TYPE_MESSAGE = "Dependency type to resolve,";
    public static final String RESOLVE_SNAPSHOT_TYPE_PROMPT = "specify the selection number ( 0:All 1:Project Dependencies 2:Plugins 3:Reports 4:Extensions ):";
    private Prompter prompter;
    private ArtifactFactory artifactFactory;
    private Set<Artifact> usedSnapshotDependencies = new HashSet<Artifact>();
    private Set<Artifact> usedSnapshotReports = new HashSet<Artifact>();
    private Set<Artifact> usedSnapshotExtensions = new HashSet<Artifact>();
    private Set<Artifact> usedSnapshotPlugins = new HashSet<Artifact>();

    @Override
    public ReleaseResult execute(ReleaseDescriptor releaseDescriptor, ReleaseEnvironment releaseEnvironment, List<MavenProject> reactorProjects) throws ReleaseExecutionException, ReleaseFailureException {
        ReleaseResult result = new ReleaseResult();
        if (!releaseDescriptor.isAllowTimestampedSnapshots()) {
            this.logInfo(result, "Checking dependencies and plugins for snapshots ...");
            Map<String, String> originalVersions = releaseDescriptor.getOriginalVersions(reactorProjects);
            for (MavenProject project : reactorProjects) {
                this.checkProject(project, originalVersions, releaseDescriptor);
            }
        } else {
            this.logInfo(result, "Ignoring SNAPSHOT depenedencies and plugins ...");
        }
        result.setResultCode(0);
        return result;
    }

    private void checkProject(MavenProject project, Map<String, String> originalVersions, ReleaseDescriptor releaseDescriptor) throws ReleaseFailureException, ReleaseExecutionException {
        Map artifactMap = ArtifactUtils.artifactMapByVersionlessId((Collection)project.getArtifacts());
        if (project.getParentArtifact() != null && CheckDependencySnapshotsPhase.checkArtifact(project.getParentArtifact(), originalVersions, artifactMap, releaseDescriptor)) {
            this.usedSnapshotDependencies.add(project.getParentArtifact());
        }
        try {
            Set dependencyArtifacts = project.createArtifacts(this.artifactFactory, null, null);
            this.checkDependencies(originalVersions, releaseDescriptor, artifactMap, dependencyArtifacts);
        }
        catch (InvalidDependencyVersionException e) {
            throw new ReleaseExecutionException("Failed to create dependency artifacts", e);
        }
        Set pluginArtifacts = project.getPluginArtifacts();
        this.checkPlugins(originalVersions, releaseDescriptor, artifactMap, pluginArtifacts);
        Set reportArtifacts = project.getReportArtifacts();
        this.checkReports(originalVersions, releaseDescriptor, artifactMap, reportArtifacts);
        Set extensionArtifacts = project.getExtensionArtifacts();
        this.checkExtensions(originalVersions, releaseDescriptor, artifactMap, extensionArtifacts);
        if (!(this.usedSnapshotDependencies.isEmpty() && this.usedSnapshotReports.isEmpty() && this.usedSnapshotExtensions.isEmpty() && this.usedSnapshotPlugins.isEmpty())) {
            if (releaseDescriptor.isInteractive()) {
                this.resolveSnapshots(this.usedSnapshotDependencies, this.usedSnapshotReports, this.usedSnapshotExtensions, this.usedSnapshotPlugins, releaseDescriptor);
            }
            if (!(this.usedSnapshotDependencies.isEmpty() && this.usedSnapshotReports.isEmpty() && this.usedSnapshotExtensions.isEmpty() && this.usedSnapshotPlugins.isEmpty())) {
                StringBuilder message = new StringBuilder();
                this.printSnapshotDependencies(this.usedSnapshotDependencies, message);
                this.printSnapshotDependencies(this.usedSnapshotReports, message);
                this.printSnapshotDependencies(this.usedSnapshotExtensions, message);
                this.printSnapshotDependencies(this.usedSnapshotPlugins, message);
                message.append("in project '" + project.getName() + "' (" + project.getId() + ")");
                throw new ReleaseFailureException("Can't release project due to non released dependencies :\n" + message);
            }
        }
    }

    private void checkPlugins(Map<String, String> originalVersions, ReleaseDescriptor releaseDescriptor, Map<String, Artifact> artifactMap, Set<Artifact> pluginArtifacts) throws ReleaseExecutionException {
        for (Artifact artifact : pluginArtifacts) {
            boolean addToFailures;
            if (!CheckDependencySnapshotsPhase.checkArtifact(artifact, originalVersions, artifactMap, releaseDescriptor)) continue;
            if ("org.apache.maven.plugins".equals(artifact.getGroupId()) && "maven-release-plugin".equals(artifact.getArtifactId())) {
                if (releaseDescriptor.isSnapshotReleasePluginAllowed()) {
                    addToFailures = false;
                } else if (releaseDescriptor.isInteractive()) {
                    try {
                        String result;
                        if (!releaseDescriptor.isSnapshotReleasePluginAllowed()) {
                            this.prompter.showMessage("This project relies on a SNAPSHOT of the release plugin. This may be necessary during testing.\n");
                            result = this.prompter.prompt("Do you want to continue with the release?", Arrays.asList("yes", "no"), "no");
                        } else {
                            result = "yes";
                        }
                        if (result.toLowerCase(Locale.ENGLISH).startsWith("y")) {
                            addToFailures = false;
                            releaseDescriptor.setSnapshotReleasePluginAllowed(true);
                        }
                        addToFailures = true;
                    }
                    catch (PrompterException e) {
                        throw new ReleaseExecutionException(e.getMessage(), e);
                    }
                } else {
                    addToFailures = true;
                }
            } else {
                addToFailures = true;
            }
            if (!addToFailures) continue;
            this.usedSnapshotPlugins.add(artifact);
        }
    }

    private void checkDependencies(Map<String, String> originalVersions, ReleaseDescriptor releaseDescriptor, Map<String, Artifact> artifactMap, Set<Artifact> dependencyArtifacts) {
        for (Artifact artifact : dependencyArtifacts) {
            if (!CheckDependencySnapshotsPhase.checkArtifact(artifact, originalVersions, artifactMap, releaseDescriptor)) continue;
            this.usedSnapshotDependencies.add(CheckDependencySnapshotsPhase.getArtifactFromMap(artifact, artifactMap));
        }
    }

    private void checkReports(Map<String, String> originalVersions, ReleaseDescriptor releaseDescriptor, Map<String, Artifact> artifactMap, Set<Artifact> reportArtifacts) {
        for (Artifact artifact : reportArtifacts) {
            if (!CheckDependencySnapshotsPhase.checkArtifact(artifact, originalVersions, artifactMap, releaseDescriptor)) continue;
            this.usedSnapshotReports.add(artifact);
        }
    }

    private void checkExtensions(Map<String, String> originalVersions, ReleaseDescriptor releaseDescriptor, Map<String, Artifact> artifactMap, Set<Artifact> extensionArtifacts) {
        for (Artifact artifact : extensionArtifacts) {
            if (!CheckDependencySnapshotsPhase.checkArtifact(artifact, originalVersions, artifactMap, releaseDescriptor)) continue;
            this.usedSnapshotExtensions.add(artifact);
        }
    }

    private static boolean checkArtifact(Artifact artifact, Map<String, String> originalVersions, Map<String, Artifact> artifactMapByVersionlessId, ReleaseDescriptor releaseDescriptor) {
        Artifact checkArtifact = CheckDependencySnapshotsPhase.getArtifactFromMap(artifact, artifactMapByVersionlessId);
        return CheckDependencySnapshotsPhase.checkArtifact(checkArtifact, originalVersions, releaseDescriptor);
    }

    private static Artifact getArtifactFromMap(Artifact artifact, Map<String, Artifact> artifactMapByVersionlessId) {
        String versionlessId = ArtifactUtils.versionlessKey((Artifact)artifact);
        Artifact checkArtifact = artifactMapByVersionlessId.get(versionlessId);
        if (checkArtifact == null) {
            checkArtifact = artifact;
        }
        return checkArtifact;
    }

    private static boolean checkArtifact(Artifact artifact, Map<String, String> originalVersions, ReleaseDescriptor releaseDescriptor) {
        boolean result;
        String versionlessArtifactKey = ArtifactUtils.versionlessKey((String)artifact.getGroupId(), (String)artifact.getArtifactId());
        boolean bl = result = artifact.isSnapshot() && !artifact.getBaseVersion().equals(originalVersions.get(versionlessArtifactKey));
        if (result && releaseDescriptor.isAllowTimestampedSnapshots()) {
            result = artifact.getVersion().indexOf("SNAPSHOT") >= 0;
        }
        return result;
    }

    @Override
    public ReleaseResult simulate(ReleaseDescriptor releaseDescriptor, ReleaseEnvironment releaseEnvironment, List<MavenProject> reactorProjects) throws ReleaseExecutionException, ReleaseFailureException {
        return this.execute(releaseDescriptor, releaseEnvironment, reactorProjects);
    }

    public void setPrompter(Prompter prompter) {
        this.prompter = prompter;
    }

    private StringBuilder printSnapshotDependencies(Set<Artifact> snapshotsSet, StringBuilder message) {
        ArrayList<Artifact> snapshotsList = new ArrayList<Artifact>(snapshotsSet);
        Collections.sort(snapshotsList);
        for (Artifact artifact : snapshotsList) {
            message.append("    ");
            message.append(artifact);
            message.append("\n");
        }
        return message;
    }

    private void resolveSnapshots(Set<Artifact> projectDependencies, Set<Artifact> reportDependencies, Set<Artifact> extensionDependencies, Set<Artifact> pluginDependencies, ReleaseDescriptor releaseDescriptor) throws ReleaseExecutionException {
        try {
            this.prompter.showMessage(RESOLVE_SNAPSHOT_MESSAGE);
            String result = this.prompter.prompt(RESOLVE_SNAPSHOT_PROMPT, Arrays.asList("yes", "no"), "no");
            if (result.toLowerCase(Locale.ENGLISH).startsWith("y")) {
                Map<String, Map<String, String>> resolvedSnapshots = null;
                this.prompter.showMessage(RESOLVE_SNAPSHOT_TYPE_MESSAGE);
                result = this.prompter.prompt(RESOLVE_SNAPSHOT_TYPE_PROMPT, Arrays.asList("0", "1", "2", "3"), "1");
                switch (Integer.parseInt(result.toLowerCase(Locale.ENGLISH))) {
                    case 0: {
                        resolvedSnapshots = this.processSnapshot(projectDependencies);
                        resolvedSnapshots.putAll(this.processSnapshot(pluginDependencies));
                        resolvedSnapshots.putAll(this.processSnapshot(reportDependencies));
                        resolvedSnapshots.putAll(this.processSnapshot(extensionDependencies));
                        break;
                    }
                    case 1: {
                        resolvedSnapshots = this.processSnapshot(projectDependencies);
                        break;
                    }
                    case 2: {
                        resolvedSnapshots = this.processSnapshot(pluginDependencies);
                        break;
                    }
                    case 3: {
                        resolvedSnapshots = this.processSnapshot(reportDependencies);
                        break;
                    }
                    case 4: {
                        resolvedSnapshots = this.processSnapshot(extensionDependencies);
                        break;
                    }
                }
                releaseDescriptor.getResolvedSnapshotDependencies().putAll(resolvedSnapshots);
            }
        }
        catch (PrompterException e) {
            throw new ReleaseExecutionException(e.getMessage(), e);
        }
        catch (VersionParseException e) {
            throw new ReleaseExecutionException(e.getMessage(), e);
        }
    }

    private Map<String, Map<String, String>> processSnapshot(Set<Artifact> snapshotSet) throws PrompterException, VersionParseException {
        HashMap<String, Map<String, String>> resolvedSnapshots = new HashMap<String, Map<String, String>>();
        Iterator<Artifact> iterator = snapshotSet.iterator();
        while (iterator.hasNext()) {
            Artifact currentArtifact = iterator.next();
            String versionlessKey = ArtifactUtils.versionlessKey((Artifact)currentArtifact);
            HashMap<String, String> versionMap = new HashMap<String, String>();
            DefaultVersionInfo versionInfo = new DefaultVersionInfo(currentArtifact.getVersion());
            versionMap.put("original", ((Object)versionInfo).toString());
            this.prompter.showMessage("Dependency '" + versionlessKey + "' is a snapshot (" + currentArtifact.getVersion() + ")\n");
            String result = this.prompter.prompt("Which release version should it be set to?", versionInfo.getReleaseVersionString());
            versionMap.put("rel", result);
            iterator.remove();
            DefaultVersionInfo nextVersionInfo = new DefaultVersionInfo(result);
            String nextVersion = nextVersionInfo.compareTo(versionInfo) > 0 ? ((Object)nextVersionInfo).toString() : ((Object)versionInfo).toString();
            result = this.prompter.prompt("What version should the dependency be reset to for development?", nextVersion);
            versionMap.put("dev", result);
            resolvedSnapshots.put(versionlessKey, versionMap);
        }
        return resolvedSnapshots;
    }
}

