/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.report.projectinfo;

import java.util.Locale;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.model.DistributionManagement;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.project.MavenProject;
import org.apache.maven.report.projectinfo.AbstractProjectInfoRenderer;
import org.apache.maven.report.projectinfo.AbstractProjectInfoReport;
import org.codehaus.plexus.i18n.I18N;
import org.codehaus.plexus.util.StringUtils;

@Mojo(name="distribution-management")
public class DistributionManagementReport
extends AbstractProjectInfoReport {
    public boolean canGenerateReport() {
        boolean result = super.canGenerateReport();
        if (result && this.skipEmptyReport) {
            result = this.getProject().getDistributionManagement() != null;
        }
        return result;
    }

    public void executeReport(Locale locale) {
        DistributionManagementRenderer r = new DistributionManagementRenderer(this.getSink(), this.getProject(), this.getI18N(locale), locale);
        r.render();
    }

    public String getOutputName() {
        return "distribution-management";
    }

    protected String getI18Nsection() {
        return "distributionManagement";
    }

    private static class DistributionManagementRenderer
    extends AbstractProjectInfoRenderer {
        private final MavenProject project;

        DistributionManagementRenderer(Sink sink, MavenProject project, I18N i18n, Locale locale) {
            super(sink, i18n, locale);
            this.project = project;
        }

        protected String getI18Nsection() {
            return "distributionManagement";
        }

        public void renderBody() {
            DistributionManagement distributionManagement = this.project.getDistributionManagement();
            if (distributionManagement == null) {
                this.startSection(this.getI18nString("overview.title"));
                this.paragraph(this.getI18nString("nodistributionmanagement"));
                this.endSection();
                return;
            }
            this.startSection(this.getI18nString("overview.title"));
            this.paragraph(this.getI18nString("overview.intro"));
            if (StringUtils.isNotEmpty((String)distributionManagement.getDownloadUrl())) {
                this.startSection(this.getI18nString("downloadURL"));
                this.internalLink(distributionManagement.getDownloadUrl());
                this.endSection();
            }
            if (distributionManagement.getRelocation() != null) {
                this.startSection(this.getI18nString("relocation"));
                this.startTable();
                this.tableHeader(new String[]{this.getI18nString("field"), this.getI18nString("value")});
                this.tableRow(new String[]{this.getI18nString("relocation.groupid"), distributionManagement.getRelocation().getGroupId()});
                this.tableRow(new String[]{this.getI18nString("relocation.artifactid"), distributionManagement.getRelocation().getArtifactId()});
                this.tableRow(new String[]{this.getI18nString("relocation.version"), distributionManagement.getRelocation().getVersion()});
                this.tableRow(new String[]{this.getI18nString("relocation.message"), distributionManagement.getRelocation().getMessage()});
                this.endTable();
                this.endSection();
            }
            if (distributionManagement.getRepository() != null && StringUtils.isNotEmpty((String)distributionManagement.getRepository().getUrl())) {
                this.startSection(this.getI18nString("repository") + this.getRepoName(distributionManagement.getRepository().getId()));
                this.internalLink(distributionManagement.getRepository().getUrl());
                this.endSection();
            }
            if (distributionManagement.getSnapshotRepository() != null && StringUtils.isNotEmpty((String)distributionManagement.getSnapshotRepository().getUrl())) {
                this.startSection(this.getI18nString("snapshotRepository") + this.getRepoName(distributionManagement.getSnapshotRepository().getId()));
                this.internalLink(distributionManagement.getSnapshotRepository().getUrl());
                this.endSection();
            }
            if (distributionManagement.getSite() != null && StringUtils.isNotEmpty((String)distributionManagement.getSite().getUrl())) {
                this.startSection(this.getI18nString("site") + this.getRepoName(distributionManagement.getSite().getId()));
                this.internalLink(distributionManagement.getSite().getUrl());
                this.endSection();
            }
            this.endSection();
        }

        private void internalLink(String url) {
            if (StringUtils.isEmpty((String)url)) {
                return;
            }
            String urlLowerCase = url.trim().toLowerCase(Locale.ENGLISH);
            if (urlLowerCase.startsWith("http") || urlLowerCase.startsWith("https") || urlLowerCase.startsWith("ftp")) {
                this.link(url, url);
            } else {
                this.paragraph(url);
            }
        }

        private String getRepoName(String name) {
            if (StringUtils.isNotEmpty((String)name)) {
                return " - " + name;
            }
            return "";
        }
    }
}

