/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.report.projectinfo.dependencies.renderer;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.License;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.report.projectinfo.AbstractProjectInfoRenderer;
import org.apache.maven.report.projectinfo.ProjectInfoReportUtils;
import org.apache.maven.report.projectinfo.dependencies.ManagementDependencies;
import org.apache.maven.report.projectinfo.dependencies.RepositoryUtils;
import org.codehaus.plexus.i18n.I18N;
import org.codehaus.plexus.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DependencyManagementRenderer
extends AbstractProjectInfoRenderer {
    private final ManagementDependencies dependencies;
    private final Log log;
    private final ArtifactFactory artifactFactory;
    private final MavenProjectBuilder mavenProjectBuilder;
    private final List<ArtifactRepository> remoteRepositories;
    private final ArtifactRepository localRepository;
    private final RepositoryUtils repoUtils;

    public DependencyManagementRenderer(Sink sink, Locale locale, I18N i18n, Log log, ManagementDependencies dependencies, ArtifactFactory artifactFactory, MavenProjectBuilder mavenProjectBuilder, List<ArtifactRepository> remoteRepositories, ArtifactRepository localRepository, RepositoryUtils repoUtils) {
        super(sink, i18n, locale);
        this.log = log;
        this.dependencies = dependencies;
        this.artifactFactory = artifactFactory;
        this.mavenProjectBuilder = mavenProjectBuilder;
        this.remoteRepositories = remoteRepositories;
        this.localRepository = localRepository;
        this.repoUtils = repoUtils;
    }

    @Override
    protected String getI18Nsection() {
        return "dependencyManagement";
    }

    public void renderBody() {
        if (!this.dependencies.hasDependencies()) {
            this.startSection(this.getTitle());
            this.paragraph(this.getI18nString("nolist"));
            this.endSection();
            return;
        }
        this.renderSectionProjectDependencies();
    }

    private void renderSectionProjectDependencies() {
        this.startSection(this.getTitle());
        Map<String, List<Dependency>> dependenciesByScope = this.dependencies.getManagementDependenciesByScope();
        this.renderDependenciesForAllScopes(dependenciesByScope);
        this.endSection();
    }

    private void renderDependenciesForAllScopes(Map<String, List<Dependency>> dependenciesByScope) {
        this.renderDependenciesForScope("compile", dependenciesByScope.get("compile"));
        this.renderDependenciesForScope("runtime", dependenciesByScope.get("runtime"));
        this.renderDependenciesForScope("test", dependenciesByScope.get("test"));
        this.renderDependenciesForScope("provided", dependenciesByScope.get("provided"));
        this.renderDependenciesForScope("system", dependenciesByScope.get("system"));
    }

    private String[] getDependencyTableHeader(boolean hasClassifier) {
        String groupId = this.getI18nString("column.groupId");
        String artifactId = this.getI18nString("column.artifactId");
        String version = this.getI18nString("column.version");
        String classifier = this.getI18nString("column.classifier");
        String type = this.getI18nString("column.type");
        String license = this.getI18nString("column.license");
        if (hasClassifier) {
            return new String[]{groupId, artifactId, version, classifier, type, license};
        }
        return new String[]{groupId, artifactId, version, type, license};
    }

    private void renderDependenciesForScope(String scope, List<Dependency> artifacts) {
        if (artifacts != null) {
            Collections.sort(artifacts, this.getDependencyComparator());
            this.startSection(scope);
            this.paragraph(this.getI18nString("intro." + scope));
            this.startTable();
            boolean hasClassifier = false;
            for (Dependency dependency : artifacts) {
                if (!StringUtils.isNotEmpty((String)dependency.getClassifier())) continue;
                hasClassifier = true;
                break;
            }
            String[] tableHeader = this.getDependencyTableHeader(hasClassifier);
            this.tableHeader(tableHeader);
            for (Dependency dependency : artifacts) {
                this.tableRow(this.getDependencyRow(dependency, hasClassifier));
            }
            this.endTable();
            this.endSection();
        }
    }

    private String[] getDependencyRow(Dependency dependency, boolean hasClassifier) {
        Artifact artifact = this.artifactFactory.createParentArtifact(dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion());
        String url = ProjectInfoReportUtils.getArtifactUrl(this.artifactFactory, artifact, this.mavenProjectBuilder, this.remoteRepositories, this.localRepository);
        String artifactIdCell = ProjectInfoReportUtils.getArtifactIdCell(artifact.getArtifactId(), url);
        StringBuffer sb = new StringBuffer();
        try {
            MavenProject artifactProject = this.repoUtils.getMavenProjectFromRepository(artifact);
            List licenses = artifactProject.getLicenses();
            for (License license : licenses) {
                String artifactIdCell2 = ProjectInfoReportUtils.getArtifactIdCell(license.getName(), license.getUrl());
                sb.append(artifactIdCell2);
            }
        }
        catch (ProjectBuildingException e) {
            this.log.warn((CharSequence)"Unable to create Maven project from repository.", (Throwable)e);
        }
        if (hasClassifier) {
            return new String[]{dependency.getGroupId(), artifactIdCell, dependency.getVersion(), dependency.getClassifier(), dependency.getType(), sb.toString()};
        }
        return new String[]{dependency.getGroupId(), artifactIdCell, dependency.getVersion(), dependency.getType(), sb.toString()};
    }

    private Comparator<Dependency> getDependencyComparator() {
        return new Comparator<Dependency>(){

            @Override
            public int compare(Dependency a1, Dependency a2) {
                int result = a1.getGroupId().compareTo(a2.getGroupId());
                if (result == 0 && (result = a1.getArtifactId().compareTo(a2.getArtifactId())) == 0 && (result = a1.getType().compareTo(a2.getType())) == 0) {
                    if (a1.getClassifier() == null) {
                        if (a2.getClassifier() != null) {
                            result = 1;
                        }
                    } else {
                        result = a2.getClassifier() != null ? a1.getClassifier().compareTo(a2.getClassifier()) : -1;
                    }
                    if (result == 0) {
                        result = a1.getVersion().compareTo(a2.getVersion());
                    }
                }
                return result;
            }
        };
    }
}

