/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.ear;

import org.codehaus.plexus.util.xml.XMLWriter;

class SecurityRole {
    protected static final String SECURITY_ROLE = "security-role";
    protected static final String ID_ATTRIBUTE = "id";
    protected static final String DESCRIPTION = "description";
    protected static final String ROLE_NAME = "role-name";
    private final String roleName;
    private final String roleNameId;
    private final String roleId;
    private final String description;
    private final String descriptionId;

    SecurityRole(String roleName, String roleNameId, String roleId, String description, String descriptionId) {
        if (roleName == null) {
            throw new NullPointerException("role-name in security-role element could not be null.");
        }
        this.roleName = roleName;
        this.roleNameId = roleNameId;
        this.roleId = roleId;
        this.description = description;
        this.descriptionId = descriptionId;
    }

    public String getRoleName() {
        return this.roleName;
    }

    public String getRoleNameId() {
        return this.roleNameId;
    }

    public String getRoleId() {
        return this.roleId;
    }

    public String getDescription() {
        return this.description;
    }

    public String getDescriptionId() {
        return this.descriptionId;
    }

    public void appendSecurityRole(XMLWriter writer) {
        writer.startElement(SECURITY_ROLE);
        if (this.getRoleId() != null) {
            writer.addAttribute(ID_ATTRIBUTE, this.getRoleId());
        }
        if (this.getDescription() != null) {
            writer.startElement(DESCRIPTION);
            if (this.getDescriptionId() != null) {
                writer.addAttribute(ID_ATTRIBUTE, this.getDescriptionId());
            }
            writer.writeText(this.getDescription());
            writer.endElement();
        }
        writer.startElement(ROLE_NAME);
        if (this.getRoleNameId() != null) {
            writer.addAttribute(ID_ATTRIBUTE, this.getRoleNameId());
        }
        writer.writeText(this.getRoleName());
        writer.endElement();
        writer.endElement();
    }

    public String toString() {
        return "Security role " + this.getRoleName();
    }
}

