/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.dependency.fromDependencies;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugins.dependency.fromDependencies.DependencyMatcher;

class OrDependencyMatcher
implements DependencyMatcher {
    private Collection<DependencyMatcher> matchers;

    OrDependencyMatcher(Collection<DependencyMatcher> matchers) {
        this.matchers = new ArrayList<DependencyMatcher>(this.validate(matchers));
    }

    private Collection<DependencyMatcher> validate(Collection<DependencyMatcher> matchers) {
        if (matchers == null || matchers.isEmpty()) {
            throw new IllegalArgumentException("There must be at least 1 dependencyMatcher");
        }
        return matchers;
    }

    @Override
    public boolean matches(Dependency dependency) {
        for (DependencyMatcher matcher : this.matchers) {
            if (!matcher.matches(dependency)) continue;
            return true;
        }
        return false;
    }
}

