/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.assembly.archive.task;

import java.io.File;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.model.Model;
import org.apache.maven.plugins.assembly.AssemblerConfigurationSource;
import org.apache.maven.plugins.assembly.InvalidAssemblerConfigurationException;
import org.apache.maven.plugins.assembly.archive.ArchiveCreationException;
import org.apache.maven.plugins.assembly.archive.task.AddArtifactTask;
import org.apache.maven.plugins.assembly.format.AssemblyFormattingException;
import org.apache.maven.plugins.assembly.format.ReaderFormatter;
import org.apache.maven.plugins.assembly.model.DependencySet;
import org.apache.maven.plugins.assembly.model.UnpackOptions;
import org.apache.maven.plugins.assembly.utils.AssemblyFormatUtils;
import org.apache.maven.plugins.assembly.utils.FilterUtils;
import org.apache.maven.plugins.assembly.utils.TypeConversionUtils;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.project.ProjectBuildingResult;
import org.apache.maven.shared.artifact.filter.resolve.ScopeFilter;
import org.apache.maven.shared.artifact.filter.resolve.transform.ArtifactIncludeFilterTransformer;
import org.codehaus.plexus.archiver.Archiver;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.components.io.functions.InputStreamTransformer;
import org.codehaus.plexus.interpolation.fixed.FixedStringSearchInterpolator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddDependencySetsTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(AddDependencySetsTask.class);
    private static final List<String> NON_ARCHIVE_DEPENDENCY_TYPES;
    private final List<DependencySet> dependencySets;
    private final MavenProject project;
    private final ProjectBuilder projectBuilder1;
    private final Set<Artifact> resolvedArtifacts;
    private MavenProject moduleProject;
    private String defaultOutputDirectory;
    private String defaultOutputFileNameMapping;
    private Artifact moduleArtifact;

    public AddDependencySetsTask(List<DependencySet> dependencySets, Set<Artifact> resolvedArtifacts, MavenProject project, ProjectBuilder projectBuilder) {
        this.dependencySets = dependencySets;
        this.resolvedArtifacts = resolvedArtifacts;
        this.project = project;
        this.projectBuilder1 = projectBuilder;
    }

    public void execute(Archiver archiver, AssemblerConfigurationSource configSource) throws ArchiveCreationException, AssemblyFormattingException, InvalidAssemblerConfigurationException {
        if (this.dependencySets == null || this.dependencySets.isEmpty()) {
            LOGGER.debug("No dependency sets specified.");
            return;
        }
        List deps = this.project.getDependencies();
        if (deps == null || deps.isEmpty()) {
            LOGGER.debug("Project " + this.project.getId() + " has no dependencies. Skipping dependency set addition.");
        }
        for (DependencySet dependencySet : this.dependencySets) {
            this.addDependencySet(dependencySet, archiver, configSource);
        }
    }

    void addDependencySet(DependencySet dependencySet, Archiver archiver, AssemblerConfigurationSource configSource) throws AssemblyFormattingException, ArchiveCreationException, InvalidAssemblerConfigurationException {
        LOGGER.debug("Processing DependencySet (output=" + dependencySet.getOutputDirectory() + ")");
        if (!dependencySet.isUseTransitiveDependencies() && dependencySet.isUseTransitiveFiltering()) {
            LOGGER.warn("DependencySet has nonsensical configuration: useTransitiveDependencies == false AND useTransitiveFiltering == true. Transitive filtering flag will be ignored.");
        }
        Set<Artifact> dependencyArtifacts = this.resolveDependencyArtifacts(dependencySet);
        if (!this.unpackTransformsContent(dependencySet) && dependencyArtifacts.size() > 1) {
            this.checkMultiArtifactOutputConfig(dependencySet);
        }
        LOGGER.debug("Adding " + dependencyArtifacts.size() + " dependency artifacts.");
        UnpackOptions unpackOptions = dependencySet.getUnpackOptions();
        InputStreamTransformer fileSetTransformers = this.isUnpackWithOptions(dependencySet) ? ReaderFormatter.getFileSetTransformers(configSource, unpackOptions.isFiltered(), new HashSet<String>(unpackOptions.getNonFilteredFileExtensions()), unpackOptions.getLineEnding()) : null;
        for (Artifact depArtifact : dependencyArtifacts) {
            MavenProject depProject;
            ProjectBuildingRequest pbr = this.getProjectBuildingRequest(configSource);
            try {
                ProjectBuildingResult build = this.projectBuilder1.build(depArtifact, pbr);
                depProject = build.getProject();
            }
            catch (ProjectBuildingException e) {
                LOGGER.debug("Error retrieving POM of module-dependency: " + depArtifact.getId() + "; Reason: " + e.getMessage() + "\n\nBuilding stub project instance.");
                depProject = this.buildProjectStub(depArtifact);
            }
            if (NON_ARCHIVE_DEPENDENCY_TYPES.contains(depArtifact.getType())) {
                this.addNonArchiveDependency(depArtifact, depProject, dependencySet, archiver, configSource);
                continue;
            }
            this.addNormalArtifact(dependencySet, depArtifact, depProject, archiver, configSource, fileSetTransformers);
        }
    }

    private ProjectBuildingRequest getProjectBuildingRequest(AssemblerConfigurationSource configSource) {
        return new DefaultProjectBuildingRequest(configSource.getMavenSession().getProjectBuildingRequest()).setValidationLevel(0).setProcessPlugins(false);
    }

    private boolean isUnpackWithOptions(DependencySet dependencySet) {
        return dependencySet.isUnpack() && dependencySet.getUnpackOptions() != null;
    }

    private boolean unpackTransformsContent(DependencySet dependencySet) {
        return this.isUnpackWithOptions(dependencySet) && this.isContentModifyingOption(dependencySet.getUnpackOptions());
    }

    private boolean isContentModifyingOption(UnpackOptions opts) {
        return opts.isFiltered() || opts.getLineEnding() != null;
    }

    private void checkMultiArtifactOutputConfig(DependencySet dependencySet) {
        String mapping;
        String dir = dependencySet.getOutputDirectory();
        if (dir == null) {
            dir = this.defaultOutputDirectory;
        }
        if ((mapping = dependencySet.getOutputFileNameMapping()) == null) {
            mapping = this.defaultOutputFileNameMapping;
        }
        if (!(dir != null && dir.contains("${") || mapping != null && mapping.contains("${"))) {
            LOGGER.warn("NOTE: Your assembly specifies a dependencySet that matches multiple artifacts, but specifies a concrete output format. THIS MAY RESULT IN ONE OR MORE ARTIFACTS BEING OBSCURED!\n\nOutput directory: '" + dir + "'\nOutput filename mapping: '" + mapping + "'");
        }
    }

    private void addNormalArtifact(DependencySet dependencySet, Artifact depArtifact, MavenProject depProject, Archiver archiver, AssemblerConfigurationSource configSource, InputStreamTransformer fileSetTransformers) throws AssemblyFormattingException, ArchiveCreationException {
        int fileMode;
        LOGGER.debug("Adding dependency artifact " + depArtifact.getId() + ".");
        String encoding = this.isUnpackWithOptions(dependencySet) ? dependencySet.getUnpackOptions().getEncoding() : null;
        Charset charset = encoding != null ? Charset.forName(encoding) : null;
        AddArtifactTask task = new AddArtifactTask(depArtifact, fileSetTransformers, charset);
        task.setProject(depProject);
        task.setModuleProject(this.moduleProject);
        task.setModuleArtifact(this.moduleArtifact);
        task.setOutputDirectory(dependencySet.getOutputDirectory(), this.defaultOutputDirectory);
        task.setFileNameMapping(dependencySet.getOutputFileNameMapping(), this.defaultOutputFileNameMapping);
        int dirMode = TypeConversionUtils.modeToInt(dependencySet.getDirectoryMode(), LOGGER);
        if (dirMode != -1) {
            task.setDirectoryMode(dirMode);
        }
        if ((fileMode = TypeConversionUtils.modeToInt(dependencySet.getFileMode(), LOGGER)) != -1) {
            task.setFileMode(fileMode);
        }
        task.setUnpack(dependencySet.isUnpack());
        UnpackOptions opts = dependencySet.getUnpackOptions();
        if (this.isUnpackWithOptions(dependencySet)) {
            task.setIncludes(opts.getIncludes());
            task.setExcludes(opts.getExcludes());
            task.setUsingDefaultExcludes(opts.isUseDefaultExcludes());
        }
        task.execute(archiver, configSource);
    }

    private MavenProject buildProjectStub(Artifact depArtifact) {
        Model model = new Model();
        model.setGroupId(depArtifact.getGroupId());
        model.setArtifactId(depArtifact.getArtifactId());
        model.setVersion(depArtifact.getBaseVersion());
        model.setPackaging(depArtifact.getType());
        model.setDescription("Stub for " + depArtifact.getId());
        MavenProject project = new MavenProject(model);
        project.setArtifact(depArtifact);
        return project;
    }

    Set<Artifact> resolveDependencyArtifacts(DependencySet dependencySet) throws InvalidAssemblerConfigurationException {
        List attachments;
        LinkedHashSet<Artifact> dependencyArtifacts = new LinkedHashSet<Artifact>();
        if (this.resolvedArtifacts != null) {
            dependencyArtifacts.addAll(this.resolvedArtifacts);
        }
        if (dependencySet.isUseProjectArtifact()) {
            Artifact projectArtifact = this.project.getArtifact();
            if (projectArtifact != null && projectArtifact.getFile() != null) {
                dependencyArtifacts.add(projectArtifact);
            } else {
                LOGGER.warn("Cannot include project artifact: " + projectArtifact + "; it doesn't have an associated file or directory.");
            }
        }
        if (dependencySet.isUseProjectAttachments() && (attachments = this.project.getAttachedArtifacts()) != null) {
            for (Artifact attachment : attachments) {
                if (attachment.getFile() != null) {
                    dependencyArtifacts.add(attachment);
                    continue;
                }
                LOGGER.warn("Cannot include attached artifact: " + this.project.getId() + " for project: " + this.project.getId() + "; it doesn't have an associated file or directory.");
            }
        }
        if (dependencySet.isUseTransitiveFiltering()) {
            LOGGER.debug("Filtering dependency artifacts USING transitive dependency path information.");
        } else {
            LOGGER.debug("Filtering dependency artifacts WITHOUT transitive dependency path information.");
        }
        ScopeFilter scopeFilter = FilterUtils.newScopeFilter(dependencySet.getScope());
        ArtifactFilter filter = new ArtifactIncludeFilterTransformer().transform(scopeFilter);
        FilterUtils.filterArtifacts(dependencyArtifacts, dependencySet.getIncludes(), dependencySet.getExcludes(), dependencySet.isUseStrictFiltering(), dependencySet.isUseTransitiveFiltering(), LOGGER, filter);
        return dependencyArtifacts;
    }

    private void addNonArchiveDependency(Artifact depArtifact, MavenProject depProject, DependencySet dependencySet, Archiver archiver, AssemblerConfigurationSource configSource) throws AssemblyFormattingException, ArchiveCreationException {
        File source = depArtifact.getFile();
        String outputDirectory = dependencySet.getOutputDirectory();
        FixedStringSearchInterpolator moduleProjectInterpolator = AssemblyFormatUtils.moduleProjectInterpolator(this.moduleProject);
        FixedStringSearchInterpolator artifactProjectInterpolator = AssemblyFormatUtils.artifactProjectInterpolator(depProject);
        outputDirectory = AssemblyFormatUtils.getOutputDirectory(outputDirectory, depProject.getBuild().getFinalName(), configSource, moduleProjectInterpolator, artifactProjectInterpolator);
        String destName = AssemblyFormatUtils.evaluateFileNameMapping(dependencySet.getOutputFileNameMapping(), depArtifact, configSource.getProject(), this.moduleArtifact, configSource, moduleProjectInterpolator, artifactProjectInterpolator);
        String target = outputDirectory.endsWith("/") || outputDirectory.endsWith("\\") ? outputDirectory + destName : outputDirectory + "/" + destName;
        try {
            int mode = TypeConversionUtils.modeToInt(dependencySet.getFileMode(), LOGGER);
            if (mode > -1) {
                archiver.addFile(source, target, mode);
            } else {
                archiver.addFile(source, target);
            }
        }
        catch (ArchiverException e) {
            throw new ArchiveCreationException("Error adding file to archive: " + e.getMessage(), e);
        }
    }

    public List<DependencySet> getDependencySets() {
        return this.dependencySets;
    }

    public void setDefaultOutputDirectory(String defaultOutputDirectory) {
        this.defaultOutputDirectory = defaultOutputDirectory;
    }

    public void setDefaultOutputFileNameMapping(String defaultOutputFileNameMapping) {
        this.defaultOutputFileNameMapping = defaultOutputFileNameMapping;
    }

    public void setModuleProject(MavenProject moduleProject) {
        this.moduleProject = moduleProject;
    }

    public void setModuleArtifact(Artifact moduleArtifact) {
        this.moduleArtifact = moduleArtifact;
    }

    static {
        ArrayList<String> nonArch = new ArrayList<String>();
        nonArch.add("pom");
        NON_ARCHIVE_DEPENDENCY_TYPES = Collections.unmodifiableList(nonArch);
    }
}

