/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.tools.model.io.xpp3;

import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.util.Iterator;
import org.apache.maven.plugin.tools.model.Component;
import org.apache.maven.plugin.tools.model.LifecycleExecution;
import org.apache.maven.plugin.tools.model.Mojo;
import org.apache.maven.plugin.tools.model.Parameter;
import org.apache.maven.plugin.tools.model.PluginMetadata;
import org.codehaus.plexus.util.xml.pull.MXSerializer;
import org.codehaus.plexus.util.xml.pull.XmlSerializer;

public class PluginMetadataXpp3Writer {
    private static final String NAMESPACE = null;

    public void write(Writer writer, PluginMetadata pluginMetadata) throws IOException {
        MXSerializer serializer = new MXSerializer();
        serializer.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-indentation", (Object)"  ");
        serializer.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-line-separator", (Object)"\n");
        serializer.setOutput(writer);
        serializer.startDocument(pluginMetadata.getModelEncoding(), null);
        this.writePluginMetadata(pluginMetadata, "pluginMetadata", (XmlSerializer)serializer);
        serializer.endDocument();
    }

    private void writeComponent(Component component, String tagName, XmlSerializer serializer) throws IOException {
        if (component != null) {
            serializer.startTag(NAMESPACE, tagName);
            if (component.getRole() != null) {
                serializer.startTag(NAMESPACE, "role").text(component.getRole()).endTag(NAMESPACE, "role");
            }
            if (component.getHint() != null) {
                serializer.startTag(NAMESPACE, "hint").text(component.getHint()).endTag(NAMESPACE, "hint");
            }
            serializer.endTag(NAMESPACE, tagName);
        }
    }

    private void writeLifecycleExecution(LifecycleExecution lifecycleExecution, String tagName, XmlSerializer serializer) throws IOException {
        if (lifecycleExecution != null) {
            serializer.startTag(NAMESPACE, tagName);
            if (lifecycleExecution.getLifecycle() != null) {
                serializer.startTag(NAMESPACE, "lifecycle").text(lifecycleExecution.getLifecycle()).endTag(NAMESPACE, "lifecycle");
            }
            if (lifecycleExecution.getPhase() != null) {
                serializer.startTag(NAMESPACE, "phase").text(lifecycleExecution.getPhase()).endTag(NAMESPACE, "phase");
            }
            if (lifecycleExecution.getGoal() != null) {
                serializer.startTag(NAMESPACE, "goal").text(lifecycleExecution.getGoal()).endTag(NAMESPACE, "goal");
            }
            serializer.endTag(NAMESPACE, tagName);
        }
    }

    private void writeMojo(Mojo mojo, String tagName, XmlSerializer serializer) throws IOException {
        if (mojo != null) {
            Serializable o;
            Iterator iter;
            serializer.startTag(NAMESPACE, tagName);
            if (mojo.getGoal() != null) {
                serializer.startTag(NAMESPACE, "goal").text(mojo.getGoal()).endTag(NAMESPACE, "goal");
            }
            if (mojo.getPhase() != null) {
                serializer.startTag(NAMESPACE, "phase").text(mojo.getPhase()).endTag(NAMESPACE, "phase");
            }
            if (mojo.isAggregator()) {
                serializer.startTag(NAMESPACE, "aggregator").text(String.valueOf(mojo.isAggregator())).endTag(NAMESPACE, "aggregator");
            }
            if (mojo.getRequiresDependencyResolution() != null) {
                serializer.startTag(NAMESPACE, "requiresDependencyResolution").text(mojo.getRequiresDependencyResolution()).endTag(NAMESPACE, "requiresDependencyResolution");
            }
            if (mojo.isRequiresProject()) {
                serializer.startTag(NAMESPACE, "requiresProject").text(String.valueOf(mojo.isRequiresProject())).endTag(NAMESPACE, "requiresProject");
            }
            if (mojo.isRequiresReports()) {
                serializer.startTag(NAMESPACE, "requiresReports").text(String.valueOf(mojo.isRequiresReports())).endTag(NAMESPACE, "requiresReports");
            }
            if (mojo.isRequiresOnline()) {
                serializer.startTag(NAMESPACE, "requiresOnline").text(String.valueOf(mojo.isRequiresOnline())).endTag(NAMESPACE, "requiresOnline");
            }
            if (mojo.isInheritByDefault()) {
                serializer.startTag(NAMESPACE, "inheritByDefault").text(String.valueOf(mojo.isInheritByDefault())).endTag(NAMESPACE, "inheritByDefault");
            }
            if (mojo.isRequiresDirectInvocation()) {
                serializer.startTag(NAMESPACE, "requiresDirectInvocation").text(String.valueOf(mojo.isRequiresDirectInvocation())).endTag(NAMESPACE, "requiresDirectInvocation");
            }
            if (mojo.getExecution() != null) {
                this.writeLifecycleExecution(mojo.getExecution(), "execution", serializer);
            }
            if (mojo.getComponents() != null && mojo.getComponents().size() > 0) {
                serializer.startTag(NAMESPACE, "components");
                iter = mojo.getComponents().iterator();
                while (iter.hasNext()) {
                    o = (Component)iter.next();
                    this.writeComponent((Component)o, "component", serializer);
                }
                serializer.endTag(NAMESPACE, "components");
            }
            if (mojo.getParameters() != null && mojo.getParameters().size() > 0) {
                serializer.startTag(NAMESPACE, "parameters");
                iter = mojo.getParameters().iterator();
                while (iter.hasNext()) {
                    o = (Parameter)iter.next();
                    this.writeParameter((Parameter)o, "parameter", serializer);
                }
                serializer.endTag(NAMESPACE, "parameters");
            }
            if (mojo.getDescription() != null) {
                serializer.startTag(NAMESPACE, "description").text(mojo.getDescription()).endTag(NAMESPACE, "description");
            }
            if (mojo.getDeprecation() != null) {
                serializer.startTag(NAMESPACE, "deprecated").text(mojo.getDeprecation()).endTag(NAMESPACE, "deprecated");
            }
            if (mojo.getCall() != null) {
                serializer.startTag(NAMESPACE, "call").text(mojo.getCall()).endTag(NAMESPACE, "call");
            }
            serializer.endTag(NAMESPACE, tagName);
        }
    }

    private void writeParameter(Parameter parameter, String tagName, XmlSerializer serializer) throws IOException {
        if (parameter != null) {
            serializer.startTag(NAMESPACE, tagName);
            if (parameter.getName() != null) {
                serializer.startTag(NAMESPACE, "name").text(parameter.getName()).endTag(NAMESPACE, "name");
            }
            if (parameter.getAlias() != null) {
                serializer.startTag(NAMESPACE, "alias").text(parameter.getAlias()).endTag(NAMESPACE, "alias");
            }
            if (parameter.getProperty() != null) {
                serializer.startTag(NAMESPACE, "property").text(parameter.getProperty()).endTag(NAMESPACE, "property");
            }
            if (parameter.isRequired()) {
                serializer.startTag(NAMESPACE, "required").text(String.valueOf(parameter.isRequired())).endTag(NAMESPACE, "required");
            }
            if (parameter.isReadonly()) {
                serializer.startTag(NAMESPACE, "readonly").text(String.valueOf(parameter.isReadonly())).endTag(NAMESPACE, "readonly");
            }
            if (parameter.getExpression() != null) {
                serializer.startTag(NAMESPACE, "expression").text(parameter.getExpression()).endTag(NAMESPACE, "expression");
            }
            if (parameter.getDefaultValue() != null) {
                serializer.startTag(NAMESPACE, "defaultValue").text(parameter.getDefaultValue()).endTag(NAMESPACE, "defaultValue");
            }
            if (parameter.getType() != null) {
                serializer.startTag(NAMESPACE, "type").text(parameter.getType()).endTag(NAMESPACE, "type");
            }
            if (parameter.getDescription() != null) {
                serializer.startTag(NAMESPACE, "description").text(parameter.getDescription()).endTag(NAMESPACE, "description");
            }
            if (parameter.getDeprecation() != null) {
                serializer.startTag(NAMESPACE, "deprecated").text(parameter.getDeprecation()).endTag(NAMESPACE, "deprecated");
            }
            serializer.endTag(NAMESPACE, tagName);
        }
    }

    private void writePluginMetadata(PluginMetadata pluginMetadata, String tagName, XmlSerializer serializer) throws IOException {
        if (pluginMetadata != null) {
            serializer.startTag(NAMESPACE, tagName);
            if (pluginMetadata.getMojos() != null && pluginMetadata.getMojos().size() > 0) {
                serializer.startTag(NAMESPACE, "mojos");
                Iterator iter = pluginMetadata.getMojos().iterator();
                while (iter.hasNext()) {
                    Mojo o = (Mojo)iter.next();
                    this.writeMojo(o, "mojo", serializer);
                }
                serializer.endTag(NAMESPACE, "mojos");
            }
            serializer.endTag(NAMESPACE, tagName);
        }
    }
}

