/*
 =================== DO NOT EDIT THIS FILE ====================
 Generated by Modello 1.4.1 on 2013-02-19 14:50:40,
 any modifications will be overwritten.
 ==============================================================
 */

package org.apache.maven.artifact.repository.metadata;

/**
 * Class Metadata.
 * 
 * @version $Revision$ $Date$
 */
@SuppressWarnings( "all" )
public class Metadata
    implements java.io.Serializable, java.lang.Cloneable
{

      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * The version of the underlying metadata model.
     */
    private String modelVersion;

    /**
     * The groupId that is directory represents, if any.
     */
    private String groupId;

    /**
     * The artifactId that is directory represents, if any.
     */
    private String artifactId;

    /**
     * The version that is directory represents, if any.
     */
    private String version;

    /**
     * Versioning information for the artifact.
     */
    private Versioning versioning;

    /**
     * Field plugins.
     */
    private java.util.List<Plugin> plugins;

    /**
     * Field modelEncoding.
     */
    private String modelEncoding = "UTF-8";


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method addPlugin.
     * 
     * @param plugin
     */
    public void addPlugin( Plugin plugin )
    {
        getPlugins().add( plugin );
    } //-- void addPlugin( Plugin )

    /**
     * Method clone.
     * 
     * @return Metadata
     */
    public Metadata clone()
    {
        try
        {
            Metadata copy = (Metadata) super.clone();

            if ( this.versioning != null )
            {
                copy.versioning = (Versioning) this.versioning.clone();
            }

            if ( this.plugins != null )
            {
                copy.plugins = new java.util.ArrayList<Plugin>();
                for ( Plugin item : this.plugins )
                {
                    copy.plugins.add( ( (Plugin) item).clone() );
                }
            }

            return copy;
        }
        catch ( java.lang.Exception ex )
        {
            throw (java.lang.RuntimeException) new java.lang.UnsupportedOperationException( getClass().getName()
                + " does not support clone()" ).initCause( ex );
        }
    } //-- Metadata clone()

    /**
     * Get the artifactId that is directory represents, if any.
     * 
     * @return String
     */
    public String getArtifactId()
    {
        return this.artifactId;
    } //-- String getArtifactId()

    /**
     * Get the groupId that is directory represents, if any.
     * 
     * @return String
     */
    public String getGroupId()
    {
        return this.groupId;
    } //-- String getGroupId()

    /**
     * Get the modelEncoding field.
     * 
     * @return String
     */
    public String getModelEncoding()
    {
        return this.modelEncoding;
    } //-- String getModelEncoding()

    /**
     * Get the version of the underlying metadata model.
     * 
     * @return String
     */
    public String getModelVersion()
    {
        return this.modelVersion;
    } //-- String getModelVersion()

    /**
     * Method getPlugins.
     * 
     * @return List
     */
    public java.util.List<Plugin> getPlugins()
    {
        if ( this.plugins == null )
        {
            this.plugins = new java.util.ArrayList<Plugin>();
        }

        return this.plugins;
    } //-- java.util.List<Plugin> getPlugins()

    /**
     * Get the version that is directory represents, if any.
     * 
     * @return String
     */
    public String getVersion()
    {
        return this.version;
    } //-- String getVersion()

    /**
     * Get versioning information for the artifact.
     * 
     * @return Versioning
     */
    public Versioning getVersioning()
    {
        return this.versioning;
    } //-- Versioning getVersioning()

    /**
     * Method removePlugin.
     * 
     * @param plugin
     */
    public void removePlugin( Plugin plugin )
    {
        getPlugins().remove( plugin );
    } //-- void removePlugin( Plugin )

    /**
     * Set the artifactId that is directory represents, if any.
     * 
     * @param artifactId
     */
    public void setArtifactId( String artifactId )
    {
        this.artifactId = artifactId;
    } //-- void setArtifactId( String )

    /**
     * Set the groupId that is directory represents, if any.
     * 
     * @param groupId
     */
    public void setGroupId( String groupId )
    {
        this.groupId = groupId;
    } //-- void setGroupId( String )

    /**
     * Set the modelEncoding field.
     * 
     * @param modelEncoding
     */
    public void setModelEncoding( String modelEncoding )
    {
        this.modelEncoding = modelEncoding;
    } //-- void setModelEncoding( String )

    /**
     * Set the version of the underlying metadata model.
     * 
     * @param modelVersion
     */
    public void setModelVersion( String modelVersion )
    {
        this.modelVersion = modelVersion;
    } //-- void setModelVersion( String )

    /**
     * Set the set of plugin mappings for the group.
     * 
     * @param plugins
     */
    public void setPlugins( java.util.List<Plugin> plugins )
    {
        this.plugins = plugins;
    } //-- void setPlugins( java.util.List )

    /**
     * Set the version that is directory represents, if any.
     * 
     * @param version
     */
    public void setVersion( String version )
    {
        this.version = version;
    } //-- void setVersion( String )

    /**
     * Set versioning information for the artifact.
     * 
     * @param versioning
     */
    public void setVersioning( Versioning versioning )
    {
        this.versioning = versioning;
    } //-- void setVersioning( Versioning )

    
    public boolean merge( Metadata sourceMetadata )
    {
        boolean changed = false;

        for ( Plugin plugin : sourceMetadata.getPlugins() )
        {
            boolean found = false;

            for ( Plugin preExisting : getPlugins() )
            {
                if ( preExisting.getPrefix().equals( plugin.getPrefix() ) )
                {
                    found = true;
                    break;
                }
            }

            if ( !found )
            {
                Plugin mappedPlugin = new Plugin();

                mappedPlugin.setArtifactId( plugin.getArtifactId() );

                mappedPlugin.setPrefix( plugin.getPrefix() );

                mappedPlugin.setName( plugin.getName() );

                addPlugin( mappedPlugin );

                changed = true;
            }
        }

        Versioning versioning = sourceMetadata.getVersioning();
        if ( versioning != null )
        {
            Versioning v = getVersioning();
            if ( v == null )
            {
                v = new Versioning();
                setVersioning( v );
                changed = true;
            }

            for ( String version : versioning.getVersions() )
            {
                if ( !v.getVersions().contains( version ) )
                {
                    changed = true;
                    v.getVersions().add( version );
                }
            }

            if ( "null".equals( versioning.getLastUpdated() ) )
            {
                versioning.setLastUpdated( null );
            }

            if ( "null".equals( v.getLastUpdated() ) )
            {
                v.setLastUpdated( null );
            }

            if ( versioning.getLastUpdated() == null || versioning.getLastUpdated().length() == 0 )
            {
                // this should only be for historical reasons - we assume local is newer
                versioning.setLastUpdated( v.getLastUpdated() );
            }

            if ( v.getLastUpdated() == null || v.getLastUpdated().length() == 0
                 || versioning.getLastUpdated().compareTo( v.getLastUpdated() ) >= 0 )
            {
                changed = true;
                v.setLastUpdated( versioning.getLastUpdated() );

                if ( versioning.getRelease() != null )
                {
                    changed = true;
                    v.setRelease( versioning.getRelease() );
                }
                if ( versioning.getLatest() != null )
                {
                    changed = true;
                    v.setLatest( versioning.getLatest() );
                }

                Snapshot s = v.getSnapshot();
                Snapshot snapshot = versioning.getSnapshot();
                if ( snapshot != null )
                {
                    if ( s == null )
                    {
                        s = new Snapshot();
                        v.setSnapshot( s );
                        changed = true;
                    }

                    // overwrite
                    if ( s.getTimestamp() == null ? snapshot.getTimestamp() != null
                        : !s.getTimestamp().equals( snapshot.getTimestamp() ) )
                    {
                        s.setTimestamp( snapshot.getTimestamp() );
                        changed = true;
                    }
                    if ( s.getBuildNumber() != snapshot.getBuildNumber() )
                    {
                        s.setBuildNumber( snapshot.getBuildNumber() );
                        changed = true;
                    }
                    if ( s.isLocalCopy() != snapshot.isLocalCopy() )
                    {
                        s.setLocalCopy( snapshot.isLocalCopy() );
                        changed = true;
                    }
                }
            }
        }
        return changed;
    }
          
}
