/*
 =================== DO NOT EDIT THIS FILE ====================
 Generated by Modello 1.0.1 on 2009-03-18 15:06:37,
 any modifications will be overwritten.
 ==============================================================
 */

package org.apache.maven.artifact.repository.metadata;

/**
 * Versioning information for an artifact.
 * 
 * @version $Revision$ $Date$
 */
public class Versioning
    implements java.io.Serializable
{

      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * What the latest version in the directory is, including
     * snapshots.
     */
    private String latest;

    /**
     * What the latest version in the directory is, of the releases.
     */
    private String release;

    /**
     * The current snapshot data in use for this version.
     */
    private Snapshot snapshot;

    /**
     * Field versions.
     */
    private java.util.List/*<String>*/ versions;

    /**
     * When the metadata was last updated.
     */
    private String lastUpdated;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method addVersion.
     * 
     * @param string
     */
    public void addVersion( String string )
    {
        if ( !(string instanceof String) )
        {
            throw new ClassCastException( "Versioning.addVersions(string) parameter must be instanceof " + String.class.getName() );
        }
        getVersions().add( string );
    } //-- void addVersion( String )

    /**
     * Get when the metadata was last updated.
     * 
     * @return String
     */
    public String getLastUpdated()
    {
        return this.lastUpdated;
    } //-- String getLastUpdated()

    /**
     * Get what the latest version in the directory is, including
     * snapshots.
     * 
     * @return String
     */
    public String getLatest()
    {
        return this.latest;
    } //-- String getLatest()

    /**
     * Get what the latest version in the directory is, of the
     * releases.
     * 
     * @return String
     */
    public String getRelease()
    {
        return this.release;
    } //-- String getRelease()

    /**
     * Get the current snapshot data in use for this version.
     * 
     * @return Snapshot
     */
    public Snapshot getSnapshot()
    {
        return this.snapshot;
    } //-- Snapshot getSnapshot()

    /**
     * Method getVersions.
     * 
     * @return List
     */
    public java.util.List/*<String>*/ getVersions()
    {
        if ( this.versions == null )
        {
            this.versions = new java.util.ArrayList/*<String>*/();
        }

        return this.versions;
    } //-- java.util.List/*<String>*/ getVersions()

    /**
     * Method removeVersion.
     * 
     * @param string
     */
    public void removeVersion( String string )
    {
        if ( !(string instanceof String) )
        {
            throw new ClassCastException( "Versioning.removeVersions(string) parameter must be instanceof " + String.class.getName() );
        }
        getVersions().remove( string );
    } //-- void removeVersion( String )

    /**
     * Set when the metadata was last updated.
     * 
     * @param lastUpdated
     */
    public void setLastUpdated( String lastUpdated )
    {
        this.lastUpdated = lastUpdated;
    } //-- void setLastUpdated( String )

    /**
     * Set what the latest version in the directory is, including
     * snapshots.
     * 
     * @param latest
     */
    public void setLatest( String latest )
    {
        this.latest = latest;
    } //-- void setLatest( String )

    /**
     * Set what the latest version in the directory is, of the
     * releases.
     * 
     * @param release
     */
    public void setRelease( String release )
    {
        this.release = release;
    } //-- void setRelease( String )

    /**
     * Set the current snapshot data in use for this version.
     * 
     * @param snapshot
     */
    public void setSnapshot( Snapshot snapshot )
    {
        this.snapshot = snapshot;
    } //-- void setSnapshot( Snapshot )

    /**
     * Set versions available for the artifact.
     * 
     * @param versions
     */
    public void setVersions( java.util.List/*<String>*/ versions )
    {
        this.versions = versions;
    } //-- void setVersions( java.util.List )


    public void updateTimestamp()
    {
        setLastUpdatedTimestamp( new java.util.Date() );
    }

    public void setLastUpdatedTimestamp( java.util.Date date )
    {
        java.util.TimeZone timezone = java.util.TimeZone.getTimeZone( "UTC" );
        java.text.DateFormat fmt = new java.text.SimpleDateFormat( "yyyyMMddHHmmss" );
        fmt.setTimeZone( timezone );
        setLastUpdated( fmt.format( date ) );
    }
          
}
