/*
 * $Id$
 */

package org.apache.maven.plugin.registry;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.*;
import java.util.List;

/**
 * Class Plugin.
 * 
 * @version $Revision$ $Date$
 */
public class Plugin extends TrackableBase 
implements java.io.Serializable
{


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field groupId
     */
    private String groupId;

    /**
     * Field artifactId
     */
    private String artifactId;

    /**
     * Field lastChecked
     */
    private String lastChecked;

    /**
     * Field useVersion
     */
    private String useVersion;

    /**
     * Field rejectedVersions
     */
    private java.util.List rejectedVersions;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method addRejectedVersion
     * 
     * @param string
     */
    public void addRejectedVersion(String string)
    {
        getRejectedVersions().add( string );
    } //-- void addRejectedVersion(String) 

    /**
     * Method getArtifactId
     */
    public String getArtifactId()
    {
        return this.artifactId;
    } //-- String getArtifactId() 

    /**
     * Method getGroupId
     */
    public String getGroupId()
    {
        return this.groupId;
    } //-- String getGroupId() 

    /**
     * Method getLastChecked
     */
    public String getLastChecked()
    {
        return this.lastChecked;
    } //-- String getLastChecked() 

    /**
     * Method getRejectedVersions
     */
    public java.util.List getRejectedVersions()
    {
        if ( this.rejectedVersions == null )
        {
            this.rejectedVersions = new java.util.ArrayList();
        }
        
        return this.rejectedVersions;
    } //-- java.util.List getRejectedVersions() 

    /**
     * Method getUseVersion
     */
    public String getUseVersion()
    {
        return this.useVersion;
    } //-- String getUseVersion() 

    /**
     * Method removeRejectedVersion
     * 
     * @param string
     */
    public void removeRejectedVersion(String string)
    {
        getRejectedVersions().remove( string );
    } //-- void removeRejectedVersion(String) 

    /**
     * Method setArtifactId
     * 
     * @param artifactId
     */
    public void setArtifactId(String artifactId)
    {
        this.artifactId = artifactId;
    } //-- void setArtifactId(String) 

    /**
     * Method setGroupId
     * 
     * @param groupId
     */
    public void setGroupId(String groupId)
    {
        this.groupId = groupId;
    } //-- void setGroupId(String) 

    /**
     * Method setLastChecked
     * 
     * @param lastChecked
     */
    public void setLastChecked(String lastChecked)
    {
        this.lastChecked = lastChecked;
    } //-- void setLastChecked(String) 

    /**
     * Method setRejectedVersions
     * 
     * @param rejectedVersions
     */
    public void setRejectedVersions(java.util.List rejectedVersions)
    {
        this.rejectedVersions = rejectedVersions;
    } //-- void setRejectedVersions(java.util.List) 

    /**
     * Method setUseVersion
     * 
     * @param useVersion
     */
    public void setUseVersion(String useVersion)
    {
        this.useVersion = useVersion;
    } //-- void setUseVersion(String) 


    public static final String LAST_CHECKED_DATE_FORMAT = "yyyy-MM-dd.HH:mm:ss Z";
    
    public String getKey()
    {
        return getGroupId() + ":" + getArtifactId();
    }
          }
